/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineInitializationListener;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineOptions;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.internal.apiimpl.ViatraQueryEngineImpl;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class ViatraQueryEngineManager {
    private static ViatraQueryEngineManager instance = new ViatraQueryEngineManager();
    Map<QueryScope, WeakReference<ViatraQueryEngineImpl>> engines = new WeakHashMap<QueryScope, WeakReference<ViatraQueryEngineImpl>>();
    private final Set<ViatraQueryEngineInitializationListener> initializationListeners = new HashSet<ViatraQueryEngineInitializationListener>();

    public static ViatraQueryEngineManager getInstance() {
        return instance;
    }

    ViatraQueryEngineManager() {
    }

    public ViatraQueryEngine getQueryEngine(QueryScope scope) throws ViatraQueryException {
        return this.getQueryEngine(scope, ViatraQueryEngineOptions.DEFAULT);
    }

    public ViatraQueryEngine getQueryEngine(QueryScope scope, ViatraQueryEngineOptions options) throws ViatraQueryException {
        ViatraQueryEngineImpl engine = this.getEngineInternal(scope);
        if (engine == null) {
            engine = new ViatraQueryEngineImpl(this, scope, options);
            this.engines.put(scope, new WeakReference<ViatraQueryEngineImpl>(engine));
            this.notifyInitializationListeners(engine);
        }
        return engine;
    }

    public ViatraQueryEngine getQueryEngineIfExists(QueryScope scope) {
        return this.getEngineInternal(scope);
    }

    public Set<ViatraQueryEngine> getExistingQueryEngines() {
        HashSet existingEngines = null;
        for (WeakReference<ViatraQueryEngineImpl> engineRef : this.engines.values()) {
            ViatraQueryEngineImpl engine;
            ViatraQueryEngineImpl viatraQueryEngineImpl = engine = engineRef == null ? null : (ViatraQueryEngineImpl)engineRef.get();
            if (existingEngines == null) {
                existingEngines = Sets.newHashSet();
            }
            existingEngines.add(engine);
        }
        if (existingEngines == null) {
            existingEngines = Collections.emptySet();
        }
        return existingEngines;
    }

    public void addQueryEngineInitializationListener(ViatraQueryEngineInitializationListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot add null listener!");
        this.initializationListeners.add(listener);
    }

    public void removeQueryEngineInitializationListener(ViatraQueryEngineInitializationListener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"Cannot remove null listener!");
        this.initializationListeners.remove(listener);
    }

    protected void notifyInitializationListeners(AdvancedViatraQueryEngine engine) {
        try {
            if (!this.initializationListeners.isEmpty()) {
                for (ViatraQueryEngineInitializationListener listener : Sets.newHashSet(this.initializationListeners)) {
                    listener.engineInitialized(engine);
                }
            }
        }
        catch (Exception ex) {
            ViatraQueryLoggingUtil.getLogger(this.getClass()).fatal((Object)"VIATRA Query Engine Manager encountered an error in delivering notifications about engine initialization. ", (Throwable)ex);
        }
    }

    private ViatraQueryEngineImpl getEngineInternal(QueryScope scope) {
        WeakReference<ViatraQueryEngineImpl> engineRef = this.engines.get(scope);
        ViatraQueryEngineImpl engine = engineRef == null ? null : (ViatraQueryEngineImpl)engineRef.get();
        return engine;
    }
}

