/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.specific.event;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;

public class ViatraQueryMatchEventFilter<Match extends IPatternMatch>
implements EventFilter<Match> {
    private Match filterMatch;

    public Match getFilterMatch() {
        return this.filterMatch;
    }

    @Override
    public boolean isProcessable(Match eventAtom) {
        if (this.filterMatch == null) {
            return true;
        }
        return this.filterMatch.isCompatibleWith(eventAtom);
    }

    protected ViatraQueryMatchEventFilter(Match filterMatch) {
        Preconditions.checkArgument((filterMatch != null ? 1 : 0) != 0, (Object)"Cannot create filter with null match");
        this.filterMatch = filterMatch;
    }

    protected ViatraQueryMatchEventFilter() {
    }

    public static <Match extends IPatternMatch> ViatraQueryMatchEventFilter<Match> createFilter(Match eventAtom) {
        Preconditions.checkArgument((eventAtom != null ? 1 : 0) != 0, (Object)"Cannot create filter for null match, use createEmptyFilter() instead!");
        Preconditions.checkArgument((!eventAtom.isMutable() ? 1 : 0) != 0, (Object)"Cannot create filter for mutable match!");
        return new ViatraQueryMatchEventFilter<Match>(eventAtom);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.filterMatch});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViatraQueryMatchEventFilter other = (ViatraQueryMatchEventFilter)obj;
        return Objects.equal(this.filterMatch, other.filterMatch);
    }
}

