/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors.report2;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.wb.internal.core.editor.errors.report2.IReportEntry;

public abstract class FileReportEntry
implements IReportEntry {
    private final String m_filePath;

    public FileReportEntry(String name) {
        this.m_filePath = name;
    }

    public void write(ZipOutputStream zipStream) throws Exception {
        InputStream fileStream = this.getContents();
        if (fileStream != null) {
            zipStream.putNextEntry(new ZipEntry(this.getName()));
            try {
                IOUtils.copy((InputStream)fileStream, (OutputStream)zipStream);
            }
            finally {
                zipStream.closeEntry();
                IOUtils.closeQuietly((InputStream)fileStream);
            }
        }
    }

    protected InputStream getContents() throws Exception {
        File file = new File(this.m_filePath);
        if (FileReportEntry.checkFile(file)) {
            return new FileInputStream(file);
        }
        return null;
    }

    protected final String getFilePath() {
        return this.m_filePath;
    }

    protected String getName() {
        return this.m_filePath;
    }

    public static boolean checkFile(File file) {
        if (file.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(file);
                inputStream.read();
            }
            catch (Throwable throwable) {
                try {}
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable2;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            IOUtils.closeQuietly((InputStream)inputStream);
            return true;
        }
        return false;
    }
}

