/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;

public class StringAreaDialogField
extends DialogField {
    private final int fRows;
    private String fText;
    private Text fTextControl;
    private ModifyListener fModifyListener;

    public StringAreaDialogField(int rows) {
        this.fRows = rows;
        this.fText = "";
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)StringAreaDialogField.gridDataForLabel(1));
        Text text = this.getTextControl(parent);
        GridDataFactory.create((Control)text).spanH(nColumns - 1).hintVC(this.fRows).fill();
        return new Control[]{label, text};
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected static GridData gridDataForText(int span) {
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        return gd;
    }

    public boolean setFocus() {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setFocus();
            this.fTextControl.setSelection(0, this.fTextControl.getText().length());
        }
        return true;
    }

    public Text getTextControl(Composite parent) {
        if (this.fTextControl == null) {
            this.assertCompositeNotNull(parent);
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    StringAreaDialogField.this.doModifyText(e);
                }
            };
            this.fTextControl = new Text(parent, 2114);
            this.fTextControl.setText(this.fText);
            this.fTextControl.setFont(parent.getFont());
            this.fTextControl.addModifyListener(this.fModifyListener);
            this.fTextControl.setEnabled(this.isEnabled());
        }
        return this.fTextControl;
    }

    private void doModifyText(ModifyEvent e) {
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fText = this.fTextControl.getText();
        }
        this.dialogFieldChanged();
    }

    protected void updateEnableState() {
        super.updateEnableState();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setEnabled(this.isEnabled());
        }
    }

    public String getText() {
        return this.fText;
    }

    public void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.setText(text);
        } else {
            this.dialogFieldChanged();
        }
    }

    public void setTextWithoutUpdate(String text) {
        this.fText = text;
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.fTextControl.removeModifyListener(this.fModifyListener);
            this.fTextControl.setText(text);
            this.fTextControl.addModifyListener(this.fModifyListener);
        }
    }

    public void refresh() {
        super.refresh();
        if (this.isOkToUse((Control)this.fTextControl)) {
            this.setTextWithoutUpdate(this.fText);
        }
    }
}

