/*
 * Decompiled with CFR 0.152.
 */
package com.spotify.docker.client;

import com.google.common.base.Strings;
import com.spotify.docker.client.EventStream;
import com.spotify.docker.client.LogStream;
import com.spotify.docker.client.ProgressHandler;
import com.spotify.docker.client.exceptions.DockerException;
import com.spotify.docker.client.messages.AuthConfig;
import com.spotify.docker.client.messages.Container;
import com.spotify.docker.client.messages.ContainerChange;
import com.spotify.docker.client.messages.ContainerConfig;
import com.spotify.docker.client.messages.ContainerCreation;
import com.spotify.docker.client.messages.ContainerExit;
import com.spotify.docker.client.messages.ContainerInfo;
import com.spotify.docker.client.messages.ContainerStats;
import com.spotify.docker.client.messages.ExecCreation;
import com.spotify.docker.client.messages.ExecState;
import com.spotify.docker.client.messages.Image;
import com.spotify.docker.client.messages.ImageHistory;
import com.spotify.docker.client.messages.ImageInfo;
import com.spotify.docker.client.messages.ImageSearchResult;
import com.spotify.docker.client.messages.Info;
import com.spotify.docker.client.messages.Network;
import com.spotify.docker.client.messages.NetworkConfig;
import com.spotify.docker.client.messages.NetworkCreation;
import com.spotify.docker.client.messages.RemovedImage;
import com.spotify.docker.client.messages.ServiceCreateResponse;
import com.spotify.docker.client.messages.TopResults;
import com.spotify.docker.client.messages.Version;
import com.spotify.docker.client.messages.Volume;
import com.spotify.docker.client.messages.VolumeList;
import com.spotify.docker.client.messages.swarm.Service;
import com.spotify.docker.client.messages.swarm.ServiceSpec;
import com.spotify.docker.client.messages.swarm.Swarm;
import com.spotify.docker.client.messages.swarm.Task;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;

public interface DockerClient
extends Closeable {
    public String ping() throws DockerException, InterruptedException;

    public Version version() throws DockerException, InterruptedException;

    public int auth(AuthConfig var1) throws DockerException, InterruptedException;

    public Info info() throws DockerException, InterruptedException;

    public List<Container> listContainers(ListContainersParam ... var1) throws DockerException, InterruptedException;

    public List<Image> listImages(ListImagesParam ... var1) throws DockerException, InterruptedException;

    public ContainerInfo inspectContainer(String var1) throws DockerException, InterruptedException;

    public ContainerCreation commitContainer(String var1, String var2, String var3, ContainerConfig var4, String var5, String var6) throws DockerException, InterruptedException;

    public ImageInfo inspectImage(String var1) throws DockerException, InterruptedException;

    public List<RemovedImage> removeImage(String var1) throws DockerException, InterruptedException;

    public List<RemovedImage> removeImage(String var1, boolean var2, boolean var3) throws DockerException, InterruptedException;

    public List<ImageSearchResult> searchImages(String var1) throws DockerException, InterruptedException;

    @Deprecated
    public void load(String var1, InputStream var2) throws DockerException, InterruptedException;

    @Deprecated
    public void load(String var1, InputStream var2, ProgressHandler var3) throws DockerException, InterruptedException;

    @Deprecated
    public void load(String var1, InputStream var2, AuthConfig var3) throws DockerException, InterruptedException;

    @Deprecated
    public void load(String var1, InputStream var2, AuthConfig var3, ProgressHandler var4) throws DockerException, InterruptedException;

    public void load(InputStream var1) throws DockerException, InterruptedException;

    public void create(String var1, InputStream var2) throws DockerException, InterruptedException;

    public void create(String var1, InputStream var2, ProgressHandler var3) throws DockerException, InterruptedException;

    public InputStream save(String ... var1) throws DockerException, IOException, InterruptedException;

    @Deprecated
    public InputStream save(String var1, AuthConfig var2) throws DockerException, IOException, InterruptedException;

    public InputStream saveMultiple(String ... var1) throws DockerException, IOException, InterruptedException;

    public TopResults topContainer(String var1) throws DockerException, InterruptedException;

    public TopResults topContainer(String var1, String var2) throws DockerException, InterruptedException;

    public void pull(String var1) throws DockerException, InterruptedException;

    public void pull(String var1, ProgressHandler var2) throws DockerException, InterruptedException;

    public void pull(String var1, AuthConfig var2) throws DockerException, InterruptedException;

    public void pull(String var1, AuthConfig var2, ProgressHandler var3) throws DockerException, InterruptedException;

    public void push(String var1) throws DockerException, InterruptedException;

    public void push(String var1, ProgressHandler var2) throws DockerException, InterruptedException;

    public void push(String var1, AuthConfig var2) throws DockerException, InterruptedException;

    public void push(String var1, ProgressHandler var2, AuthConfig var3) throws DockerException, InterruptedException;

    public void tag(String var1, String var2) throws DockerException, InterruptedException;

    public void tag(String var1, String var2, boolean var3) throws DockerException, InterruptedException;

    public String build(Path var1, BuildParam ... var2) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, String var2, BuildParam ... var3) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, ProgressHandler var2, BuildParam ... var3) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, String var2, ProgressHandler var3, BuildParam ... var4) throws DockerException, InterruptedException, IOException;

    public String build(Path var1, String var2, String var3, ProgressHandler var4, BuildParam ... var5) throws DockerException, InterruptedException, IOException;

    public List<ImageHistory> history(String var1) throws InterruptedException, DockerException;

    public ContainerCreation createContainer(ContainerConfig var1) throws DockerException, InterruptedException;

    public ContainerCreation createContainer(ContainerConfig var1, String var2) throws DockerException, InterruptedException;

    public void renameContainer(String var1, String var2) throws DockerException, InterruptedException;

    public void startContainer(String var1) throws DockerException, InterruptedException;

    public void stopContainer(String var1, int var2) throws DockerException, InterruptedException;

    public void pauseContainer(String var1) throws DockerException, InterruptedException;

    public void unpauseContainer(String var1) throws DockerException, InterruptedException;

    public void restartContainer(String var1) throws DockerException, InterruptedException;

    public void restartContainer(String var1, int var2) throws DockerException, InterruptedException;

    public ContainerExit waitContainer(String var1) throws DockerException, InterruptedException;

    public void killContainer(String var1) throws DockerException, InterruptedException;

    public void removeContainer(String var1) throws DockerException, InterruptedException;

    public void removeContainer(String var1, RemoveContainerParam ... var2) throws DockerException, InterruptedException;

    @Deprecated
    public void removeContainer(String var1, boolean var2) throws DockerException, InterruptedException;

    public InputStream exportContainer(String var1) throws DockerException, InterruptedException;

    @Deprecated
    public InputStream copyContainer(String var1, String var2) throws DockerException, InterruptedException;

    public InputStream archiveContainer(String var1, String var2) throws DockerException, InterruptedException;

    public void copyToContainer(Path var1, String var2, String var3) throws DockerException, InterruptedException, IOException;

    public List<ContainerChange> inspectContainerChanges(String var1) throws DockerException, InterruptedException;

    public LogStream logs(String var1, LogsParam ... var2) throws DockerException, InterruptedException;

    public EventStream events(EventsParam ... var1) throws DockerException, InterruptedException;

    public ExecCreation execCreate(String var1, String[] var2, ExecCreateParam ... var3) throws DockerException, InterruptedException;

    public LogStream execStart(String var1, ExecStartParameter ... var2) throws DockerException, InterruptedException;

    public Swarm inspectSwarm() throws DockerException, InterruptedException;

    public ServiceCreateResponse createService(ServiceSpec var1) throws DockerException, InterruptedException;

    public ServiceCreateResponse createService(ServiceSpec var1, AuthConfig var2) throws DockerException, InterruptedException;

    public Service inspectService(String var1) throws DockerException, InterruptedException;

    public void updateService(String var1, Long var2, ServiceSpec var3) throws DockerException, InterruptedException;

    public List<Service> listServices() throws DockerException, InterruptedException;

    public List<Service> listServices(Service.Criteria var1) throws DockerException, InterruptedException;

    public void removeService(String var1) throws DockerException, InterruptedException;

    public Task inspectTask(String var1) throws DockerException, InterruptedException;

    public List<Task> listTasks() throws DockerException, InterruptedException;

    public List<Task> listTasks(Task.Criteria var1) throws DockerException, InterruptedException;

    public void execResizeTty(String var1, Integer var2, Integer var3) throws DockerException, InterruptedException;

    public ExecState execInspect(String var1) throws DockerException, InterruptedException;

    public ContainerStats stats(String var1) throws DockerException, InterruptedException;

    public void resizeTty(String var1, Integer var2, Integer var3) throws DockerException, InterruptedException;

    public List<Network> listNetworks() throws DockerException, InterruptedException;

    public Network inspectNetwork(String var1) throws DockerException, InterruptedException;

    public NetworkCreation createNetwork(NetworkConfig var1) throws DockerException, InterruptedException;

    public void removeNetwork(String var1) throws DockerException, InterruptedException;

    public void connectToNetwork(String var1, String var2) throws DockerException, InterruptedException;

    public void disconnectFromNetwork(String var1, String var2) throws DockerException, InterruptedException;

    @Override
    public void close();

    public LogStream attachContainer(String var1, AttachParameter ... var2) throws DockerException, InterruptedException;

    public String getHost();

    public Volume createVolume() throws DockerException, InterruptedException;

    public Volume createVolume(Volume var1) throws DockerException, InterruptedException;

    public Volume inspectVolume(String var1) throws DockerException, InterruptedException;

    public void removeVolume(Volume var1) throws DockerException, InterruptedException;

    public void removeVolume(String var1) throws DockerException, InterruptedException;

    public VolumeList listVolumes(ListVolumesParam ... var1) throws DockerException, InterruptedException;

    public static class ListVolumesFilterParam
    extends ListVolumesParam {
        public ListVolumesFilterParam(String name, String value) {
            super(name, value);
        }
    }

    public static class ListVolumesParam {
        private final String name;
        private final String value;

        private ListVolumesParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static ListVolumesParam filter(String name, String value) {
            return new ListVolumesFilterParam(name, value);
        }

        public static ListVolumesParam dangling() {
            return ListVolumesParam.dangling(true);
        }

        public static ListVolumesParam dangling(Boolean dangling) {
            return ListVolumesParam.filter("dangling", dangling.toString());
        }

        public static ListVolumesParam name(String name) {
            return ListVolumesParam.filter("name", name);
        }

        public static ListVolumesParam driver(String driver) {
            return ListVolumesParam.filter("driver", driver);
        }
    }

    public static class EventsFilterParam
    extends EventsParam {
        public EventsFilterParam(String name, String value) {
            super(name, value);
        }
    }

    public static class EventsParam {
        private final String name;
        private final String value;

        private EventsParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static EventsParam until(Long until) {
            return new EventsParam("until", String.valueOf(until));
        }

        public static EventsParam since(Long since) {
            return new EventsParam("since", String.valueOf(since));
        }

        private static EventsParam filter(String name, String value) {
            return new EventsFilterParam(name, value);
        }

        public static EventsParam event(String event) {
            return EventsParam.filter("event", event);
        }

        public static EventsParam image(String image) {
            return EventsParam.filter("image", image);
        }

        public static EventsParam container(String container) {
            return EventsParam.filter("container", container);
        }

        public static EventsParam volume(String volume) {
            return EventsParam.filter("volume", volume);
        }

        public static EventsParam network(String network) {
            return EventsParam.filter("network", network);
        }

        public static EventsParam daemon(String daemon) {
            return EventsParam.filter("daemon", daemon);
        }

        public static EventsParam type(String type) {
            return EventsParam.filter("type", type);
        }

        public static EventsParam label(String label, String value) {
            return Strings.isNullOrEmpty((String)value) ? EventsParam.filter("label", label) : EventsParam.filter("label", label + "=" + value);
        }

        public static EventsParam label(String label) {
            return EventsParam.label(label, null);
        }
    }

    public static class ListImagesFilterParam
    extends ListImagesParam {
        public ListImagesFilterParam(String name, String value) {
            super(name, value);
        }
    }

    public static class ListImagesParam {
        private final String name;
        private final String value;

        public ListImagesParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public static ListImagesParam create(String name, String value) {
            return new ListImagesParam(name, value);
        }

        public static ListImagesParam filter(String name, String value) {
            return new ListImagesFilterParam(name, value);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static ListImagesParam allImages() {
            return ListImagesParam.allImages(true);
        }

        public static ListImagesParam allImages(boolean all) {
            return ListImagesParam.create("all", String.valueOf(all));
        }

        public static ListImagesParam digests() {
            return ListImagesParam.create("digests", "1");
        }

        public static ListImagesParam danglingImages() {
            return ListImagesParam.danglingImages(true);
        }

        public static ListImagesParam danglingImages(boolean dangling) {
            return ListImagesParam.filter("dangling", String.valueOf(dangling));
        }

        public static ListImagesParam withLabel(String label, String value) {
            return Strings.isNullOrEmpty((String)value) ? ListImagesParam.filter("label", label) : ListImagesParam.filter("label", label + "=" + value);
        }

        public static ListImagesParam withLabel(String label) {
            return ListImagesParam.withLabel(label, null);
        }

        public static ListImagesParam byName(String name) {
            return ListImagesParam.create("filter", name);
        }
    }

    public static class ListContainersFilterParam
    extends ListContainersParam {
        public ListContainersFilterParam(String name, String value) {
            super(name, value);
        }
    }

    public static class ListContainersParam {
        private final String name;
        private final String value;

        public ListContainersParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public static ListContainersParam create(String name, String value) {
            return new ListContainersParam(name, value);
        }

        public static ListContainersParam filter(String key, String value) {
            return new ListContainersFilterParam(key, value);
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static ListContainersParam allContainers() {
            return ListContainersParam.allContainers(true);
        }

        public static ListContainersParam allContainers(boolean all) {
            return ListContainersParam.create("all", all ? "1" : "0");
        }

        public static ListContainersParam limitContainers(Integer limit) {
            return ListContainersParam.create("limit", String.valueOf(limit));
        }

        public static ListContainersParam containersCreatedSince(String id) {
            return ListContainersParam.create("since", id);
        }

        public static ListContainersParam containersCreatedBefore(String id) {
            return ListContainersParam.create("before", String.valueOf(id));
        }

        public static ListContainersParam withContainerSizes(Boolean size) {
            return ListContainersParam.create("size", String.valueOf(size));
        }

        public static ListContainersParam withExitStatus(int exitStatus) {
            return ListContainersParam.filter("exited", String.valueOf(exitStatus));
        }

        public static ListContainersParam withStatusCreated() {
            return ListContainersParam.filter("status", "created");
        }

        public static ListContainersParam withStatusRestarting() {
            return ListContainersParam.filter("status", "restarting");
        }

        public static ListContainersParam withStatusRunning() {
            return ListContainersParam.filter("status", "running");
        }

        public static ListContainersParam withStatusPaused() {
            return ListContainersParam.filter("status", "paused");
        }

        public static ListContainersParam withStatusExited() {
            return ListContainersParam.filter("status", "exited");
        }

        @Deprecated
        public static ListContainersParam exitedContainers() {
            return ListContainersParam.withStatusExited();
        }

        public static ListContainersParam withLabel(String label, String value) {
            return Strings.isNullOrEmpty((String)value) ? ListContainersParam.filter("label", label) : ListContainersParam.filter("label", label + "=" + value);
        }

        public static ListContainersParam withLabel(String label) {
            return ListContainersParam.withLabel(label, null);
        }
    }

    public static enum AttachParameter {
        LOGS,
        STREAM,
        STDIN,
        STDOUT,
        STDERR;

    }

    public static class LogsParam {
        private final String name;
        private final String value;

        public LogsParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static LogsParam follow() {
            return LogsParam.follow(true);
        }

        public static LogsParam follow(boolean follow) {
            return LogsParam.create("follow", String.valueOf(follow));
        }

        public static LogsParam stdout() {
            return LogsParam.stdout(true);
        }

        public static LogsParam stdout(boolean stdout) {
            return LogsParam.create("stdout", String.valueOf(stdout));
        }

        public static LogsParam stderr() {
            return LogsParam.stderr(true);
        }

        public static LogsParam stderr(boolean stderr) {
            return LogsParam.create("stderr", String.valueOf(stderr));
        }

        public static LogsParam since(Integer timestamp) {
            return LogsParam.create("since", String.valueOf(timestamp));
        }

        public static LogsParam timestamps() {
            return LogsParam.timestamps(true);
        }

        public static LogsParam timestamps(boolean timestamps) {
            return LogsParam.create("timestamps", String.valueOf(timestamps));
        }

        public static LogsParam tail(Integer lines) {
            return LogsParam.create("tail", String.valueOf(lines));
        }

        public static LogsParam create(String name, String value) {
            return new LogsParam(name, value);
        }
    }

    public static class ExecCreateParam {
        private final String name;
        private final String value;

        private ExecCreateParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        private static ExecCreateParam create(String name, String value) {
            return new ExecCreateParam(name, value);
        }

        public static ExecCreateParam detach(boolean detach) {
            return ExecCreateParam.create("Detach", String.valueOf(detach));
        }

        public static ExecCreateParam detach() {
            return ExecCreateParam.detach(true);
        }

        public static ExecCreateParam attachStdin(boolean attachStdin) {
            return ExecCreateParam.create("AttachStdin", String.valueOf(attachStdin));
        }

        public static ExecCreateParam attachStdin() {
            return ExecCreateParam.attachStdin(true);
        }

        public static ExecCreateParam attachStderr(boolean attachStderr) {
            return ExecCreateParam.create("AttachStderr", String.valueOf(attachStderr));
        }

        public static ExecCreateParam attachStderr() {
            return ExecCreateParam.attachStderr(true);
        }

        public static ExecCreateParam attachStdout(boolean attachStdout) {
            return ExecCreateParam.create("AttachStdout", String.valueOf(attachStdout));
        }

        public static ExecCreateParam attachStdout() {
            return ExecCreateParam.attachStdout(true);
        }

        public static ExecCreateParam privileged(boolean privileged) {
            return ExecCreateParam.create("Privileged", String.valueOf(privileged));
        }

        public static ExecCreateParam privileged() {
            return ExecCreateParam.privileged(true);
        }

        public static ExecCreateParam tty(boolean tty) {
            return ExecCreateParam.create("Tty", String.valueOf(tty));
        }

        public static ExecCreateParam tty() {
            return ExecCreateParam.tty(true);
        }

        public static ExecCreateParam user(String user) {
            return ExecCreateParam.create("User", user);
        }
    }

    public static enum ExecStartParameter {
        DETACH("Detach"),
        TTY("Tty");

        private final String name;

        private ExecStartParameter(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class RemoveContainerParam {
        private final String name;
        private final String value;

        public RemoveContainerParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public static RemoveContainerParam create(String name, String value) {
            return new RemoveContainerParam(name, value);
        }

        public static RemoveContainerParam removeVolumes() {
            return RemoveContainerParam.removeVolumes(true);
        }

        public static RemoveContainerParam removeVolumes(boolean remove) {
            return RemoveContainerParam.create("v", remove ? "1" : "0");
        }

        public static RemoveContainerParam forceKill() {
            return RemoveContainerParam.forceKill(true);
        }

        public static RemoveContainerParam forceKill(boolean force) {
            return RemoveContainerParam.create("force", force ? "1" : "0");
        }
    }

    public static class BuildParam {
        private final String name;
        private final String value;

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public BuildParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public static BuildParam create(String name, String value) {
            return new BuildParam(name, value);
        }

        public static BuildParam quiet() {
            return BuildParam.create("q", "true");
        }

        public static BuildParam rm() {
            return BuildParam.rm(true);
        }

        public static BuildParam rm(boolean rm) {
            return BuildParam.create("rm", String.valueOf(rm));
        }

        public static BuildParam noCache() {
            return BuildParam.create("nocache", "true");
        }

        public static BuildParam forceRm() {
            return BuildParam.create("forcerm", "true");
        }

        public static BuildParam pullNewerImage() {
            return BuildParam.create("pull", "true");
        }

        public static BuildParam name(String name) {
            return BuildParam.create("t", name);
        }

        public static BuildParam dockerfile(Path dockerfile) {
            return BuildParam.create("dockerfile", dockerfile.toString());
        }

        public static BuildParam remote(URI remote) {
            return BuildParam.create("remote", remote.toString());
        }

        public static BuildParam memory(Integer memory) {
            return BuildParam.create("memory", memory.toString());
        }

        public static BuildParam totalMemory(Integer totalMemory) {
            return BuildParam.create("memoryswap", totalMemory.toString());
        }

        public static BuildParam cpuShares(Integer cpuShares) {
            return BuildParam.create("cpushares", cpuShares.toString());
        }

        public static BuildParam cpusetCpus(Integer cpusetCpus) {
            return BuildParam.create("cpusetcpus", cpusetCpus.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BuildParam that = (BuildParam)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.value);
        }
    }
}

