/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.deltaddl;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.enablement.sybase.IGenericDdlConstants;
import org.eclipse.datatools.enablement.sybase.asa.ddl.SybaseASADdlBuilder;
import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASABaseTrigger;
import org.eclipse.datatools.enablement.sybase.ddl.ISybaseDdlGenerator;
import org.eclipse.datatools.enablement.sybase.ddl.SybaseDdlScript;
import org.eclipse.datatools.enablement.sybase.deltaddl.IDeltaDdlGenProvider;
import org.eclipse.datatools.enablement.sybase.deltaddl.SybaseDeltaDdlGeneration;
import org.eclipse.datatools.enablement.sybase.parser.QuickSQLParser;
import org.eclipse.datatools.enablement.sybase.util.SQLUtil;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;

public class SybaseASATriggerDeltaDdlGenProvider
implements IDeltaDdlGenProvider,
IGenericDdlConstants {
    public void processAlterStatement(SQLObject element, Map modifyRecordMap, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, IProgressMonitor monitor) {
        if (!(element instanceof SybaseASABaseTrigger)) {
            return;
        }
        SybaseASABaseTrigger trigger = (SybaseASABaseTrigger)element;
        SybaseASADdlBuilder builder = SybaseASADdlBuilder.getInstance();
        List records = (List)modifyRecordMap.get(element);
        if (records != null) {
            String[] create = builder.createTrigger((Trigger)trigger, quoteIdentifiers, qualifyNames, fullSyntax);
            String comment = null;
            for (SybaseDeltaDdlGeneration.FeatureChangeRecord r : records) {
                if (r.feature.getFeatureID() == 1 && r.changed == trigger) {
                    String oldName = (String)r.oldValue;
                    if (quoteIdentifiers) {
                        oldName = SQLUtil.quote((String)oldName, (String)"\"");
                    }
                    if (qualifyNames) {
                        String schemaName = trigger.getSchema().getName();
                        String tableName = trigger.getSubjectTable().getName();
                        if (quoteIdentifiers) {
                            tableName = SQLUtil.quote((String)tableName, (String)"\"");
                        }
                        oldName = String.valueOf(schemaName) + "." + tableName + "." + oldName;
                    }
                    StringBuffer drop = new StringBuffer(128);
                    drop.append("DROP").append(" ").append("TRIGGER").append(" ").append(oldName);
                    script.addDropTriggerStatement(drop.toString());
                    int i = 0;
                    while (i < create.length) {
                        script.addCreateTriggerStatement(create[i]);
                        ++i;
                    }
                    return;
                }
                if (r.feature.getFeatureID() != 3) continue;
                comment = builder.createComment((SQLObject)trigger, quoteIdentifiers, qualifyNames, true);
            }
            if (records.size() == 1 && ((SybaseDeltaDdlGeneration.FeatureChangeRecord)records.get((int)0)).feature.getFeatureID() == 3) {
                script.addCreateTriggerStatement(comment);
                return;
            }
            QuickSQLParser parser = QuickSQLParser.getInstance();
            int[] createIndex = parser.find(create[0], new String[]{"CREATE"});
            if (createIndex[0] >= 0) {
                String alter = String.valueOf(create[0].substring(0, createIndex[0])) + "ALTER" + create[0].substring(createIndex[0] + 6);
                script.addCreateTriggerStatement(alter);
                if (comment != null) {
                    script.addCreateTriggerStatement(comment);
                }
            } else {
                int i = 0;
                while (i < create.length) {
                    script.addCreateTriggerStatement(create[i]);
                    ++i;
                }
            }
        }
    }

    public void processCreateStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, boolean fullSyntax, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    public void processDropStatement(SQLObject element, boolean quoteIdentifiers, boolean qualifyNames, SybaseDdlScript script, ISybaseDdlGenerator generator, IProgressMonitor monitor) {
    }

    public void analyze(SQLObject element, Map changeMap, Map modificationRecords) {
    }
}

