/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.util.tracker;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.remoteservice.IRemoteFilter;
import org.eclipse.ecf.remoteservice.IRemoteService;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;
import org.eclipse.ecf.remoteservice.IRemoteServiceListener;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceRegisteredEvent;
import org.eclipse.ecf.remoteservice.events.IRemoteServiceUnregisteredEvent;
import org.eclipse.ecf.remoteservice.util.RemoteFilterImpl;
import org.eclipse.ecf.remoteservice.util.tracker.IRemoteServiceTrackerCustomizer;
import org.osgi.framework.InvalidSyntaxException;

public class RemoteServiceTracker
implements IRemoteServiceTrackerCustomizer {
    static final boolean DEBUG = Boolean.getBoolean("org.eclipse.ecf.remoteservice.util.tracker.RemoteServiceTracker.debug");
    protected final IRemoteServiceContainerAdapter containerAdapter;
    protected final ID[] containerIDs;
    protected final IRemoteFilter filter;
    final IRemoteServiceTrackerCustomizer customizer;
    private final String listenerFilter;
    private final String trackClass;
    private final IRemoteServiceReference trackReference;
    final boolean noUserFilter;
    private volatile Tracked tracked;
    private volatile int trackingCount = -1;
    private volatile IRemoteServiceReference cachedReference;
    private volatile IRemoteService cachedService;

    public RemoteServiceTracker(IRemoteServiceContainerAdapter containerAdapter, ID[] containerIDs, IRemoteServiceReference reference, IRemoteServiceTrackerCustomizer customizer) {
        this.containerAdapter = containerAdapter;
        this.trackReference = reference;
        this.containerIDs = containerIDs;
        this.trackClass = null;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(&(ecf.robjectClass=" + ((String[])reference.getProperty("ecf.robjectClass"))[0] + ")(" + "ecf.rsvc.id" + "=" + reference.getProperty("ecf.rsvc.id").toString() + "))";
        this.noUserFilter = true;
        try {
            this.filter = new RemoteFilterImpl(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    public RemoteServiceTracker(IRemoteServiceContainerAdapter containerAdapter, ID[] containerIDs, String clazz, IRemoteServiceTrackerCustomizer customizer) {
        this.containerAdapter = containerAdapter;
        this.trackReference = null;
        this.trackClass = clazz;
        this.containerIDs = containerIDs;
        this.customizer = customizer == null ? this : customizer;
        this.listenerFilter = "(ecf.robjectClass=" + clazz.toString() + ")";
        this.noUserFilter = true;
        try {
            this.filter = new RemoteFilterImpl(this.listenerFilter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("unexpected InvalidSyntaxException: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open() {
        if (this.tracked != null) {
            return;
        }
        if (DEBUG) {
            System.out.println("RemoteServiceTracker.open: " + this.filter);
        }
        this.tracked = new Tracked();
        this.trackingCount = 0;
        Tracked tracked = this.tracked;
        synchronized (tracked) {
            try {
                this.containerAdapter.addRemoteServiceListener(this.tracked);
                IRemoteServiceReference[] references = this.trackReference != null ? new IRemoteServiceReference[]{this.trackReference} : this.getInitialReferences(this.containerIDs, this.trackClass, this.noUserFilter ? null : this.filter.toString());
                this.tracked.setInitialServices(references);
            }
            catch (InvalidSyntaxException e) {
                throw new RuntimeException("unexpected InvalidSyntaxException: " + e.getMessage());
            }
        }
        this.tracked.trackInitialServices();
    }

    private IRemoteServiceReference[] getInitialReferences(ID[] ids, String clazz, String filterString) throws InvalidSyntaxException {
        return this.containerAdapter.getRemoteServiceReferences(ids, clazz, filterString);
    }

    public synchronized void close() {
        if (this.tracked == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("RemoteServiceTracker.close: " + this.filter);
        }
        this.tracked.close();
        IRemoteServiceReference[] references = this.getRemoteServiceReferences();
        Tracked outgoing = this.tracked;
        this.tracked = null;
        try {
            this.containerAdapter.removeRemoteServiceListener(outgoing);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (references != null) {
            int i = 0;
            while (i < references.length) {
                outgoing.untrack(references[i]);
                ++i;
            }
        }
        this.trackingCount = -1;
        if (DEBUG && this.cachedReference == null && this.cachedService == null) {
            System.out.println("RemoteServiceTracker.close[cached cleared]: " + this.filter);
        }
    }

    public IRemoteService addingService(IRemoteServiceReference reference) {
        return this.containerAdapter.getRemoteService(reference);
    }

    public void modifiedService(IRemoteServiceReference reference, IRemoteService remoteService) {
    }

    public void removedService(IRemoteServiceReference reference, IRemoteService remoteService) {
        this.containerAdapter.ungetRemoteService(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteService waitForRemoteService(long timeout) throws InterruptedException {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        IRemoteService object = this.getRemoteService();
        while (object == null) {
            Tracked t = this.tracked;
            if (t == null) {
                return null;
            }
            Tracked tracked = t;
            synchronized (tracked) {
                if (t.size() == 0) {
                    t.wait(timeout);
                }
            }
            object = this.getRemoteService();
            if (timeout <= 0L) continue;
            return object;
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference[] getRemoteServiceReferences() {
        Tracked t = this.tracked;
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length;
            block6: {
                length = t.size();
                if (length != 0) break block6;
                return null;
            }
            IRemoteServiceReference[] references = new IRemoteServiceReference[length];
            Enumeration keys = t.keys();
            int i = 0;
            while (i < length) {
                references[i] = (IRemoteServiceReference)keys.nextElement();
                ++i;
            }
            return references;
        }
    }

    public IRemoteServiceReference getRemoteServiceReference() {
        IRemoteServiceReference[] references;
        int length;
        IRemoteServiceReference reference = this.cachedReference;
        if (reference != null) {
            if (DEBUG) {
                System.out.println("RemoteServiceTracker.getRemoteServiceReference[cached]: " + this.filter);
            }
            return reference;
        }
        if (DEBUG) {
            System.out.println("RemoteServiceTracker.getRemoteServiceReference: " + this.filter);
        }
        int n = length = (references = this.getRemoteServiceReferences()) == null ? 0 : references.length;
        if (length == 0) {
            return null;
        }
        int index = 0;
        if (length > 1) {
            int[] rankings = new int[length];
            int count = 0;
            int maxRanking = Integer.MIN_VALUE;
            int i = 0;
            while (i < length) {
                int ranking;
                Object property = references[i].getProperty("ecf.rsvc.ranking");
                rankings[i] = ranking = property instanceof Integer ? (Integer)property : 0;
                if (ranking > maxRanking) {
                    index = i;
                    maxRanking = ranking;
                    count = 1;
                } else if (ranking == maxRanking) {
                    ++count;
                }
                ++i;
            }
            if (count > 1) {
                long minId = Long.MAX_VALUE;
                int i2 = 0;
                while (i2 < length) {
                    long id;
                    if (rankings[i2] == maxRanking && (id = ((Long)references[i2].getProperty("ecf.rsvc.id")).longValue()) < minId) {
                        index = i2;
                        minId = id;
                    }
                    ++i2;
                }
            }
        }
        this.cachedReference = references[index];
        return this.cachedReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteService getRemoteService(IRemoteServiceReference reference) {
        Tracked t = this.tracked;
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            return (IRemoteService)t.get(reference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteService[] getRemoteServices() {
        Tracked t = this.tracked;
        if (t == null) {
            return null;
        }
        Tracked tracked = t;
        synchronized (tracked) {
            int length;
            IRemoteServiceReference[] references;
            block6: {
                references = this.getRemoteServiceReferences();
                int n = length = references == null ? 0 : references.length;
                if (length != 0) break block6;
                return null;
            }
            IRemoteService[] objects = new IRemoteService[length];
            int i = 0;
            while (i < length) {
                objects[i] = this.getRemoteService(references[i]);
                ++i;
            }
            return objects;
        }
    }

    public IRemoteService getRemoteService() {
        IRemoteServiceReference reference;
        IRemoteService service = this.cachedService;
        if (service != null) {
            if (DEBUG) {
                System.out.println("RemoteServiceTracker.getRemoteService[cached]: " + this.filter);
            }
            return service;
        }
        if (DEBUG) {
            System.out.println("RemoteServiceTracker.getRemoteService: " + this.filter);
        }
        if ((reference = this.getRemoteServiceReference()) == null) {
            return null;
        }
        this.cachedService = this.getRemoteService(reference);
        return this.cachedService;
    }

    public void remove(IRemoteServiceReference reference) {
        Tracked t = this.tracked;
        if (t == null) {
            return;
        }
        t.untrack(reference);
    }

    public int size() {
        Tracked t = this.tracked;
        if (t == null) {
            return 0;
        }
        return t.size();
    }

    public int getTrackingCount() {
        return this.trackingCount;
    }

    void modified() {
        ++this.trackingCount;
        this.cachedReference = null;
        this.cachedService = null;
        if (DEBUG) {
            System.out.println("RemoteServiceTracker.modified: " + this.filter);
        }
    }

    class AllTracked
    extends Tracked {
        private static final long serialVersionUID = 9135607806678825054L;

        protected AllTracked() {
        }
    }

    class Tracked
    extends Hashtable
    implements IRemoteServiceListener {
        private static final long serialVersionUID = 1457902368711966642L;
        private final ArrayList adding = new ArrayList(6);
        private volatile boolean closed = false;
        private final LinkedList initial = new LinkedList();

        protected Tracked() {
        }

        protected void setInitialServices(IRemoteServiceReference[] references) {
            if (references == null) {
                return;
            }
            int size = references.length;
            int i = 0;
            while (i < size) {
                if (DEBUG) {
                    System.out.println("RemoteServiceTracker.Tracked.setInitialServices: " + references[i]);
                }
                this.initial.add(references[i]);
                ++i;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void trackInitialServices() {
            while (true) {
                IRemoteServiceReference reference;
                Tracked tracked = this;
                synchronized (tracked) {
                    if (this.initial.size() == 0) {
                        return;
                    }
                    reference = (IRemoteServiceReference)this.initial.removeFirst();
                    if (this.get(reference) != null) {
                        if (DEBUG) {
                            System.out.println("RemoteServiceTracker.Tracked.trackInitialServices[already tracked]: " + reference);
                        }
                        continue;
                    }
                    if (this.adding.contains(reference)) {
                        if (DEBUG) {
                            System.out.println("RemoteServiceTracker.Tracked.trackInitialServices[already adding]: " + reference);
                        }
                        continue;
                    }
                    this.adding.add(reference);
                }
                if (DEBUG) {
                    System.out.println("RemoteServiceTracker.Tracked.trackInitialServices: " + reference);
                }
                this.trackAdding(reference);
            }
        }

        protected void close() {
            this.closed = true;
        }

        public void handleServiceEvent(IRemoteServiceEvent event) {
            if (this.closed) {
                return;
            }
            int type = 2;
            if (event instanceof IRemoteServiceRegisteredEvent) {
                type = 1;
            } else if (event instanceof IRemoteServiceUnregisteredEvent) {
                type = 4;
            }
            IRemoteServiceReference reference = event.getReference();
            if (DEBUG) {
                System.out.println("RemoteServiceTracker.Tracked.serviceChanged[" + event.getClass() + "]: " + reference);
            }
            switch (type) {
                case 1: 
                case 2: {
                    if (RemoteServiceTracker.this.noUserFilter) {
                        this.track(reference);
                        break;
                    }
                    if (RemoteServiceTracker.this.filter.match(reference)) {
                        this.track(reference);
                        break;
                    }
                    this.untrack(reference);
                    break;
                }
                case 4: {
                    this.untrack(reference);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void track(IRemoteServiceReference reference) {
            IRemoteService object;
            Tracked tracked = this;
            synchronized (tracked) {
                object = (IRemoteService)this.get(reference);
            }
            if (object != null) {
                if (DEBUG) {
                    System.out.println("RemoteServiceTracker.Tracked.track[modified]: " + reference);
                }
                tracked = this;
                synchronized (tracked) {
                    RemoteServiceTracker.this.modified();
                }
                RemoteServiceTracker.this.customizer.modifiedService(reference, object);
                return;
            }
            tracked = this;
            synchronized (tracked) {
                if (this.adding.contains(reference)) {
                    if (DEBUG) {
                        System.out.println("RemoteServiceTracker.Tracked.track[already adding]: " + reference);
                    }
                    return;
                }
                this.adding.add(reference);
            }
            this.trackAdding(reference);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trackAdding(IRemoteServiceReference reference) {
            if (DEBUG) {
                System.out.println("RemoteServiceTracker.Tracked.trackAdding: " + reference);
            }
            IRemoteService object = null;
            boolean becameUntracked = false;
            try {
                object = RemoteServiceTracker.this.customizer.addingService(reference);
            }
            catch (Throwable throwable) {
                Tracked tracked = this;
                synchronized (tracked) {
                    if (this.adding.remove(reference)) {
                        if (object != null) {
                            this.put(reference, object);
                            RemoteServiceTracker.this.modified();
                            this.notifyAll();
                        }
                    } else {
                        becameUntracked = true;
                    }
                }
                throw throwable;
            }
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.adding.remove(reference)) {
                    if (object != null) {
                        this.put(reference, object);
                        RemoteServiceTracker.this.modified();
                        this.notifyAll();
                    }
                } else {
                    becameUntracked = true;
                }
            }
            if (becameUntracked) {
                if (DEBUG) {
                    System.out.println("RemoteServiceTracker.Tracked.trackAdding[removed]: " + reference);
                }
                RemoteServiceTracker.this.customizer.removedService(reference, object);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void untrack(IRemoteServiceReference reference) {
            IRemoteService object;
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.initial.remove(reference)) {
                    if (DEBUG) {
                        System.out.println("RemoteServiceTracker.Tracked.untrack[removed from initial]: " + reference);
                    }
                    return;
                }
                if (this.adding.remove(reference)) {
                    if (DEBUG) {
                        System.out.println("RemoteServiceTracker.Tracked.untrack[being added]: " + reference);
                    }
                    return;
                }
                object = (IRemoteService)this.remove(reference);
                if (object == null) {
                    return;
                }
                RemoteServiceTracker.this.modified();
            }
            if (DEBUG) {
                System.out.println("RemoteServiceTracker.Tracked.untrack[removed]: " + reference);
            }
            RemoteServiceTracker.this.customizer.removedService(reference, object);
        }
    }
}

