/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.editor;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.editor.IDiagramEditorInput;
import org.eclipse.graphiti.ui.internal.T;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPartSite;

public final class ElementDeleteListener
extends AdapterImpl {
    private DiagramBehavior diagramBehavior;

    public ElementDeleteListener(DiagramBehavior diagramBehavior) {
        this.diagramBehavior = diagramBehavior;
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof EObject;
    }

    public void notifyChanged(Notification msg) {
        IDiagramEditorInput in;
        if (T.racer().debug()) {
            String editorName = this.diagramBehavior.getDiagramContainer().getTitle();
            T.racer().debug("Delete listener called of editor " + editorName + " with events " + msg.toString());
        }
        if ((in = this.diagramBehavior.getDiagramContainer().getDiagramEditorInput()) != null) {
            IWorkbenchPartSite site = this.diagramBehavior.getDiagramContainer().getSite();
            if (site == null) {
                return;
            }
            final Shell shell = site.getShell();
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ElementDeleteListener.this.diagramBehavior == null) {
                        return;
                    }
                    if (shell.isDisposed()) {
                        return;
                    }
                    Diagram diagram = null;
                    try {
                        diagram = (Diagram)ElementDeleteListener.this.diagramBehavior.getAdapter(Diagram.class);
                    }
                    catch (Exception exception) {}
                    if (diagram == null || EcoreUtil.getRootContainer(diagram) == null) {
                        if (T.racer().debug()) {
                            String editorName = ElementDeleteListener.this.diagramBehavior.getDiagramContainer().getTitle();
                            T.racer().debug("Closing editor " + editorName);
                        }
                        ElementDeleteListener.this.diagramBehavior.getDiagramContainer().close();
                    }
                }
            });
        }
    }
}

