/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.javafx.driver;

import java.util.ArrayList;
import java.util.List;
import javafx.event.Event;
import javafx.event.EventType;
import javafx.scene.input.MouseEvent;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.javafx.driver.DefaultJavaFXEventMatcher;

public class ClickJavaFXEventMatcher
extends DefaultJavaFXEventMatcher<MouseEvent> {
    private ClickOptions m_clickOptions;

    public ClickJavaFXEventMatcher(ClickOptions clickOptions) {
        super(ClickJavaFXEventMatcher.getClickOptionType(clickOptions));
        this.m_clickOptions = clickOptions;
    }

    private static EventType<MouseEvent> getClickOptionType(ClickOptions cOpt) {
        if (cOpt.getClickType() == ClickOptions.ClickType.CLICKED) {
            return MouseEvent.MOUSE_CLICKED;
        }
        return MouseEvent.MOUSE_RELEASED;
    }

    private int getClickCount(Object eventObject) {
        int count = -1;
        if (eventObject instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)eventObject;
            count = e.getClickCount();
        }
        return count;
    }

    private boolean isClickCountMatching(Object eventObject) {
        return this.getClickCount(eventObject) == this.m_clickOptions.getClickCount();
    }

    @Override
    public boolean isMatching(Object event) {
        return this.isClickCountMatching(event);
    }

    @Override
    public boolean isFallBackEventMatching(List eventObjects, Object graphicsComponent) {
        ArrayList<MouseEvent> catchedEvents = new ArrayList<MouseEvent>();
        for (Object object : eventObjects) {
            Event e = (Event)object;
            if (e == null || !e.getEventType().equals(MouseEvent.MOUSE_CLICKED)) continue;
            catchedEvents.add((MouseEvent)e);
        }
        int i = 0;
        while (i < catchedEvents.size()) {
            int clickEventCount = this.getClickCount(catchedEvents.get(i));
            int j = i + 1;
            while (j < catchedEvents.size()) {
                if (((MouseEvent)catchedEvents.get(i)).getSource().equals(((MouseEvent)catchedEvents.get(j)).getSource())) {
                    clickEventCount += this.getClickCount(catchedEvents.get(j));
                }
                ++j;
            }
            if (clickEventCount == this.m_clickOptions.getClickCount()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        String str = String.valueOf(this.getClass().getName()) + " ClickOptions: " + this.m_clickOptions.toString();
        return str;
    }
}

