/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.jee.jsp.discoverer;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.modisco.infra.discovery.core.exception.DiscoveryException;
import org.eclipse.modisco.jee.jsp.Model;
import org.eclipse.modisco.jee.jsp.discoverer.AbstractJspDiscoverer;
import org.eclipse.modisco.jee.jsp.discoverer.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverJspModelFromResource
extends AbstractJspDiscoverer<IResource> {
    public static final String ID = "org.eclipse.modisco.jee.jsp.discoverer.resource";

    public boolean isApplicableTo(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            return file.exists() && file.getFileExtension() != null && AbstractJspDiscoverer.isJspExtension(file.getFileExtension());
        }
        if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            return container.isAccessible();
        }
        return false;
    }

    public void discoverElement(File file, IProgressMonitor monitor) throws DiscoveryException {
        this.checkParameterValues();
        this.setDefaultTargetURI(URI.createFileURI((String)file.getPath().concat("_jsp.xmi")));
        monitor.beginTask(Messages.discoveringJspModel, -1);
        Model model = DiscoverJspModelFromResource.getEFactory().createModel();
        Resource targetModel = this.createTargetModel();
        targetModel.getContents().add((Object)model);
        DiscoverJspModelFromResource.discoverFile(file, model);
        monitor.setTaskName(Messages.DiscoverJspModelFromResource_savingDiscoveredModel);
        if (this.isTargetSerializationChosen()) {
            try {
                this.saveTargetModel();
            }
            catch (Exception e) {
                throw new DiscoveryException("Error saving discovery result model", (Throwable)e);
            }
        }
    }

    protected void basicDiscoverElement(IResource resource, IProgressMonitor monitor) throws DiscoveryException {
        monitor.beginTask(Messages.discoveringJspModel, -1);
        Model model = DiscoverJspModelFromResource.getEFactory().createModel();
        Resource targetModel = this.createTargetModel();
        targetModel.getContents().add((Object)model);
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            this.setDefaultTargetURI(URI.createPlatformResourceURI((String)file.getFullPath().toString().concat("_jsp.xmi"), (boolean)true));
            DiscoverJspModelFromResource.discoverFile(file.getLocation().toFile(), model);
        } else if (resource instanceof IContainer) {
            IContainer container = (IContainer)resource;
            this.setDefaultTargetURI(URI.createPlatformResourceURI((String)container.getFullPath().append(container.getName()).toString().concat("_jsp.xmi"), (boolean)true));
            DiscoverJspModelFromResource.discoverDirectory(container.getLocation().toFile(), model);
        } else {
            throw new IllegalArgumentException(String.valueOf(resource.getClass().getName()) + " not handled");
        }
    }
}

