/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ecore.as2es;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIException;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Annotation;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Comment;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.Detail;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.LanguageExpression;
import org.eclipse.ocl.pivot.Model;
import org.eclipse.ocl.pivot.Package;
import org.eclipse.ocl.pivot.PivotPackage;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.internal.delegate.DelegateInstaller;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2EcoreDeclarationVisitor;
import org.eclipse.ocl.pivot.internal.ecore.as2es.AS2EcoreReferenceVisitor;
import org.eclipse.ocl.pivot.internal.utilities.AbstractConversion;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotObjectImpl;
import org.eclipse.ocl.pivot.options.OCLinEcoreOptions;
import org.eclipse.ocl.pivot.resource.ProjectManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.XMIUtil;

public class AS2Ecore
extends AbstractConversion {
    public static final Logger logger = Logger.getLogger(AS2Ecore.class);
    public static final @NonNull String OPTION_ADD_INVARIANT_COMMENTS = "addInvariantComments";
    public static final @NonNull String OPTION_BOOLEAN_INVARIANTS = "booleanInvariants";
    public static final @NonNull String OPTION_INVARIANT_PREFIX = "invariantPrefix";
    public static final @NonNull String OPTION_SUPPRESS_DUPLICATES = "suppressDuplicates";
    public static final @NonNull String OPTION_GENERATE_STRUCTURAL_XMI_IDS = "generateStructuralXmiIds";
    private final @NonNull Map<@NonNull Element, @NonNull EModelElement> createMap = new HashMap<Element, EModelElement>();
    private final @NonNull Set<@NonNull Element> deferMap = new HashSet<Element>();
    private @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Resource.Diagnostic> errors = null;
    protected final @NonNull Map<@NonNull String, @Nullable Object> options;
    protected final @NonNull DelegateInstaller delegateInstaller;
    protected final @NonNull AS2EcoreDeclarationVisitor pass1;
    protected final @NonNull AS2EcoreReferenceVisitor pass2;
    protected final @NonNull URI ecoreURI;
    protected final @Nullable String primitiveTypesUriPrefix;

    public static void copyAnnotationComments(@NonNull EAnnotation eModelElement, @NonNull Constraint pivotConstraint) {
        String key = DelegateInstaller.getAnnotationKey(pivotConstraint);
        EAnnotation commentAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        List<Comment> newComments = pivotConstraint.getOwnedComments();
        int iMax = newComments.size();
        if (iMax > 0) {
            if (commentAnnotation == null) {
                commentAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                commentAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
                eModelElement.getEAnnotations().add((Object)commentAnnotation);
            }
            StringBuilder s = new StringBuilder();
            int iComment = 0;
            while (iComment < iMax) {
                if (iComment > 0) {
                    s.append("\n");
                }
                s.append(newComments.get(iComment).getBody());
                ++iComment;
            }
            commentAnnotation.getDetails().put((Object)key, (Object)s.toString());
        } else if (commentAnnotation != null) {
            commentAnnotation.getDetails().removeKey((Object)key);
        }
    }

    @Deprecated
    public static void copyComments(@NonNull EModelElement eModelElement, @NonNull Element pivotElement) {
        AS2Ecore.copyCommentsAndDocumentation(eModelElement, pivotElement);
    }

    public static void copyCommentsAndDocumentation(@NonNull EModelElement eModelElement, @NonNull Element pivotElement) {
        ArrayList<String> newComments = null;
        for (Comment comment : pivotElement.getOwnedComments()) {
            if (newComments == null) {
                newComments = new ArrayList<String>();
            }
            newComments.add(comment.getBody());
        }
        for (Element element : pivotElement.getOwnedAnnotations()) {
            Detail detail;
            Annotation pivotAnnotation;
            if (!(element instanceof Annotation) || !"http://www.eclipse.org/emf/2002/GenModel".equals((pivotAnnotation = (Annotation)element).getName()) || (detail = NameUtil.getNameable(pivotAnnotation.getOwnedDetails(), "documentation")) == null) continue;
            List<String> values = detail.getValues();
            if (newComments == null) {
                newComments = new ArrayList();
            }
            newComments.addAll(values);
        }
        if (newComments != null) {
            EList allEAnnotations = ClassUtil.nullFree(eModelElement.getEAnnotations());
            EAnnotation eAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
                allEAnnotations.add((EAnnotation)eAnnotation);
            }
            String value = StringUtil.splice(newComments, "");
            eAnnotation.getDetails().put((Object)"documentation", (Object)value);
        } else {
            EAnnotation eAnnotation = eModelElement.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
            if (eAnnotation != null) {
                eAnnotation.getDetails().removeKey((Object)"documentation");
            }
        }
    }

    public static @NonNull EOperation createConstraintEOperation(@NonNull Constraint pivotConstraint, @NonNull String operationName, @Nullable Map<@NonNull String, @Nullable Object> options) {
        String body;
        LanguageExpression specification;
        if (options == null) {
            options = new HashMap<String, Object>();
        }
        boolean addInvariantComments = AS2Ecore.isAddInvariantComments(options);
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        eOperation.setName(operationName);
        eOperation.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
        String originalName = PivotUtil.getName(pivotConstraint);
        if (!operationName.equals(originalName)) {
            NameUtil.setOriginalName((ENamedElement)eOperation, originalName);
        }
        EParameter firstParameter = EcoreFactory.eINSTANCE.createEParameter();
        firstParameter.setName("diagnostics");
        firstParameter.setEType((EClassifier)EcorePackage.Literals.EDIAGNOSTIC_CHAIN);
        eOperation.getEParameters().add((Object)firstParameter);
        if (addInvariantComments) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            eAnnotation.getDetails().put((Object)"documentation", (Object)"The chain of diagnostics to which problems are to be appended.");
            firstParameter.getEAnnotations().add((Object)eAnnotation);
        }
        EParameter secondParameter = EcoreFactory.eINSTANCE.createEParameter();
        secondParameter.setName("context");
        EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
        eGenericType.setEClassifier((EClassifier)EcorePackage.Literals.EMAP);
        EGenericType firstTypeArgument = EcoreFactory.eINSTANCE.createEGenericType();
        firstTypeArgument.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
        eGenericType.getETypeArguments().add((Object)firstTypeArgument);
        EGenericType secondTypeArgument = EcoreFactory.eINSTANCE.createEGenericType();
        secondTypeArgument.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
        eGenericType.getETypeArguments().add((Object)secondTypeArgument);
        secondParameter.setEGenericType(eGenericType);
        eOperation.getEParameters().add((Object)secondParameter);
        if (addInvariantComments) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/emf/2002/GenModel");
            eAnnotation.getDetails().put((Object)"documentation", (Object)"The cache of context-specific information.");
            secondParameter.getEAnnotations().add((Object)eAnnotation);
        }
        if ((specification = pivotConstraint.getOwnedSpecification()) != null && (body = specification.getBody()) != null) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(AS2Ecore.getExportDelegateURI(options));
            if (DelegateInstaller.isBooleanInvariants(options)) {
                body = "result = (" + body + ")";
            }
            eAnnotation.getDetails().put((Object)"body", (Object)body);
            eOperation.getEAnnotations().add((Object)eAnnotation);
        }
        AS2Ecore.copyCommentsAndDocumentation((EModelElement)eOperation, pivotConstraint);
        return eOperation;
    }

    public static @NonNull XMLResource createResource(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull Resource asResource, @NonNull URI ecoreURI, @Nullable Map<@NonNull String, @Nullable Object> options) {
        AS2Ecore converter = new AS2Ecore(environmentFactory, ecoreURI, options);
        return converter.convertResource(asResource, ecoreURI);
    }

    public static @NonNull Boolean getBoolean(@Nullable Map<@NonNull String, @Nullable Object> options, @NonNull String key) {
        if (options == null) {
            return false;
        }
        Object value = options.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value != null) {
            logger.error((Object)("Non-Boolean '" + key + "' for '" + value + "'"));
        }
        return false;
    }

    public static @Nullable String getExportDelegateURI(@Nullable Map<@NonNull String, @Nullable Object> options) {
        String exportDelegateURI = options != null ? (String)options.get("http://www.eclipse.org/emf/2002/Ecore/OCL") : null;
        return exportDelegateURI != null ? exportDelegateURI : (String)OCLinEcoreOptions.EXPORT_DELEGATION_URI.getPreferredValue();
    }

    public static @Nullable String getInvariantPrefix(@Nullable Map<@NonNull String, @Nullable Object> options) {
        Object invariantPrefix = options != null ? options.get(OPTION_INVARIANT_PREFIX) : null;
        return invariantPrefix != null ? invariantPrefix.toString() : null;
    }

    public static @Nullable String getString(@Nullable Map<@NonNull String, @Nullable Object> options, @NonNull String key) {
        if (options == null) {
            return null;
        }
        Object value = options.get(key);
        if (value instanceof String) {
            return (String)value;
        }
        if (value != null) {
            logger.error((Object)("Non-String '" + key + "' for '" + value + "'"));
        }
        return null;
    }

    public static boolean isAddInvariantComments(@NonNull Map<@NonNull String, @Nullable Object> options) {
        return Boolean.valueOf(String.valueOf(options.get(OPTION_ADD_INVARIANT_COMMENTS)));
    }

    public static boolean isBooleanInvariants(@NonNull Map<@NonNull String, @Nullable Object> options) {
        return Boolean.valueOf(String.valueOf(options.get(OPTION_BOOLEAN_INVARIANTS)));
    }

    public AS2Ecore(@NonNull EnvironmentFactoryInternal environmentFactory, @NonNull URI ecoreURI, @Nullable Map<@NonNull String, @Nullable Object> options) {
        super(environmentFactory);
        this.options = options != null ? options : new HashMap<String, Object>();
        this.delegateInstaller = new DelegateInstaller(environmentFactory, options);
        this.pass1 = new AS2EcoreDeclarationVisitor(this);
        this.pass2 = new AS2EcoreReferenceVisitor(this);
        this.ecoreURI = ecoreURI;
        this.primitiveTypesUriPrefix = AS2Ecore.getString(options, "PRIMITIVE_TYPES_URI_PREFIX");
    }

    @Deprecated
    protected @Nullable Object convert(@NonNull Element pivotObject) {
        Object eObject = this.pass1.safeVisit(pivotObject);
        for (Element eKey : this.deferMap) {
            this.pass2.safeVisit(eKey);
        }
        return eObject;
    }

    public @NonNull XMLResource convertResource(@NonNull Resource asResource, @NonNull URI ecoreURI) {
        ResourceSet resourceSet = this.environmentFactory.getResourceSet();
        this.setGenerationInProgress(asResource, true);
        try {
            XMLResource ecoreResource = (XMLResource)resourceSet.createResource(ecoreURI);
            EList contents = ecoreResource.getContents();
            for (EObject eContent : asResource.getContents()) {
                Object results;
                if (!(eContent instanceof Model) || !((results = this.pass1.safeVisit((Model)eContent)) instanceof List)) continue;
                List results2 = (List)results;
                contents.addAll(results2);
            }
            for (Element eKey : this.deferMap) {
                this.pass2.safeVisit(eKey);
            }
            for (Element pivotElement : this.createMap.keySet()) {
                EObject eObject = (EObject)this.createMap.get(pivotElement);
                PivotObjectImpl pivotObjectImpl = (PivotObjectImpl)((Object)pivotElement);
                if (pivotObjectImpl.getESObject() != null) continue;
                pivotObjectImpl.setESObject(eObject);
            }
            if (Boolean.valueOf(String.valueOf(this.options.get(OPTION_GENERATE_STRUCTURAL_XMI_IDS))).booleanValue()) {
                XMIUtil.assignIds((Resource)ecoreResource, new XMIUtil.StructuralENamedElementIdCreator(), null);
            }
            XMLResource xMLResource = ecoreResource;
            return xMLResource;
        }
        finally {
            this.setGenerationInProgress(asResource, false);
        }
    }

    public void defer(@NonNull Element pivotElement) {
        this.deferMap.add(pivotElement);
    }

    protected void error(@NonNull String message) {
        List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull Resource.Diagnostic> errors2 = this.errors;
        if (errors2 == null) {
            this.errors = errors2 = new ArrayList<Resource.Diagnostic>();
        }
        errors2.add((Resource.Diagnostic)new XMIException(message));
    }

    public <T extends EObject> @Nullable T getCreated(@NonNull java.lang.Class<T> requiredClass, @NonNull Element pivotElement) {
        Element primaryElement;
        EModelElement eModelElement = this.createMap.get(pivotElement);
        if (eModelElement == null && pivotElement != (primaryElement = this.metamodelManager.getPrimaryElement(pivotElement))) {
            eModelElement = this.createMap.get(primaryElement);
        }
        if (eModelElement == null) {
            return null;
        }
        if (!requiredClass.isAssignableFrom(eModelElement.getClass())) {
            logger.error((Object)("Ecore " + eModelElement.getClass().getName() + "' element is not a '" + requiredClass.getName() + "'"));
            return null;
        }
        EModelElement castElement = eModelElement;
        return (T)castElement;
    }

    public @NonNull DelegateInstaller getDelegateInstaller() {
        return this.delegateInstaller;
    }

    public final @NonNull URI getEcoreURI() {
        return this.ecoreURI;
    }

    public @NonNull Map<@NonNull String, @Nullable Object> getOptions() {
        return this.options;
    }

    public String getPrimitiveTypesUriPrefix() {
        return this.primitiveTypesUriPrefix;
    }

    public @Nullable CollectionType isEcoreCollection(@Nullable Type asType) {
        if (!(asType instanceof CollectionType)) {
            return null;
        }
        if (((CollectionType)asType).getUnspecializedElement() == this.standardLibrary.getCollectionType()) {
            return null;
        }
        return (CollectionType)asType;
    }

    public boolean isPivot(@NonNull Package asPackage) {
        List<Class> asTypes = asPackage.getOwnedClasses();
        if (NameUtil.getNameable(asTypes, PivotPackage.Literals.ENUMERATION_LITERAL.getName()) == null) {
            return false;
        }
        if (NameUtil.getNameable(asTypes, PivotPackage.Literals.EXPRESSION_IN_OCL.getName()) == null) {
            return false;
        }
        if (NameUtil.getNameable(asTypes, PivotPackage.Literals.OPERATION_CALL_EXP.getName()) == null) {
            return false;
        }
        return NameUtil.getNameable(asTypes, PivotPackage.Literals.TEMPLATE_PARAMETER_SUBSTITUTION.getName()) != null;
    }

    public boolean isSuppressDuplicates() {
        return Boolean.valueOf(String.valueOf(this.options.get(OPTION_SUPPRESS_DUPLICATES)));
    }

    public void putCreated(@NonNull Element pivotElement, @NonNull EModelElement eModelElement) {
        Element primaryElement = this.metamodelManager.getPrimaryElement(pivotElement);
        EModelElement oldPivot = this.createMap.put(pivotElement, eModelElement);
        assert (oldPivot == null);
        if (pivotElement != primaryElement && !this.createMap.containsKey(primaryElement)) {
            this.createMap.put(primaryElement, eModelElement);
        }
    }

    protected void setGenerationInProgress(@NonNull Resource asResource, boolean isLoading) {
        for (EObject eRoot : asResource.getContents()) {
            if (!(eRoot instanceof Model)) continue;
            for (Package asPackage : ((Model)eRoot).getOwnedPackages()) {
                if (asPackage == null) continue;
                this.setGenerationInProgress(asPackage, isLoading);
            }
        }
    }

    protected void setGenerationInProgress(@NonNull Package asPackage, boolean isGenerating) {
        URI nsURI;
        ProjectManager projectManager;
        ProjectManager.IPackageDescriptor packageDescriptor;
        String nsUri = asPackage.getURI();
        if (nsUri != null && (packageDescriptor = (projectManager = this.environmentFactory.getProjectManager()).getPackageDescriptor(nsURI = URI.createURI((String)nsUri))) != null) {
            ProjectManager.IResourceDescriptor resourceDescriptor = packageDescriptor.getResourceDescriptor();
            ResourceSet resourceSet = this.environmentFactory.getResourceSet();
            ProjectManager.IResourceLoadStatus resourceLoadStatus = resourceDescriptor.getResourceLoadStatus(resourceSet);
            resourceLoadStatus.setGenerationInProgress(isGenerating);
        }
        for (Package asNestedPackage : asPackage.getOwnedPackages()) {
            if (asNestedPackage == null) continue;
            this.setGenerationInProgress(asNestedPackage, isGenerating);
        }
    }
}

