/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.composer.ui.parts.composer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.php.composer.api.ComposerPackage;
import org.eclipse.php.composer.api.MinimalPackage;
import org.eclipse.php.composer.api.packages.AsyncPackageSearch;
import org.eclipse.php.composer.api.packages.AsyncPackagistSearch;
import org.eclipse.php.composer.api.packages.PackageSearchListenerInterface;
import org.eclipse.php.composer.api.packages.SearchResult;
import org.eclipse.php.composer.core.log.Logger;
import org.eclipse.php.composer.ui.controller.IPackageCheckStateChangedListener;
import org.eclipse.php.composer.ui.controller.PackageController;
import org.eclipse.php.composer.ui.parts.composer.PackageSearchPart;
import org.eclipse.php.composer.ui.parts.composer.PackageSelectionFinishedListener;
import org.eclipse.php.composer.ui.utils.WidgetFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class PackageSearch
implements PackageSearchListenerInterface,
IPackageCheckStateChangedListener {
    protected static final long QUERY_DELAY_MS = 300L;
    protected static final long RESET_QUERY_DELAY_MS = 1500L;
    protected FormToolkit toolkit;
    protected WidgetFactory factory;
    protected Text searchField;
    protected CheckboxTableViewer searchResults;
    protected PackageController searchController;
    protected Composite body;
    protected Composite pickedResults;
    protected Map<String, PackageSearchPart> packageControls = new HashMap<String, PackageSearchPart>();
    protected Button addButton;
    protected AsyncPackageSearch downloader = new AsyncPackagistSearch();
    protected String currentQuery;
    protected String lastQuery;
    protected String shownQuery;
    protected String foundQuery;
    protected Thread resetThread;
    protected Thread queryThread;
    protected boolean clearing = false;
    protected SelectionAdapter addButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            PackageSearch.this.notifyPackageSelectionFinishedListener();
        }
    };
    protected boolean enabled = true;
    protected ComposerPackage composerPackage;
    protected Set<PackageSelectionFinishedListener> packageListeners = new HashSet<PackageSelectionFinishedListener>();

    public PackageSearch(Composite parent, ComposerPackage composerPackage, FormToolkit toolkit, String buttonText) {
        this.composerPackage = composerPackage;
        this.create(parent, toolkit, buttonText);
    }

    public PackageSearch(Composite parent, ComposerPackage composerPackage, FormToolkit toolkit) {
        this(parent, composerPackage, toolkit, null);
    }

    public PackageSearch(Composite parent, ComposerPackage composerPackage, String buttonText) {
        this(parent, composerPackage, null, buttonText);
    }

    public PackageSearch(Composite parent, ComposerPackage composerPackage) {
        this(parent, composerPackage, null, null);
    }

    public void addPackageCheckStateChangedListener(IPackageCheckStateChangedListener listener) {
        if (this.searchController != null) {
            this.searchController.addPackageCheckStateChangedListener(listener);
        }
    }

    public void removePackageCheckStateChangedListener(IPackageCheckStateChangedListener listener) {
        if (this.searchController != null) {
            this.searchController.removePackageCheckStateChangedListener(listener);
        }
    }

    public void addPackageSelectionFinishedListener(PackageSelectionFinishedListener listener) {
        this.packageListeners.add(listener);
    }

    public void removePackageSelectionFinishedListener(PackageSelectionFinishedListener listener) {
        this.packageListeners.remove(listener);
    }

    protected void create(Composite parent, FormToolkit toolkit, String buttonText) {
        this.toolkit = toolkit;
        this.factory = new WidgetFactory(toolkit);
        this.body = this.factory.createComposite(parent);
        this.body.setLayout((Layout)new GridLayout());
        this.searchField = this.factory.createText(this.body, 2948);
        this.searchField.setEnabled(this.enabled);
        this.searchField.setEditable(this.enabled);
        this.searchField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.searchField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PackageSearch.this.searchTextChanged();
            }
        });
        int style = 768;
        style = toolkit == null ? (style |= 0x800) : (style |= toolkit.getBorderStyle());
        this.searchController = this.getSearchResultsController();
        this.searchController.addPackageCheckStateChangedListener(this);
        this.searchResults = CheckboxTableViewer.newCheckList((Composite)this.body, (int)style);
        this.searchResults.getTable().setEnabled(this.enabled);
        this.searchResults.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.searchResults.setCheckStateProvider((ICheckStateProvider)this.searchController);
        this.searchResults.addCheckStateListener((ICheckStateListener)this.searchController);
        this.searchResults.setContentProvider((IContentProvider)this.searchController);
        this.searchResults.setLabelProvider((IBaseLabelProvider)this.searchController);
        this.searchResults.setInput(new ArrayList());
        this.pickedResults = this.factory.createComposite(this.body);
        this.pickedResults.setLayoutData((Object)new GridData(4, 4, true, false));
        GridLayout layout = new GridLayout();
        layout.marginTop = 0;
        layout.marginRight = -5;
        layout.marginBottom = 0;
        layout.marginLeft = -5;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 0;
        this.pickedResults.setLayout((Layout)layout);
        if (buttonText != null) {
            this.addButton = this.factory.createButton(this.body);
            this.addButton.setText(buttonText);
            this.addButton.setEnabled(false);
            this.addButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.addButton.addSelectionListener((SelectionListener)this.addButtonListener);
        }
        this.downloader.addPackageSearchListener((PackageSearchListenerInterface)this);
    }

    protected void notifyPackageSelectionFinishedListener() {
        List<String> packages = this.getPackages();
        for (PackageSelectionFinishedListener listener : this.packageListeners) {
            listener.packagesSelected(packages);
        }
        this.clear();
    }

    protected void clearSearchText() {
        if (this.clearing) {
            return;
        }
        this.clearing = true;
        this.searchResults.setInput(null);
        this.searchField.setText("");
        this.downloader.abort();
        this.shownQuery = null;
        this.queryThread.interrupt();
        this.resetThread.interrupt();
        this.clearing = false;
    }

    public void aborted(String url) {
    }

    public void packagesFound(final List<MinimalPackage> packages, String query, SearchResult result) {
        this.foundQuery = query;
        Logger.debug((String)("Found Packages for: " + query + " => " + packages.size()));
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (PackageSearch.this.currentQuery.isEmpty()) {
                    return;
                }
                if (PackageSearch.this.shownQuery == null || !PackageSearch.this.shownQuery.equals(PackageSearch.this.foundQuery) && PackageSearch.this.currentQuery.equals(PackageSearch.this.foundQuery)) {
                    PackageSearch.this.searchResults.setInput((Object)packages);
                    PackageSearch.this.shownQuery = PackageSearch.this.foundQuery;
                } else if (PackageSearch.this.shownQuery.equals(PackageSearch.this.foundQuery)) {
                    PackageSearch.this.searchController.addPackages(packages);
                    PackageSearch.this.searchResults.refresh();
                }
            }
        });
    }

    public void errorOccured(Exception e) {
        e.printStackTrace();
    }

    protected void searchTextChanged() {
        this.currentQuery = this.searchField.getText();
        if (this.currentQuery.trim().isEmpty()) {
            this.clearSearchText();
            return;
        }
        this.downloader.abort();
        if (this.queryThread == null || !this.queryThread.isAlive() || this.queryThread.isInterrupted()) {
            this.startQuery();
            this.queryThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Thread.sleep(300L);
                        PackageSearch packageSearch = PackageSearch.this;
                        synchronized (packageSearch) {
                            PackageSearch.this.startQuery();
                            PackageSearch.this.queryThread.interrupt();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
            });
            this.queryThread.start();
        }
    }

    protected synchronized void startQuery() {
        if (this.lastQuery == this.currentQuery) {
            return;
        }
        this.downloader.search(this.currentQuery);
        if (this.resetThread != null) {
            this.resetThread.interrupt();
        }
        this.resetThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(1500L);
                    PackageSearch packageSearch = PackageSearch.this;
                    synchronized (packageSearch) {
                        if (PackageSearch.this.currentQuery.equals(PackageSearch.this.shownQuery)) {
                            PackageSearch.this.shownQuery = null;
                        }
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        this.resetThread.start();
        this.lastQuery = this.currentQuery;
    }

    protected PackageController getSearchResultsController() {
        return new PackageController();
    }

    public Composite getBody() {
        return this.body;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.searchField.setEnabled(enabled);
        this.searchField.setEditable(enabled);
        this.searchResults.getTable().setEnabled(enabled);
        if (this.addButton != null) {
            this.addButton.setEnabled(this.addButton.getEnabled() && enabled);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void packageCheckStateChanged(String name, boolean checked) {
        if (checked) {
            this.packageControls.put(name, this.connectPackagePart(this.createPackagePart(this.pickedResults, name)));
        } else {
            this.packageControls.remove(name).dispose();
        }
        if (this.addButton != null) {
            this.addButton.setEnabled(this.searchController.getCheckedPackagesCount() > 0 && this.enabled);
        }
        this.getBody().layout(true, true);
    }

    private PackageSearchPart connectPackagePart(final PackageSearchPart psp) {
        psp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PackageSearch.this.searchController.setChecked(psp.getName(), psp.isChecked());
                PackageSearch.this.searchResults.refresh();
            }
        });
        return psp;
    }

    protected PackageSearchPart createPackagePart(Composite parent, String name) {
        return new PackageSearchPart(parent, this.composerPackage, this.toolkit, name);
    }

    public List<String> getPackages() {
        return this.searchController.getCheckedPackages();
    }

    public void clear() {
        this.clearSearchText();
        this.searchController.clear();
        this.packageControls.clear();
        Control[] controlArray = this.pickedResults.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            child.dispose();
            ++n2;
        }
        if (this.addButton != null) {
            this.addButton.setEnabled(false);
        }
        this.searchResults.refresh();
        this.getBody().layout(true, true);
    }
}

