/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.jdt;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.recommenders.internal.jdt.l10n.LogMessages;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.VmTypeName;

public final class JavaElementsFinder {
    private JavaElementsFinder() {
    }

    public static ImmutableList<IJavaProject> findAccessibleJavaProjects() {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            JavaModelManager mgr = JavaModelManager.getJavaModelManager();
            b.add((Object[])mgr.getJavaModel().getJavaProjects());
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_JAVA_PROJECTS, (Throwable)e);
        }
        return b.build();
    }

    public static ImmutableList<IPackageFragmentRoot> findSourceRoots(IJavaProject project) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                if (1 == JavaElementsFinder.getPackageFragmentRootKind(root)) {
                    b.add((Object)root);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_PACKAGE_FRAGMENT_ROOTS, (Throwable)e, (Object[])new Object[]{project});
        }
        return b.build();
    }

    public static ImmutableList<IPackageFragmentRoot> findPackageRootsWithSources(IJavaProject project) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                int kind = JavaElementsFinder.getPackageFragmentRootKind(root);
                if (1 == kind) {
                    b.add((Object)root);
                } else if (2 == kind && JavaElementsFinder.hasSourceAttachment(root)) {
                    b.add((Object)root);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_PACKAGE_FRAGMENT_ROOTS, (Throwable)e, (Object[])new Object[]{project});
        }
        return b.build();
    }

    public static ImmutableList<IPackageFragmentRoot> findPackageFragmentRoots(IJavaProject project) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            IPackageFragmentRoot[] iPackageFragmentRootArray = project.getPackageFragmentRoots();
            int n = iPackageFragmentRootArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                b.add((Object)root);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_PACKAGE_FRAGMENT_ROOTS, (Throwable)e, (Object[])new Object[]{project});
        }
        return b.build();
    }

    public static ImmutableList<IPackageFragment> findPackages(IPackageFragmentRoot root) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            IJavaElement[] iJavaElementArray = root.getChildren();
            int n = iJavaElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaElement e = iJavaElementArray[n2];
                b.add((Object)((IPackageFragment)e));
                ++n2;
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_PACKAGE_FRAGMENT, (Throwable)e, (Object[])new Object[]{root});
        }
        return b.build();
    }

    public static ImmutableList<ICompilationUnit> findCompilationUnits(IPackageFragment fragment) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            b.add((Object[])fragment.getCompilationUnits());
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_COMPILATION_UNITS, (Throwable)e, (Object[])new Object[]{fragment});
        }
        return b.build();
    }

    public static ImmutableList<IClassFile> findClassFiles(IPackageFragment fragment) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            b.add((Object[])fragment.getClassFiles());
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_CLASS_FILES, (Throwable)e, (Object[])new Object[]{fragment});
        }
        return b.build();
    }

    public static Optional<IType> findType(String typename, IJavaProject project) {
        try {
            return Optional.fromNullable((Object)project.findType(typename));
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FIND_TYPE_IN_PROJECT, (Throwable)e, (Object[])new Object[]{typename, project});
            return Optional.absent();
        }
    }

    public static ImmutableList<IType> findTypes(IJavaProject project) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (ITypeRoot root : JavaElementsFinder.findTypeRoots(project)) {
            b.addAll(JavaElementsFinder.findTypes(root));
        }
        return b.build();
    }

    public static ImmutableList<IType> findTypes(IPackageFragmentRoot root) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (ITypeRoot typeRoot : JavaElementsFinder.findTypeRoots(root)) {
            b.addAll(JavaElementsFinder.findTypes(typeRoot));
        }
        return b.build();
    }

    public static ImmutableList<IType> findTypes(ITypeRoot root) {
        ImmutableList.Builder b = ImmutableList.builder();
        try {
            if (root instanceof ICompilationUnit) {
                IType[] iTypeArray = ((ICompilationUnit)root).getTypes();
                int n = iTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IType type = iTypeArray[n2];
                    b.add((Object)type);
                    ++n2;
                }
            } else if (root instanceof IClassFile) {
                b.add((Object)((IClassFile)root).getType());
            }
        }
        catch (JavaModelException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_TYPES, (Throwable)e, (Object[])new Object[]{root});
        }
        return b.build();
    }

    public static ImmutableList<ITypeRoot> findTypeRoots(IJavaProject project) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (IPackageFragmentRoot root : JavaElementsFinder.findPackageFragmentRoots(project)) {
            b.addAll(JavaElementsFinder.findTypeRoots(root));
        }
        return b.build();
    }

    public static ImmutableList<ITypeRoot> findTypeRoots(IPackageFragmentRoot root) {
        ImmutableList.Builder b = ImmutableList.builder();
        for (IPackageFragment pkg : JavaElementsFinder.findPackages(root)) {
            b.addAll(JavaElementsFinder.findTypeRoots(pkg));
        }
        return b.build();
    }

    public static ImmutableList<ITypeRoot> findTypeRoots(IPackageFragment fragment) {
        ImmutableList.Builder b = ImmutableList.builder();
        ImmutableList<ICompilationUnit> cus = JavaElementsFinder.findCompilationUnits(fragment);
        ImmutableList<IClassFile> classFiles = JavaElementsFinder.findClassFiles(fragment);
        b.addAll(cus);
        b.addAll(classFiles);
        return b.build();
    }

    public static Optional<File> findLocation(ICompilationUnit cu) {
        if (cu == null) {
            return Optional.absent();
        }
        IResource resource = cu.getResource();
        if (resource == null) {
            return Optional.absent();
        }
        IPath location = resource.getLocation();
        if (location == null) {
            return Optional.absent();
        }
        File file = location.toFile();
        if (!file.exists()) {
            return Optional.absent();
        }
        return Optional.of((Object)file);
    }

    public static Optional<File> findLocation(IPackageFragmentRoot root) {
        if (root == null) {
            return Optional.absent();
        }
        File res = null;
        IResource resource = root.getResource();
        if (resource != null) {
            res = resource.getLocation() == null ? resource.getRawLocation().toFile().getAbsoluteFile() : resource.getLocation().toFile().getAbsoluteFile();
        }
        if (root.isExternal()) {
            res = root.getPath().toFile().getAbsoluteFile();
        }
        if (res != null && !res.exists()) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)res);
    }

    public static boolean hasSourceAttachment(IPackageFragmentRoot fragmentRoot) {
        try {
            return fragmentRoot.getSourceAttachmentPath() != null;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_SOURCE_ATTACHMENT_PATH, (Throwable)e, (Object[])new Object[]{fragmentRoot});
            return false;
        }
    }

    public static Optional<ITypeName> resolveType(char[] typeSignature, IJavaElement enclosing) {
        typeSignature = CharOperation.replaceOnCopy((char[])typeSignature, (char)'.', (char)'/');
        VmTypeName res = null;
        try {
            int dimensions = Signature.getArrayCount((char[])typeSignature);
            block1 : switch (typeSignature[dimensions]) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    res = VmTypeName.get((String)new String(typeSignature, 0, typeSignature.length));
                    break;
                }
                case 'L': {
                    res = VmTypeName.get((String)new String(typeSignature, 0, typeSignature.length - 1));
                    break;
                }
                case 'Q': {
                    if (enclosing != null) {
                        String[][] resolvedNames;
                        String unresolved = new String(typeSignature, dimensions + 1, typeSignature.length - (dimensions + 2));
                        IType ancestor = (IType)enclosing.getAncestor(7);
                        if (ancestor != null && !ArrayUtils.isEmpty((Object[])(resolvedNames = ancestor.resolveType(unresolved)))) {
                            String array = StringUtils.repeat((char)'[', (int)dimensions);
                            String pkg = resolvedNames[0][0].replace('.', '/');
                            String name = resolvedNames[0][1].replace('.', '$');
                            res = VmTypeName.get((String)(String.valueOf(array) + 'L' + pkg + '/' + name));
                        }
                    }
                    break;
                }
                case 'T': {
                    String varName = new String(typeSignature, dimensions + 1, typeSignature.length - (dimensions + 2));
                    String array = StringUtils.repeat((char)'[', (int)dimensions);
                    IJavaElement cur = enclosing;
                    while (cur instanceof IType || cur instanceof IMethod) {
                        switch (cur.getElementType()) {
                            case 7: {
                                IType type = (IType)cur;
                                ITypeParameter param = type.getTypeParameter(varName);
                                if (param.exists()) {
                                    Object[] signatures = JavaElementsFinder.getBoundSignatures(param);
                                    if (ArrayUtils.isEmpty((Object[])signatures)) {
                                        res = VmTypeName.OBJECT;
                                        break block1;
                                    }
                                    char[] append = array.concat((String)signatures[0]).toCharArray();
                                    return JavaElementsFinder.resolveType(append, (IJavaElement)type);
                                }
                            }
                            case 9: {
                                IMethod method = (IMethod)cur;
                                ITypeParameter param = method.getTypeParameter(varName);
                                if (!param.exists()) break;
                                Object[] signatures = JavaElementsFinder.getBoundSignatures(param);
                                if (ArrayUtils.isEmpty((Object[])signatures)) {
                                    res = dimensions == 0 ? VmTypeName.OBJECT : VmTypeName.get((String)(String.valueOf(StringUtils.repeat((char)'[', (int)dimensions)) + VmTypeName.OBJECT.getIdentifier()));
                                    break block1;
                                }
                                char[] append = array.concat((String)signatures[0]).toCharArray();
                                return JavaElementsFinder.resolveType(append, (IJavaElement)method);
                            }
                        }
                        cur = cur.getParent();
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_CREATE_TYPENAME, (Throwable)e, (Object[])new Object[]{String.valueOf(CharOperation.charToString((char[])typeSignature)) + (enclosing != null ? " in " + enclosing.getElementName() : "")});
        }
        return Optional.fromNullable(res);
    }

    private static String[] getBoundSignatures(ITypeParameter param) throws JavaModelException {
        String[] res = CharOperation.NO_STRINGS;
        try {
            res = param.getBoundsSignatures();
        }
        catch (NullPointerException nullPointerException) {}
        return res;
    }

    public static IPackageFragmentRoot[] getAllPackageFragmentRoots(IJavaProject javaProject) {
        try {
            return javaProject.getAllPackageFragmentRoots();
        }
        catch (JavaModelException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_ALL_PACKAGE_FRAGMENT_ROOTS, (Throwable)e, (Object[])new Object[]{javaProject});
            return new IPackageFragmentRoot[0];
        }
    }

    public static int getPackageFragmentRootKind(IPackageFragmentRoot packageFragmentRoot) {
        try {
            return packageFragmentRoot.getKind();
        }
        catch (JavaModelException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_CANNOT_FETCH_PACKAGE_FRAGMENT_ROOT_KIND, (Throwable)e, (Object[])new Object[]{packageFragmentRoot});
            return 0;
        }
    }
}

