/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.nls.internal.ui.action;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.s2e.nls.NlsCore;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.action.AbstractWorkspaceAction;
import org.eclipse.scout.sdk.s2e.nls.internal.ui.dialog.NlsEntryModifyDialog;
import org.eclipse.scout.sdk.s2e.nls.model.INlsEntry;
import org.eclipse.scout.sdk.s2e.nls.model.NlsEntry;
import org.eclipse.scout.sdk.s2e.nls.project.INlsProject;
import org.eclipse.swt.widgets.Shell;

public class NlsEntryModifyAction
extends AbstractWorkspaceAction {
    private NlsEntry m_entry;
    private final INlsProject m_project;
    private final Shell m_parentShell;

    public NlsEntryModifyAction(Shell parentShell, INlsEntry entry, INlsProject project) {
        super("Modify Entry...", true);
        this.m_entry = new NlsEntry(entry);
        this.m_project = project;
        this.m_parentShell = parentShell;
        this.setImageDescriptor(NlsCore.getImageDescriptor("text"));
    }

    @Override
    protected void execute(IProgressMonitor monitor) {
        if (this.getEntry() != null) {
            this.m_project.updateRow(this.getEntry(), monitor);
        }
    }

    @Override
    protected boolean interactWithUi() {
        NlsEntryModifyDialog dialog = new NlsEntryModifyDialog(this.m_parentShell, this.m_entry, this.m_project);
        this.m_entry = dialog.show();
        return this.m_entry != null;
    }

    public NlsEntry getEntry() {
        return this.m_entry;
    }
}

