/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.corext.template.java.CodeTemplateContext;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.ProjectTemplateStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.scout.sdk.core.importvalidator.IImportValidator;
import org.eclipse.scout.sdk.core.signature.Signature;
import org.eclipse.scout.sdk.core.signature.SignatureUtils;
import org.eclipse.scout.sdk.core.sourcebuilder.ISourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.comment.ICommentSourceBuilderSpi;
import org.eclipse.scout.sdk.core.sourcebuilder.compilationunit.ICompilationUnitSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.field.IFieldSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.methodparameter.IMethodParameterSourceBuilder;
import org.eclipse.scout.sdk.core.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.core.util.CoreUtils;
import org.eclipse.scout.sdk.core.util.PropertyMap;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.core.util.SdkLog;
import org.eclipse.scout.sdk.s2e.util.S2eUtils;

public class JdtSettingsCommentSourceBuilderDelegate
implements ICommentSourceBuilderSpi {
    private static final String[] EMPTY = new String[0];
    private static final String UNDEFINED_VAR_VALUE = "undefined";
    private static final int METHOD_TYPE_NORMAL = 2;
    private static final int METHOD_TYPE_GETTER = 4;
    private static final int METHOD_TYPE_SETTER = 8;
    private static final UsernameResolver USERNAME_RESOLVER = new UsernameResolver();

    public ISourceBuilder createCompilationUnitComment(final ICompilationUnitSourceBuilder target) {
        return new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap builderCtx, IImportValidator validator) {
                if (!JdtSettingsCommentSourceBuilderDelegate.isAutomaticallyAddComments(builderCtx)) {
                    return;
                }
                IJavaProject ownerProject = (IJavaProject)builderCtx.getProperty("JavaProject", IJavaProject.class);
                Template template = JdtSettingsCommentSourceBuilderDelegate.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.filecomment", ownerProject);
                if (template != null) {
                    CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
                    context.setVariable("file_name", target.getElementName());
                    String packageName = target.getPackageName();
                    if (packageName == null) {
                        packageName = "";
                    }
                    context.setVariable("package_name", packageName);
                    if (S2eUtils.exists((IJavaElement)ownerProject)) {
                        context.setVariable("project_name", ownerProject.getElementName());
                    }
                    context.setVariable("type_name", JavaCore.removeJavaLikeExtension((String)target.getElementName()));
                    String comment = JdtSettingsCommentSourceBuilderDelegate.evaluateTemplate(context, template);
                    if (comment != null) {
                        source.append(comment);
                    }
                }
            }
        };
    }

    public ISourceBuilder createTypeComment(final ITypeSourceBuilder target) {
        return new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap builderCtx, IImportValidator validator) {
                TemplateBuffer buffer;
                if (!JdtSettingsCommentSourceBuilderDelegate.isAutomaticallyAddComments(builderCtx)) {
                    return;
                }
                IJavaProject ownerProject = (IJavaProject)builderCtx.getProperty("JavaProject", IJavaProject.class);
                Template template = JdtSettingsCommentSourceBuilderDelegate.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.typecomment", ownerProject);
                if (template == null) {
                    return;
                }
                CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
                context.setVariable("file_name", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                context.setVariable("package_name", Signature.getQualifier((String)target.getFullyQualifiedName()));
                if (S2eUtils.exists((IJavaElement)ownerProject)) {
                    context.setVariable("project_name", ownerProject.getElementName());
                }
                context.setVariable("enclosing_type", Signature.getQualifier((String)target.getElementName()));
                context.setVariable("type_name", Signature.getSimpleName((String)target.getElementName()));
                try {
                    buffer = context.evaluate(template);
                }
                catch (BadLocationException e) {
                    throw new SdkException((Throwable)e);
                }
                catch (TemplateException e) {
                    throw new SdkException((Throwable)e);
                }
                String str = buffer.getString();
                if (Strings.containsOnlyWhitespaces((String)str)) {
                    return;
                }
                TemplateVariable position = JdtSettingsCommentSourceBuilderDelegate.findVariable(buffer, "tags");
                if (position == null) {
                    if (str != null) {
                        source.append(str);
                    }
                    return;
                }
                Document document = new Document(str);
                int[] tagOffsets = position.getOffsets();
                int i = tagOffsets.length - 1;
                while (i >= 0) {
                    try {
                        JdtSettingsCommentSourceBuilderDelegate.insertTag((IDocument)document, tagOffsets[i], position.getLength(), EMPTY, EMPTY, null, EMPTY, false, lineDelimiter);
                    }
                    catch (BadLocationException e) {
                        throw new SdkException((Throwable)e);
                    }
                    --i;
                }
                String comment = document.get();
                if (comment != null) {
                    source.append(comment);
                }
            }
        };
    }

    public ISourceBuilder createOverrideMethodComment(final IMethodSourceBuilder target, final String interfaceFqn) {
        return new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap builderCtx, IImportValidator validator) {
                if (!JdtSettingsCommentSourceBuilderDelegate.isAutomaticallyAddComments(builderCtx)) {
                    return;
                }
                IJavaProject ownerProject = (IJavaProject)builderCtx.getProperty("JavaProject", IJavaProject.class);
                Template template = JdtSettingsCommentSourceBuilderDelegate.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.overridecomment", ownerProject);
                if (template != null) {
                    CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
                    context.setVariable("package_name", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                    if (S2eUtils.exists((IJavaElement)ownerProject)) {
                        context.setVariable("project_name", ownerProject.getElementName());
                    }
                    context.setVariable("file_name", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                    context.setVariable("enclosing_method", target.getElementName());
                    context.setVariable("enclosing_type", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                    StringBuilder seeBuilder = new StringBuilder("@see ");
                    seeBuilder.append(interfaceFqn).append('#').append(target.getElementName()).append('(');
                    Iterator parameterIterator = target.getParameters().iterator();
                    if (parameterIterator.hasNext()) {
                        seeBuilder.append(SignatureUtils.toFullyQualifiedName((String)((IMethodParameterSourceBuilder)parameterIterator.next()).getDataTypeSignature()));
                        while (parameterIterator.hasNext()) {
                            seeBuilder.append(", ").append(SignatureUtils.toFullyQualifiedName((String)((IMethodParameterSourceBuilder)parameterIterator.next()).getDataTypeSignature()));
                        }
                    }
                    seeBuilder.append(')');
                    context.setVariable("see_to_overridden", seeBuilder.toString());
                    String comment = JdtSettingsCommentSourceBuilderDelegate.evaluateTemplate(context, template);
                    if (comment != null) {
                        source.append(comment);
                    }
                }
            }
        };
    }

    public ISourceBuilder createMethodComment(IMethodSourceBuilder target) {
        return JdtSettingsCommentSourceBuilderDelegate.createMethodCommentInternal(target, 2);
    }

    public ISourceBuilder createGetterMethodComment(IMethodSourceBuilder target) {
        return JdtSettingsCommentSourceBuilderDelegate.createMethodCommentInternal(target, 4);
    }

    public ISourceBuilder createSetterMethodComment(IMethodSourceBuilder target) {
        return JdtSettingsCommentSourceBuilderDelegate.createMethodCommentInternal(target, 8);
    }

    private static ISourceBuilder createMethodCommentInternal(final IMethodSourceBuilder target, final int type) {
        return new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap builderCtx, IImportValidator validator) {
                TemplateBuffer buffer;
                if (!JdtSettingsCommentSourceBuilderDelegate.isAutomaticallyAddComments(builderCtx)) {
                    return;
                }
                IJavaProject ownerProject = (IJavaProject)builderCtx.getProperty("JavaProject", IJavaProject.class);
                List parameters = target.getParameters();
                String[] paramSignatures = new String[parameters.size()];
                String[] paramNames = new String[parameters.size()];
                int j = 0;
                for (IMethodParameterSourceBuilder param : parameters) {
                    paramSignatures[j] = param.getDataTypeSignature();
                    paramNames[j] = param.getElementName();
                    ++j;
                }
                List exceptionSignatures = target.getExceptionSignatures();
                String returnTypeSignature = target.getReturnTypeSignature();
                String fieldTypeSimpleName = JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE;
                String templateName = null;
                switch (type) {
                    case 4: {
                        templateName = "org.eclipse.jdt.ui.text.codetemplates.gettercomment";
                        fieldTypeSimpleName = Signature.getSignatureSimpleName((String)target.getReturnTypeSignature());
                        break;
                    }
                    case 8: {
                        templateName = "org.eclipse.jdt.ui.text.codetemplates.settercomment";
                        if (target.getParameters().size() <= 0) break;
                        fieldTypeSimpleName = Signature.getSignatureSimpleName((String)((IMethodParameterSourceBuilder)target.getParameters().get(0)).getDataTypeSignature());
                        break;
                    }
                    default: {
                        templateName = returnTypeSignature == null ? "org.eclipse.jdt.ui.text.codetemplates.constructorcomment" : "org.eclipse.jdt.ui.text.codetemplates.methodcomment";
                    }
                }
                Template template = JdtSettingsCommentSourceBuilderDelegate.getCodeTemplate(templateName, ownerProject);
                if (template == null) {
                    return;
                }
                CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
                String getterSetterName = JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE;
                Matcher matcher = CoreUtils.BEAN_METHOD_NAME.matcher(target.getElementName());
                if (matcher.find()) {
                    getterSetterName = matcher.group(2);
                }
                if (S2eUtils.exists((IJavaElement)ownerProject)) {
                    context.setVariable("project_name", ownerProject.getElementName());
                }
                context.setVariable("file_name", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                context.setVariable("package_name", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                context.setVariable("enclosing_method", target.getElementName());
                context.setVariable("enclosing_type", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                context.setVariable("field", getterSetterName);
                context.setVariable("field_type", fieldTypeSimpleName);
                context.setVariable("bare_field_name", getterSetterName);
                if (parameters.size() > 0) {
                    context.setVariable("param", ((IMethodParameterSourceBuilder)parameters.get(0)).getElementName());
                } else {
                    context.setVariable("param", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                }
                if (returnTypeSignature != null) {
                    context.setVariable("return_type", Signature.toString((String)returnTypeSignature));
                }
                try {
                    buffer = context.evaluate(template);
                }
                catch (BadLocationException e) {
                    throw new SdkException((Throwable)e);
                }
                catch (TemplateException e) {
                    throw new SdkException((Throwable)e);
                }
                if (buffer == null) {
                    return;
                }
                String str = buffer.getString();
                if (Strings.containsOnlyWhitespaces((String)str)) {
                    return;
                }
                TemplateVariable position = JdtSettingsCommentSourceBuilderDelegate.findVariable(buffer, "tags");
                if (position == null) {
                    if (str != null) {
                        source.append(str);
                    }
                    return;
                }
                Document document = new Document(str);
                String[] exceptionNames = new String[exceptionSignatures.size()];
                int i = 0;
                while (i < exceptionNames.length) {
                    exceptionNames[i] = Signature.toString((String)((String)exceptionSignatures.get(i)));
                    ++i;
                }
                String returnType = returnTypeSignature != null ? Signature.toString((String)returnTypeSignature) : null;
                int[] tagOffsets = position.getOffsets();
                int i2 = tagOffsets.length - 1;
                while (i2 >= 0) {
                    try {
                        JdtSettingsCommentSourceBuilderDelegate.insertTag((IDocument)document, tagOffsets[i2], position.getLength(), paramNames, exceptionNames, returnType, EMPTY, false, lineDelimiter);
                    }
                    catch (BadLocationException e) {
                        throw new SdkException((Throwable)e);
                    }
                    --i2;
                }
                String comment = document.get();
                if (comment != null) {
                    source.append(comment);
                }
            }
        };
    }

    public ISourceBuilder createFieldComment(final IFieldSourceBuilder target) {
        return new ISourceBuilder(){

            public void createSource(StringBuilder source, String lineDelimiter, PropertyMap builderCtx, IImportValidator validator) {
                if (!JdtSettingsCommentSourceBuilderDelegate.isAutomaticallyAddComments(builderCtx)) {
                    return;
                }
                IJavaProject ownerProject = (IJavaProject)builderCtx.getProperty("JavaProject", IJavaProject.class);
                Template template = JdtSettingsCommentSourceBuilderDelegate.getCodeTemplate("org.eclipse.jdt.ui.text.codetemplates.fieldcomment", ownerProject);
                if (template != null) {
                    CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), ownerProject, lineDelimiter);
                    context.setVariable("field_type", Signature.getSignatureSimpleName((String)target.getSignature()));
                    context.setVariable("field", target.getElementName());
                    if (S2eUtils.exists((IJavaElement)ownerProject)) {
                        context.setVariable("project_name", ownerProject.getElementName());
                    }
                    context.setVariable("package_name", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                    context.setVariable("file_name", JdtSettingsCommentSourceBuilderDelegate.UNDEFINED_VAR_VALUE);
                    String comment = JdtSettingsCommentSourceBuilderDelegate.evaluateTemplate(context, template);
                    if (comment != null) {
                        source.append(comment);
                    }
                }
            }
        };
    }

    private static boolean isAutomaticallyAddComments(PropertyMap map) {
        IScopeContext[] contexts;
        if (map == null) {
            return false;
        }
        IJavaProject jp = (IJavaProject)map.getProperty("JavaProject", IJavaProject.class);
        if (jp == null) {
            return false;
        }
        IScopeContext[] iScopeContextArray = contexts = new IScopeContext[]{new ProjectScope(jp.getProject()), InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IScopeContext context = iScopeContextArray[n2];
            IEclipsePreferences node = context.getNode("org.eclipse.jdt.ui");
            if (node != null) {
                String val = node.get("org.eclipse.jdt.ui.javadoc", null);
                return "true".equals(val);
            }
            ++n2;
        }
        return true;
    }

    private static String evaluateTemplate(CodeTemplateContext context, Template template) {
        TemplateBuffer buffer;
        Iterator resolvers = context.getContextType().resolvers();
        while (resolvers.hasNext()) {
            TemplateVariableResolver resolver = (TemplateVariableResolver)resolvers.next();
            if (!(resolver instanceof GlobalTemplateVariables.User)) continue;
            context.getContextType().removeResolver(resolver);
            context.getContextType().addResolver((TemplateVariableResolver)USERNAME_RESOLVER);
            break;
        }
        try {
            buffer = context.evaluate(template);
        }
        catch (BadLocationException e) {
            throw new SdkException((Throwable)e);
        }
        catch (TemplateException e) {
            throw new SdkException((Throwable)e);
        }
        if (buffer == null) {
            return null;
        }
        String str = buffer.getString();
        if (Strings.containsOnlyWhitespaces((String)str)) {
            return null;
        }
        return str;
    }

    private static Template getCodeTemplate(String id, IJavaProject project) {
        if (!S2eUtils.exists((IJavaElement)project)) {
            return JavaPlugin.getDefault().getCodeTemplateStore().findTemplateById(id);
        }
        ProjectTemplateStore projectStore = new ProjectTemplateStore(project.getProject());
        try {
            projectStore.load();
        }
        catch (IOException e) {
            SdkLog.error((Object[])new Object[]{e});
        }
        return projectStore.findTemplateById(id);
    }

    private static TemplateVariable findVariable(TemplateBuffer buffer, String variable) {
        TemplateVariable[] positions = buffer.getVariables();
        int i = 0;
        while (i < positions.length) {
            TemplateVariable curr = positions[i];
            if (variable.equals(curr.getType())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    private static void insertTag(IDocument textBuffer, int offset, int length, String[] paramNames, String[] exceptionNames, String returnType, String[] typeParameterNames, boolean isDeprecated, String lineDelimiter) throws BadLocationException {
        int prevLine;
        IRegion region = textBuffer.getLineInformationOfOffset(offset);
        if (region == null) {
            return;
        }
        String lineStart = textBuffer.get(region.getOffset(), offset - region.getOffset());
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < typeParameterNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param <").append(typeParameterNames[i]).append('>');
            ++i;
        }
        i = 0;
        while (i < paramNames.length) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@param ").append(paramNames[i]);
            ++i;
        }
        if (returnType != null && !"void".equals(returnType)) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@return");
        }
        if (exceptionNames != null) {
            i = 0;
            while (i < exceptionNames.length) {
                if (buf.length() > 0) {
                    buf.append(lineDelimiter).append(lineStart);
                }
                buf.append("@throws ").append(exceptionNames[i]);
                ++i;
            }
        }
        if (isDeprecated) {
            if (buf.length() > 0) {
                buf.append(lineDelimiter).append(lineStart);
            }
            buf.append("@deprecated");
        }
        if (buf.length() == 0 && JdtSettingsCommentSourceBuilderDelegate.isAllCommentWhitespace(lineStart) && (prevLine = textBuffer.getLineOfOffset(offset) - 1) > 0) {
            IRegion prevRegion = textBuffer.getLineInformation(prevLine);
            int prevLineEnd = prevRegion.getOffset() + prevRegion.getLength();
            textBuffer.replace(prevLineEnd, offset + length - prevLineEnd, "");
            return;
        }
        textBuffer.replace(offset, length, buf.toString());
    }

    private static boolean isAllCommentWhitespace(String lineStart) {
        int i = 0;
        while (i < lineStart.length()) {
            char ch = lineStart.charAt(i);
            if (!Character.isWhitespace(ch) && ch != '*') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final class UsernameResolver
    extends GlobalTemplateVariables.User {
        private UsernameResolver() {
        }

        protected String resolve(TemplateContext context) {
            return CoreUtils.getUsername();
        }
    }
}

