/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.api.query;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ContainerDropDescription;
import org.eclipse.sirius.diagram.description.tool.DeleteElementDescription;
import org.eclipse.sirius.diagram.description.tool.DirectEditLabel;
import org.eclipse.sirius.diagram.description.tool.DoubleClickDescription;
import org.eclipse.sirius.diagram.description.tool.EdgeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.NodeCreationDescription;
import org.eclipse.sirius.diagram.description.tool.ReconnectEdgeDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.tool.MappingBasedToolDescription;

public class MappingBasedToolDescriptionQuery {
    private MappingBasedToolDescription toolDescription;

    public MappingBasedToolDescriptionQuery(MappingBasedToolDescription toolDescription) {
        this.toolDescription = toolDescription;
    }

    public Collection<RepresentationElementMapping> getMappings() {
        LinkedHashSet mappings = Sets.newLinkedHashSet();
        if (this.toolDescription instanceof ContainerCreationDescription) {
            ContainerCreationDescription ccd = (ContainerCreationDescription)this.toolDescription;
            mappings.addAll(ccd.getContainerMappings());
            mappings.addAll(ccd.getExtraMappings());
        }
        if (this.toolDescription instanceof ContainerDropDescription) {
            mappings.addAll(((ContainerDropDescription)this.toolDescription).getMappings());
        }
        if (this.toolDescription instanceof DeleteElementDescription) {
            mappings.addAll(((DeleteElementDescription)this.toolDescription).getMappings());
        }
        if (this.toolDescription instanceof DirectEditLabel) {
            mappings.addAll(((DirectEditLabel)this.toolDescription).getMapping());
        }
        if (this.toolDescription instanceof DoubleClickDescription) {
            mappings.addAll(((DoubleClickDescription)this.toolDescription).getMappings());
        }
        if (this.toolDescription instanceof EdgeCreationDescription) {
            EdgeCreationDescription ecd = (EdgeCreationDescription)this.toolDescription;
            mappings.addAll(ecd.getEdgeMappings());
            mappings.addAll(ecd.getExtraSourceMappings());
        }
        if (this.toolDescription instanceof NodeCreationDescription) {
            NodeCreationDescription ncd = (NodeCreationDescription)this.toolDescription;
            mappings.addAll(ncd.getNodeMappings());
            mappings.addAll(ncd.getExtraMappings());
        }
        if (this.toolDescription instanceof ReconnectEdgeDescription) {
            mappings.addAll(((ReconnectEdgeDescription)this.toolDescription).getMappings());
        }
        return mappings;
    }
}

