/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.latency;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;

public final class SystemCall
implements INamedSegment {
    private static final long serialVersionUID = 1554494342105208730L;
    public static final IHTIntervalReader<ISegment> READER = buffer -> new SystemCall(buffer.getLong(), buffer.getLong(), buffer.getString());
    private final long fStartTime;
    private final long fEndTime;
    private final String fName;

    public SystemCall(InitialInfo info, long endTime) {
        this.fStartTime = info.fStartTime;
        this.fName = info.fName;
        this.fEndTime = endTime;
    }

    private SystemCall(long startTime, long endTime, String name) {
        this.fStartTime = startTime;
        this.fEndTime = endTime;
        this.fName = name;
    }

    public long getStart() {
        return this.fStartTime;
    }

    public long getEnd() {
        return this.fEndTime;
    }

    public String getName() {
        return this.fName;
    }

    public int getSizeOnDisk() {
        return 16 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.fName);
    }

    public void writeSegment(@NonNull ISafeByteBufferWriter buffer) {
        buffer.putLong(this.fStartTime);
        buffer.putLong(this.fEndTime);
        buffer.putString(this.fName);
    }

    public int compareTo(@NonNull ISegment o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return "Start Time = " + this.getStart() + "; End Time = " + this.getEnd() + "; Duration = " + this.getLength() + "; Name = " + this.getName();
    }

    public static class InitialInfo {
        private long fStartTime;
        private String fName;

        public InitialInfo(long startTime, String name) {
            this.fStartTime = startTime;
            this.fName = name.intern();
        }
    }
}

