/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core.segment.interfaces;

import java.util.Comparator;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.SegmentAspects;

public interface SegmentTypeComparators {
    public static final Comparator<ISegment> NAMED_SEGMENT_COMPARATOR = new Comparator<ISegment>(){

        @Override
        public int compare(@Nullable ISegment o1, @Nullable ISegment o2) {
            String name2;
            if (o1 == null || o2 == null) {
                throw new IllegalArgumentException("One of the segment to compare is null, that should never happen");
            }
            String name1 = SegmentAspects.getName(o1);
            if (Objects.equals(name1, name2 = SegmentAspects.getName(o2))) {
                return 0;
            }
            if (name2 == null) {
                return -1;
            }
            if (name1 == null) {
                return 1;
            }
            return name1.compareTo(name2);
        }
    };
}

