/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.LazyLoadingQueryGroup;
import org.eclipse.viatra.query.runtime.registry.IDefaultRegistryView;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.view.AbstractRegistryView;

public class GlobalRegistryView
extends AbstractRegistryView
implements IDefaultRegistryView {
    public GlobalRegistryView(IQuerySpecificationRegistry registry) {
        super(registry, false);
    }

    @Override
    protected boolean isEntryRelevant(IQuerySpecificationRegistryEntry entry) {
        return entry.includeInDefaultViews();
    }

    @Override
    public IQueryGroup getQueryGroup() {
        IQueryGroup queryGroup = LazyLoadingQueryGroup.of(ImmutableSet.copyOf((Collection)this.fqnToEntryMap.values()));
        return queryGroup;
    }

    @Override
    public IQuerySpecificationRegistryEntry getEntry(String fullyQualifiedName) {
        Set<IQuerySpecificationRegistryEntry> entries = this.getEntries(fullyQualifiedName);
        if (entries.isEmpty()) {
            throw new NoSuchElementException("Cannot find entry with FQN " + fullyQualifiedName);
        }
        if (entries.size() > 1) {
            throw new IllegalStateException("Global view must never contain duplicated FQNs!");
        }
        IQuerySpecificationRegistryEntry entry = entries.iterator().next();
        return entry;
    }
}

