/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.internal.emf.resource;

import java.io.IOException;
import org.eclipse.wst.common.internal.emf.plugin.EcoreUtilitiesPlugin;
import org.eclipse.wst.common.internal.emf.resource.CacheEventNode;
import org.eclipse.wst.common.internal.emf.resource.CacheEventPool;
import org.eclipse.wst.common.internal.emf.resource.CacheEventStack;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResource;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class EMF2SAXDocumentHandler
extends DefaultHandler {
    private TranslatorResource resource = null;
    private final CacheEventStack eventStack = new CacheEventStack();
    private CacheEventPool availableEventPool = new CacheEventPool();

    public EMF2SAXDocumentHandler(TranslatorResource resource) {
        this.resource = resource;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource result = null;
        this.resource.setDoctypeValues(publicId, systemId);
        try {
            EntityResolver entityResolver = this.resource.getEntityResolver();
            result = entityResolver != null ? entityResolver.resolveEntity(publicId, systemId) : super.resolveEntity(publicId, systemId);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        return result;
    }

    public void startDocument() throws SAXException {
        this.availableEventPool.warmPool();
        this.eventStack.clear();
        this.createRoot(this.resource);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.addToStack(qName, attributes);
    }

    public void characters(char[] data, int start, int length) throws SAXException {
        CacheEventNode currentRecord = this.getCurrentRecord();
        if (currentRecord != null) {
            currentRecord.appendToBuffer(data, start, length);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        CacheEventNode currentRecord = null;
        if (qName.equals(this.getCurrentRecord().getNodeName()) && (currentRecord = this.removeCurrentRecord()) != null) {
            currentRecord.commit();
        }
    }

    public void endDocument() throws SAXException {
        CacheEventNode lastRecord = this.removeCurrentRecord();
        lastRecord.commit();
        this.availableEventPool.freezePool();
    }

    public void error(SAXParseException ex) throws SAXException {
        throw ex;
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    public void warning(SAXParseException ex) throws SAXException {
        EcoreUtilitiesPlugin.logWarning(ex);
    }

    public TranslatorResource getResource() {
        return this.resource;
    }

    protected void createRoot(TranslatorResource resourceArg) {
        this.eventStack.push(this.availableEventPool.createCacheEventNode(resourceArg));
    }

    protected void addToStack(String nodeName, Attributes attributes) {
        CacheEventNode parent = this.getCurrentRecord();
        if (!parent.isChildIgnorable(nodeName)) {
            this.eventStack.push(this.availableEventPool.createCacheEventNode(parent, nodeName, attributes));
        }
    }

    protected CacheEventNode getCurrentRecord() {
        CacheEventNode result = null;
        if (!this.eventStack.isEmpty()) {
            result = this.eventStack.peek();
        }
        return result;
    }

    protected CacheEventNode removeCurrentRecord() {
        CacheEventNode result = null;
        if (!this.eventStack.isEmpty()) {
            result = this.eventStack.pop();
        }
        return result;
    }
}

