/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.debug.invoker;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.wst.xsl.jaxp.debug.invoker.Messages;
import org.eclipse.wst.xsl.jaxp.debug.invoker.TypedValue;
import org.eclipse.wst.xsl.jaxp.debug.invoker.internal.CreationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformDefinition {
    public static final String DEFAULT_CATALOG_RESOLVER = "org.apache.xml.resolver.tools.CatalogResolver";
    private String stylesheetURL;
    private String resolverClass = "org.apache.xml.resolver.tools.CatalogResolver";
    private Properties outputProperties = new Properties();
    private final Set<TypedValue> parameters = new HashSet<TypedValue>();

    public Map<String, Object> getParametersAsMap() throws CreationException {
        ConcurrentHashMap<String, Object> m = new ConcurrentHashMap<String, Object>();
        for (TypedValue tv : this.parameters) {
            String key = tv.name;
            Object value = tv.createValue();
            m.put(key, value);
        }
        return m;
    }

    public Set<TypedValue> getParameters() {
        return this.parameters;
    }

    public void addParameter(TypedValue parameter) {
        this.parameters.add(parameter);
    }

    public void removeParameter(TypedValue parameter) {
        this.parameters.remove(parameter);
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void setOutputProperties(Properties outputProperties) {
        this.outputProperties = outputProperties;
    }

    public void setOutputProperty(String name, String value) {
        this.outputProperties.put(name, value);
    }

    public void removeOutputProperty(String name) {
        this.outputProperties.remove(name);
    }

    public String getResolverClass() {
        return this.resolverClass;
    }

    public void setResolverClass(String resolver) {
        this.resolverClass = resolver;
    }

    public String getStylesheetURL() {
        return this.stylesheetURL;
    }

    public void setStylesheetURL(String stylesheet) {
        this.stylesheetURL = stylesheet;
    }

    public Element asXML(Document doc) {
        Element propEl;
        Element tdefEl = doc.createElement("Transform");
        tdefEl.setAttribute(Messages.getString("TransformDefinition.1"), this.stylesheetURL);
        if (this.resolverClass != null) {
            tdefEl.setAttribute("uriResolver", this.resolverClass);
        }
        Element opEl = doc.createElement("OutputProperties");
        tdefEl.appendChild(opEl);
        for (Map.Entry<Object, Object> entry : this.outputProperties.entrySet()) {
            propEl = doc.createElement("Property");
            propEl.setAttribute("name", (String)entry.getKey());
            propEl.setAttribute("value", (String)entry.getValue());
            opEl.appendChild(propEl);
        }
        Element paramsEl = doc.createElement("Parameters");
        tdefEl.appendChild(paramsEl);
        Iterator<TypedValue> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            propEl = doc.createElement("Parameter");
            TypedValue param = iter.next();
            propEl.setAttribute("name", param.name);
            propEl.setAttribute("type", param.type);
            propEl.setAttribute("value", param.value);
            paramsEl.appendChild(propEl);
        }
        return tdefEl;
    }

    public static TransformDefinition fromXML(Element transformEl) {
        Element paramsEl;
        TransformDefinition tdef = new TransformDefinition();
        String url = transformEl.getAttribute("url");
        tdef.setStylesheetURL(url);
        String uriResolver = transformEl.getAttribute("uriResolver");
        tdef.setResolverClass(uriResolver);
        Element opEl = (Element)transformEl.getElementsByTagName("OutputProperties").item(0);
        if (opEl != null) {
            NodeList propEls = opEl.getElementsByTagName("Property");
            int i = 0;
            while (i < propEls.getLength()) {
                Element propEl = (Element)propEls.item(i);
                String name = propEl.getAttribute("name");
                String value = propEl.getAttribute("value");
                tdef.setOutputProperty(name, value);
                ++i;
            }
        }
        if ((paramsEl = (Element)transformEl.getElementsByTagName(Messages.getString("TransformDefinition.18")).item(0)) != null) {
            NodeList paramEls = paramsEl.getElementsByTagName(Messages.getString("TransformDefinition.19"));
            int i = 0;
            while (i < paramEls.getLength()) {
                Element paramEl = (Element)paramEls.item(i);
                String name = paramEl.getAttribute(Messages.getString("TransformDefinition.20"));
                String type = paramEl.getAttribute(Messages.getString("TransformDefinition.21"));
                String value = paramEl.getAttribute(Messages.getString("TransformDefinition.22"));
                tdef.addParameter(new TypedValue(name, type, value));
                ++i;
            }
        }
        return tdef;
    }
}

