/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.AsyncRemoteCallCallback;
import ch.ethz.iks.r_osgi.RemoteOSGiException;
import ch.ethz.iks.r_osgi.RemoteOSGiService;
import ch.ethz.iks.r_osgi.RemoteServiceEvent;
import ch.ethz.iks.r_osgi.RemoteServiceListener;
import ch.ethz.iks.r_osgi.RemoteServiceReference;
import ch.ethz.iks.r_osgi.Remoting;
import ch.ethz.iks.r_osgi.URI;
import ch.ethz.iks.r_osgi.channels.ChannelEndpoint;
import ch.ethz.iks.r_osgi.channels.ChannelEndpointManager;
import ch.ethz.iks.r_osgi.channels.NetworkChannel;
import ch.ethz.iks.r_osgi.channels.NetworkChannelFactory;
import ch.ethz.iks.r_osgi.impl.ChannelEndpointImpl;
import ch.ethz.iks.r_osgi.impl.ChannelEndpointMultiplexer;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiActivator;
import ch.ethz.iks.r_osgi.impl.RemoteServiceReferenceImpl;
import ch.ethz.iks.r_osgi.impl.RemoteServiceRegistration;
import ch.ethz.iks.r_osgi.messages.LeaseUpdateMessage;
import ch.ethz.iks.r_osgi.service_discovery.ServiceDiscoveryHandler;
import ch.ethz.iks.util.CollectionUtils;
import ch.ethz.iks.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

final class RemoteOSGiServiceImpl
implements RemoteOSGiService,
Remoting {
    static boolean IS_JAVA5;
    static boolean IS_R4;
    private static final Method getEntry;
    private static final Method getEntryPaths;
    private static final File base;
    static int R_OSGI_PORT;
    static final String R_OSGi_PORT_PROPERTY = "ch.ethz.iks.r_osgi.port";
    static final String REGISTER_DEFAULT_TCP_CHANNEL = "ch.ethz.iks.r_osgi.registerDefaultChannel";
    static final String THREADS_PER_ENDPOINT = "ch.ethz.iks.r_osgi.threadsPerEndpoint";
    static final String PROXY_DEBUG_PROPERTY = "ch.ethz.iks.r_osgi.debug.proxyGeneration";
    static final String MSG_DEBUG_PROPERTY = "ch.ethz.iks.r_osgi.debug.messages";
    static final String DEBUG_PROPERTY = "ch.ethz.iks.r_osgi.debug.internal";
    static final String R_OSGi_INTERNAL = "internal";
    private static final String MANIFEST_FILE_NAME = "META-INF/MANIFEST.MF";
    private static final String SEPARATOR_CHAR = "/";
    private static final int BUFFER_SIZE = 2048;
    static final int MAX_THREADS_PER_ENDPOINT;
    static boolean PROXY_DEBUG;
    static boolean MSG_DEBUG;
    static boolean DEBUG;
    static String MY_ADDRESS;
    static Map serviceRegistrations;
    private static int nextXid;
    static LogService log;
    static ServiceTracker eventAdminTracker;
    private static ServiceTracker eventHandlerTracker;
    private static ServiceTracker remoteServiceTracker;
    private static ServiceTracker remoteServiceListenerTracker;
    private static ServiceTracker networkChannelFactoryTracker;
    private static ServiceTracker serviceDiscoveryHandlerTracker;
    private static Map channels;
    private static Map multiplexers;
    private static final Set topicFilters;
    private static PackageAdmin pkgAdmin;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    static {
        String osgiVerString;
        IS_JAVA5 = false;
        IS_R4 = false;
        String verString = System.getProperty("java.class.version");
        if (verString != null && Float.parseFloat(verString) >= 49.0f) {
            IS_JAVA5 = true;
        }
        if ((osgiVerString = System.getProperty("org.osgi.framework.version")) != null && !osgiVerString.trim().startsWith("1.3")) {
            IS_R4 = true;
        }
        Method m = null;
        Method n = null;
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.osgi.framework.Bundle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            m = clazz.getMethod("getEntry", classArray);
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("org.osgi.framework.Bundle");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Class[] classArray2 = new Class[1];
            Class<?> clazz4 = class$1;
            if (clazz4 == null) {
                try {
                    clazz4 = class$1 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray2[0] = clazz4;
            n = clazz3.getMethod("getEntryPaths", classArray2);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        getEntry = m;
        getEntryPaths = n;
        base = getEntry == null ? RemoteOSGiActivator.getActivator().getContext().getDataFile("../..") : null;
        R_OSGI_PORT = 9278;
        MAX_THREADS_PER_ENDPOINT = Integer.getInteger(THREADS_PER_ENDPOINT, 2);
        serviceRegistrations = new HashMap(1);
        channels = new HashMap(0);
        multiplexers = new HashMap(0);
        topicFilters = new HashSet(0);
    }

    RemoteOSGiServiceImpl() throws IOException {
        ServiceReference ref;
        String topics = System.getProperty("ch.ethz.iks.r_osgi.topic.filter", "");
        String[] strings = StringUtils.stringToArray(topics, ",");
        int i = 0;
        while (i < strings.length) {
            topicFilters.add(strings[i]);
            ++i;
        }
        topicFilters.add("org/osgi/service/remoteserviceadmin/*");
        try {
            MY_ADDRESS = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName())[0].getHostAddress();
        }
        catch (Throwable t) {
            MY_ADDRESS = System.getProperty("ch.ethz.iks.r_osgi.ip", "127.0.0.1");
        }
        BundleContext context = RemoteOSGiActivator.getActivator().getContext();
        String prop = context.getProperty(PROXY_DEBUG_PROPERTY);
        PROXY_DEBUG = prop != null ? Boolean.valueOf(prop) : false;
        prop = context.getProperty(MSG_DEBUG_PROPERTY);
        MSG_DEBUG = prop != null ? Boolean.valueOf(prop) : false;
        prop = context.getProperty(DEBUG_PROPERTY);
        boolean bl = DEBUG = prop != null ? Boolean.valueOf(prop) : false;
        if (log != null) {
            if (PROXY_DEBUG) {
                log.log(3, "PROXY DEBUG OUTPUTS ENABLED");
            }
            if (MSG_DEBUG) {
                log.log(3, "MESSAGE DEBUG OUTPUTS ENABLED");
            }
            if (DEBUG) {
                log.log(3, "INTERNAL DEBUG OUTPUTS ENABLED");
            }
        } else if (PROXY_DEBUG || MSG_DEBUG || DEBUG) {
            System.err.println("WARNING: NO LOG SERVICE PRESENT, DEBUG PROPERTIES HAVE NO EFFECT ...");
            PROXY_DEBUG = false;
            MSG_DEBUG = false;
            DEBUG = false;
        }
        R_OSGI_PORT = (prop = context.getProperty(R_OSGi_PORT_PROPERTY)) != null ? Integer.parseInt(prop) : 9278;
        nextXid = (short)Math.round(Math.random() * 32767.0);
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((ref = context.getServiceReference(clazz.getName())) == null) {
            throw new RuntimeException("No package admin service available, R-OSGi terminates.");
        }
        pkgAdmin = (PackageAdmin)context.getService(ref);
        this.setupTrackers(context);
    }

    private void setupTrackers(final BundleContext context) throws IOException {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.osgi.service.event.EventAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        eventAdminTracker = new ServiceTracker(context, clazz.getName(), null);
        eventAdminTracker.open();
        if (eventAdminTracker.getTrackingCount() == 0 && log != null) {
            log.log(2, "NO EVENT ADMIN FOUND. REMOTE EVENT DELIVERY TEMPORARILY DISABLED.");
        }
        try {
            Class<?> clazz2;
            StringBuffer stringBuffer = new StringBuffer("(&(objectClass=");
            Class<?> clazz3 = class$4;
            if (clazz3 == null) {
                try {
                    clazz3 = class$4 = Class.forName("org.osgi.service.event.EventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            eventHandlerTracker = new ServiceTracker(context, context.createFilter(stringBuffer.append(clazz3.getName()).append(")(|(!(").append(R_OSGi_INTERNAL).append("=*))").append("(!(").append("event.topics").append("=org/osgi/service/remoteserviceadmin/*))))").toString()), new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    Object topic = reference.getProperty("event.topics");
                    Collection<String> theTopics = topic instanceof String ? Arrays.asList((String)topic) : Arrays.asList((String[])topic);
                    theTopics = StringUtils.rightDifference(topicFilters, theTopics);
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)0);
                    lu.setServiceID("");
                    Object[] objectArray = new Object[2];
                    objectArray[0] = theTopics.toArray(new String[theTopics.size()]);
                    lu.setPayload(objectArray);
                    RemoteOSGiServiceImpl.updateLeases(lu);
                    return theTopics;
                }

                public void modifiedService(ServiceReference reference, Object oldTopics) {
                    List oldTopicList = (List)oldTopics;
                    Object topic = reference.getProperty("event.topics");
                    Collection<String> newTopicList = topic instanceof String ? Arrays.asList((String)topic) : Arrays.asList((String[])topic);
                    newTopicList = StringUtils.rightDifference(topicFilters, newTopicList);
                    Collection removed = CollectionUtils.rightDifference(newTopicList, oldTopicList);
                    Collection added = CollectionUtils.leftDifference(newTopicList, oldTopicList);
                    String[] addedTopics = added.toArray(new String[removed.size()]);
                    String[] removedTopics = removed.toArray(addedTopics);
                    oldTopicList.removeAll(removed);
                    oldTopicList.addAll(added);
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)0);
                    lu.setServiceID("");
                    lu.setPayload(new Object[]{addedTopics, removedTopics});
                    RemoteOSGiServiceImpl.updateLeases(lu);
                }

                public void removedService(ServiceReference reference, Object oldTopics) {
                    List oldTopicsList = (List)oldTopics;
                    String[] removedTopics = oldTopicsList.toArray(new String[oldTopicsList.size()]);
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)0);
                    lu.setServiceID("");
                    Object[] objectArray = new Object[2];
                    objectArray[1] = removedTopics;
                    lu.setPayload(objectArray);
                    RemoteOSGiServiceImpl.updateLeases(lu);
                }
            });
            eventHandlerTracker.open();
            if (DEBUG) {
                log.log(4, "Local topic space " + Arrays.asList(RemoteOSGiServiceImpl.getTopics()));
            }
            if ((clazz2 = class$5) == null) {
                try {
                    clazz2 = class$5 = Class.forName("ch.ethz.iks.r_osgi.RemoteServiceListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            remoteServiceListenerTracker = new ServiceTracker(context, clazz2.getName(), null);
            remoteServiceListenerTracker.open();
            Class<?> clazz4 = class$6;
            if (clazz4 == null) {
                try {
                    clazz4 = class$6 = Class.forName("ch.ethz.iks.r_osgi.service_discovery.ServiceDiscoveryHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            serviceDiscoveryHandlerTracker = new ServiceTracker(context, clazz4.getName(), new ServiceTrackerCustomizer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object addingService(ServiceReference reference) {
                    ServiceDiscoveryHandler handler = (ServiceDiscoveryHandler)context.getService(reference);
                    RemoteServiceRegistration[] regs = null;
                    Map map = serviceRegistrations;
                    synchronized (map) {
                        regs = serviceRegistrations.values().toArray(new RemoteServiceRegistration[serviceRegistrations.size()]);
                    }
                    int i = 0;
                    while (i < regs.length) {
                        handler.registerService(regs[i].getReference(), regs[i].getProperties(), URI.create("r-osgi://" + MY_ADDRESS + ":" + R_OSGI_PORT + "#" + regs[i].getServiceID()));
                        ++i;
                    }
                    return handler;
                }

                public void modifiedService(ServiceReference reference, Object service) {
                }

                public void removedService(ServiceReference reference, Object service) {
                }
            });
            serviceDiscoveryHandlerTracker.open();
            remoteServiceTracker = new ServiceTracker(context, context.createFilter("(service.remote.registration=*)"), new ServiceTrackerCustomizer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object addingService(ServiceReference reference) {
                    List<String> list = Arrays.asList((String[])reference.getProperty("objectClass"));
                    Class<?> clazz = class$7;
                    if (clazz == null) {
                        try {
                            clazz = class$7 = Class.forName("ch.ethz.iks.r_osgi.SurrogateRegistration");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ServiceReference service = list.contains(clazz.getName()) ? (ServiceReference)reference.getProperty("legacy.service.reference") : reference;
                    try {
                        RemoteServiceRegistration reg = new RemoteServiceRegistration(reference, service);
                        if (log != null) {
                            log.log(3, "REGISTERING " + reference + " AS PROXIED SERVICES");
                        }
                        Map map = serviceRegistrations;
                        synchronized (map) {
                            serviceRegistrations.put(service, reg);
                        }
                        RemoteOSGiServiceImpl.this.registerWithServiceDiscovery(reg);
                        LeaseUpdateMessage lu = new LeaseUpdateMessage();
                        lu.setType((short)1);
                        lu.setServiceID(String.valueOf(reg.getServiceID()));
                        lu.setPayload(new Object[]{reg.getInterfaceNames(), reg.getProperties()});
                        RemoteOSGiServiceImpl.updateLeases(lu);
                        return service;
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                        throw new RemoteOSGiException("Cannot find class " + service, e);
                    }
                }

                public void modifiedService(ServiceReference reference, Object service) {
                    if (reference.getProperty("service.remote.registration") == null) {
                        this.removedService(reference, service);
                        return;
                    }
                    RemoteServiceRegistration reg = (RemoteServiceRegistration)serviceRegistrations.get(reference);
                    RemoteOSGiServiceImpl.this.registerWithServiceDiscovery(reg);
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)2);
                    lu.setServiceID(String.valueOf(reg.getServiceID()));
                    Object[] objectArray = new Object[2];
                    objectArray[1] = reg.getProperties();
                    lu.setPayload(objectArray);
                    RemoteOSGiServiceImpl.updateLeases(lu);
                }

                public void removedService(ServiceReference reference, Object service) {
                    List<String> list = Arrays.asList((String[])reference.getProperty("objectClass"));
                    Class<?> clazz = class$7;
                    if (clazz == null) {
                        try {
                            clazz = class$7 = Class.forName("ch.ethz.iks.r_osgi.SurrogateRegistration");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    ServiceReference sref = list.contains(clazz.getName()) ? (ServiceReference)reference.getProperty("legacy.service.reference") : reference;
                    RemoteServiceRegistration reg = (RemoteServiceRegistration)serviceRegistrations.remove(sref);
                    RemoteOSGiServiceImpl.this.unregisterFromServiceDiscovery(reg);
                    LeaseUpdateMessage lu = new LeaseUpdateMessage();
                    lu.setType((short)3);
                    lu.setServiceID(String.valueOf(reg.getServiceID()));
                    lu.setPayload(new Object[2]);
                    RemoteOSGiServiceImpl.updateLeases(lu);
                }
            });
            remoteServiceTracker.open(true);
            StringBuffer stringBuffer2 = new StringBuffer("(objectClass=");
            Class<?> clazz5 = class$8;
            if (clazz5 == null) {
                try {
                    clazz5 = class$8 = Class.forName("ch.ethz.iks.r_osgi.channels.NetworkChannelFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            networkChannelFactoryTracker = new ServiceTracker(context, context.createFilter(stringBuffer2.append(clazz5.getName()).append(")").toString()), new ServiceTrackerCustomizer(){

                public Object addingService(ServiceReference reference) {
                    NetworkChannelFactory factory;
                    block2: {
                        factory = (NetworkChannelFactory)context.getService(reference);
                        try {
                            factory.activate(RemoteOSGiServiceImpl.this);
                        }
                        catch (IOException ioe) {
                            if (log == null) break block2;
                            log.log(1, ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                    return factory;
                }

                public void modifiedService(ServiceReference reference, Object factory) {
                }

                public void removedService(ServiceReference reference, Object factory) {
                }
            });
            networkChannelFactoryTracker.open();
        }
        catch (InvalidSyntaxException ise) {
            ise.printStackTrace();
        }
    }

    private NetworkChannelFactory getNetworkChannelFactory(String protocol) throws RemoteOSGiException {
        try {
            Filter filter = RemoteOSGiActivator.getActivator().getContext().createFilter("(protocol=" + protocol + ")");
            ServiceReference[] refs = networkChannelFactoryTracker.getServiceReferences();
            if (refs != null) {
                int i = 0;
                while (i < refs.length) {
                    if (filter.match(refs[i])) {
                        return (NetworkChannelFactory)networkChannelFactoryTracker.getService(refs[i]);
                    }
                    ++i;
                }
            }
            throw new RemoteOSGiException("No NetworkChannelFactory for " + protocol + " found.");
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RemoteServiceReference[] connect(URI uri) throws RemoteOSGiException, IOException {
        URI endpoint = URI.create(RemoteOSGiServiceImpl.getChannelURI(uri));
        ChannelEndpointImpl test = (ChannelEndpointImpl)channels.get(endpoint.toString());
        if (test != null) {
            ++test.usageCounter;
            return test.getAllRemoteReferences(null);
        }
        String protocol = endpoint.getScheme();
        NetworkChannelFactory factory = this.getNetworkChannelFactory(protocol);
        ChannelEndpointImpl channel = new ChannelEndpointImpl(factory, endpoint);
        return channel.sendLease(RemoteOSGiServiceImpl.getServices(endpoint.getScheme()), RemoteOSGiServiceImpl.getTopics());
    }

    public int getListeningPort(String protocol) throws RemoteOSGiException {
        NetworkChannelFactory factory = this.getNetworkChannelFactory(protocol);
        return factory.getListeningPort(protocol);
    }

    public void disconnect(URI endpoint) throws RemoteOSGiException {
        String channelURI = RemoteOSGiServiceImpl.getChannelURI(endpoint).toString();
        ChannelEndpointImpl channel = (ChannelEndpointImpl)channels.get(channelURI);
        if (channel != null) {
            if (channel.usageCounter == 1) {
                channel.dispose();
                multiplexers.remove(channelURI);
            } else {
                --channel.usageCounter;
            }
        }
    }

    public RemoteServiceReference getRemoteServiceReference(URI serviceURI) {
        String uri = RemoteOSGiServiceImpl.getChannelURI(serviceURI);
        ChannelEndpointImpl channel = (ChannelEndpointImpl)channels.get(RemoteOSGiServiceImpl.getChannelURI(serviceURI));
        if (channel == null) {
            try {
                this.connect(serviceURI);
                channel = (ChannelEndpointImpl)channels.get(uri);
            }
            catch (IOException ioe) {
                throw new RemoteOSGiException("Cannot connect to " + uri);
            }
        }
        return channel.getRemoteReference(serviceURI.toString());
    }

    public RemoteServiceReference[] getRemoteServiceReferences(URI service, String clazz, Filter filter) {
        String uri = RemoteOSGiServiceImpl.getChannelURI(service);
        ChannelEndpointImpl channel = (ChannelEndpointImpl)channels.get(uri);
        if (channel == null) {
            try {
                this.connect(service);
                channel = (ChannelEndpointImpl)channels.get(uri);
            }
            catch (IOException ioe) {
                throw new RemoteOSGiException("Cannot connect to " + uri);
            }
        }
        if (clazz == null) {
            return channel.getAllRemoteReferences(null);
        }
        try {
            return channel.getAllRemoteReferences(RemoteOSGiActivator.getActivator().getContext().createFilter(filter != null ? "(&" + filter + "(" + "objectClass" + "=" + clazz + "))" : "(objectClass=" + clazz + ")"));
        }
        catch (InvalidSyntaxException ise) {
            ise.printStackTrace();
            return null;
        }
    }

    public Object getRemoteService(RemoteServiceReference ref) {
        if (ref == null) {
            throw new IllegalArgumentException("Remote Reference is null.");
        }
        ServiceReference sref = this.getFetchedServiceReference(ref);
        if (sref == null) {
            this.fetchService(ref);
            sref = this.getFetchedServiceReference(ref);
        }
        return sref == null ? null : RemoteOSGiActivator.getActivator().getContext().getService(sref);
    }

    public Object getRemoteServiceBundle(RemoteServiceReference ref, int timeout) throws InterruptedException {
        if (ref == null) {
            throw new IllegalArgumentException("Remote Reference is null.");
        }
        RemoteOSGiServiceImpl.getChannel(ref.getURI()).getCloneBundle(ref);
        if (timeout < 0) {
            return null;
        }
        ServiceTracker tracker = new ServiceTracker(RemoteOSGiActivator.getActivator().getContext(), ref.getServiceInterfaces()[0], null);
        tracker.open();
        tracker.waitForService(0L);
        return tracker.getService();
    }

    private ServiceReference getFetchedServiceReference(RemoteServiceReference ref) {
        try {
            ServiceReference[] refs = RemoteOSGiActivator.getActivator().getContext().getServiceReferences(ref.getServiceInterfaces()[0], "(service.uri=" + ref.getURI() + ")");
            if (refs != null) {
                return refs[0];
            }
        }
        catch (InvalidSyntaxException doesNotHappen) {
            doesNotHappen.printStackTrace();
        }
        return null;
    }

    private void fetchService(RemoteServiceReference ref) throws RemoteOSGiException {
        try {
            ChannelEndpointImpl channel = ((RemoteServiceReferenceImpl)ref).getChannel();
            channel.getProxyBundle(ref);
        }
        catch (UnknownHostException e) {
            throw new RemoteOSGiException("Cannot resolve host " + ref.getURI(), e);
        }
        catch (IOException ioe) {
            throw new RemoteOSGiException("Proxy generation error", ioe);
        }
    }

    static ChannelEndpointImpl getChannel(URI uri) {
        return (ChannelEndpointImpl)channels.get(RemoteOSGiServiceImpl.getChannelURI(uri));
    }

    public ChannelEndpoint getEndpoint(String uri) {
        return this.getMultiplexer(uri);
    }

    public ChannelEndpointManager getEndpointManager(URI remoteEndpointAddress) {
        return this.getMultiplexer(remoteEndpointAddress.toString());
    }

    private ChannelEndpointMultiplexer getMultiplexer(String uri) {
        String channel = RemoteOSGiServiceImpl.getChannelURI(URI.create(uri));
        ChannelEndpointMultiplexer multiplexer = (ChannelEndpointMultiplexer)multiplexers.get(channel);
        if (multiplexer == null || !multiplexer.isConnected()) {
            multiplexer = new ChannelEndpointMultiplexer((ChannelEndpointImpl)channels.get(channel));
            multiplexers.put(channel, multiplexer);
        }
        return multiplexer;
    }

    private static String getChannelURI(URI serviceURI) {
        return URI.create(String.valueOf(serviceURI.getScheme()) + "://" + serviceURI.getHost() + ":" + serviceURI.getPort()).toString();
    }

    void cleanup() {
        ChannelEndpoint[] c = channels.values().toArray(new ChannelEndpoint[channels.size()]);
        channels.clear();
        int i = 0;
        while (i < c.length) {
            c[i].dispose();
            ++i;
        }
        Object[] factories = networkChannelFactoryTracker.getServices();
        if (factories != null) {
            int i2 = 0;
            while (i2 < factories.length) {
                block5: {
                    try {
                        ((NetworkChannelFactory)factories[i2]).deactivate(this);
                    }
                    catch (IOException ioe) {
                        if (log == null) break block5;
                        log.log(1, ioe.getMessage(), (Throwable)ioe);
                    }
                }
                ++i2;
            }
        }
        eventAdminTracker.close();
        remoteServiceTracker.close();
        serviceDiscoveryHandlerTracker.close();
        remoteServiceListenerTracker.close();
        networkChannelFactoryTracker.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemoteServiceRegistration[] getServices(String transport) {
        ArrayList results = new ArrayList();
        Map map = serviceRegistrations;
        synchronized (map) {
            Iterator i = serviceRegistrations.keySet().iterator();
            while (i.hasNext()) {
                ServiceReference ref = (ServiceReference)i.next();
                Object propVal = ref.getProperty("service.remote.registration");
                if (transport != null && propVal != null && !propVal.equals(Boolean.TRUE) && !propVal.equals(transport)) continue;
                results.add(serviceRegistrations.get(ref));
            }
        }
        return results.toArray(new RemoteServiceRegistration[results.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemoteServiceRegistration getServiceRegistration(String serviceID) {
        ServiceReference[] refs;
        block7: {
            String filter = "".equals(serviceID) ? null : "(service.id=" + serviceID + ")";
            try {
                refs = RemoteOSGiActivator.getActivator().getContext().getAllServiceReferences(null, filter);
                if (refs != null) break block7;
                if (log != null) {
                    log.log(2, "COULD NOT FIND " + filter);
                }
                return null;
            }
            catch (InvalidSyntaxException e) {
                e.printStackTrace();
                return null;
            }
        }
        Map map = serviceRegistrations;
        synchronized (map) {
            return (RemoteServiceRegistration)serviceRegistrations.get(refs[0]);
        }
    }

    static String[] getTopics() {
        Object[] topicLists = eventHandlerTracker.getServices();
        ArrayList topics = new ArrayList();
        if (topicLists != null) {
            int i = 0;
            while (i < topicLists.length) {
                topics.addAll((List)topicLists[i]);
                ++i;
            }
        }
        return topics.toArray(new String[topics.size()]);
    }

    static synchronized int nextXid() {
        if (nextXid == -1) {
            nextXid = 0;
        }
        return ++nextXid;
    }

    static void registerChannelEndpoint(ChannelEndpoint channel) {
        channels.put(channel.getRemoteAddress().toString(), channel);
    }

    static void unregisterChannelEndpoint(String channelURI) {
        channels.remove(channelURI);
    }

    static void updateLeases(LeaseUpdateMessage msg) {
        ChannelEndpointImpl[] endpoints = channels.values().toArray(new ChannelEndpointImpl[channels.size()]);
        int i = 0;
        while (i < endpoints.length) {
            endpoints[i].sendLeaseUpdate(msg);
            ++i;
        }
    }

    static void notifyRemoteServiceListeners(RemoteServiceEvent event) {
        ServiceReference[] refs = remoteServiceListenerTracker.getServiceReferences();
        if (refs == null) {
            return;
        }
        HashSet<String> serviceIfaces = new HashSet<String>(Arrays.asList(event.getRemoteReference().getServiceInterfaces()));
        int i = 0;
        while (i < refs.length) {
            String[] ifaces = (String[])refs[i].getProperty("listener.service_interfaces");
            if (ifaces == null) {
                RemoteOSGiServiceImpl.match(refs[i], event);
            } else {
                int j = 0;
                while (j < ifaces.length) {
                    if (serviceIfaces.contains(ifaces[j])) {
                        RemoteOSGiServiceImpl.match(refs[i], event);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static void match(ServiceReference ref, RemoteServiceEvent event) {
        RemoteServiceListener listener;
        Filter filter = (Filter)ref.getProperty("listener.filter");
        if ((filter == null || filter.match(((RemoteServiceReferenceImpl)event.getRemoteReference()).getProperties())) && (listener = (RemoteServiceListener)remoteServiceListenerTracker.getService(ref)) != null) {
            listener.remoteServiceEvent(event);
        }
    }

    void registerWithServiceDiscovery(RemoteServiceRegistration reg) {
        Object[] handler = serviceDiscoveryHandlerTracker.getServices();
        if (handler != null) {
            int i = 0;
            while (i < handler.length) {
                Dictionary props = reg.getProperties();
                ((ServiceDiscoveryHandler)handler[i]).registerService(reg.getReference(), props, URI.create("r-osgi://" + MY_ADDRESS + ":" + R_OSGI_PORT + "#" + reg.getServiceID()));
                ++i;
            }
        }
    }

    void unregisterFromServiceDiscovery(RemoteServiceRegistration reg) {
        Object[] handler = serviceDiscoveryHandlerTracker.getServices();
        if (handler != null) {
            int i = 0;
            while (i < handler.length) {
                ((ServiceDiscoveryHandler)handler[i]).unregisterService(reg.getReference());
                ++i;
            }
        }
    }

    static byte[] getBundle(Bundle bundle) throws IOException {
        ByteArrayOutputStream out;
        byte[] buffer = new byte[2048];
        CRC32 crc = getEntry == null ? null : new CRC32();
        ByteArrayOutputStream byteArrayOutputStream = out = getEntry == null ? new ByteArrayOutputStream(2048) : null;
        if (getEntry == null) {
            return RemoteOSGiServiceImpl.getBundleConcierge(bundle, buffer, out);
        }
        try {
            String prefix = getEntry.invoke((Object)bundle, pkgAdmin.getExportedPackages(bundle)[0].getName().replace('.', '/')) == null ? "/bin" : "";
            return RemoteOSGiServiceImpl.generateBundle(bundle, prefix, buffer, crc);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    static byte[][] getBundlesForPackages(String[] packages) throws IOException {
        HashSet<Bundle> visitedBundles = new HashSet<Bundle>(packages.length);
        ArrayList<byte[]> bundleBytes = new ArrayList<byte[]>(packages.length);
        byte[] buffer = new byte[2048];
        CRC32 crc = getEntry == null ? null : new CRC32();
        ByteArrayOutputStream out = getEntry == null ? new ByteArrayOutputStream(2048) : null;
        int i = 0;
        while (i < packages.length) {
            Bundle bundle = pkgAdmin.getExportedPackage(packages[i]).getExportingBundle();
            if (!visitedBundles.contains(bundle)) {
                visitedBundles.add(bundle);
                if (getEntry == null) {
                    bundleBytes.add(RemoteOSGiServiceImpl.getBundleConcierge(bundle, buffer, out));
                } else {
                    try {
                        String prefix = getEntry.invoke((Object)bundle, packages[i].replace('.', '/')) == null ? "/bin" : "";
                        bundleBytes.add(RemoteOSGiServiceImpl.generateBundle(bundle, prefix, buffer, crc));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IOException(e.getMessage());
                    }
                }
            }
            ++i;
        }
        return (byte[][])bundleBytes.toArray((T[])new byte[bundleBytes.size()][]);
    }

    private static byte[] getBundleConcierge(Bundle bundle, byte[] buffer, ByteArrayOutputStream out) throws IOException {
        int read;
        FileInputStream in = new FileInputStream(new File(base, String.valueOf(bundle.getBundleId()) + "/bundle"));
        out.reset();
        while ((read = in.read(buffer, 0, 2048)) > -1) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }

    static boolean checkPackageImport(String pkg) {
        if (pkg.startsWith("org.osgi")) {
            return true;
        }
        return pkgAdmin.getExportedPackage(pkg) != null;
    }

    private static byte[] generateBundle(Bundle bundle, String prefix, byte[] buffer, CRC32 crc) throws Exception {
        URL url = (URL)getEntry.invoke((Object)bundle, "/META-INF/MANIFEST.MF");
        Manifest mf = new Manifest();
        mf.read(url.openStream());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        JarOutputStream out = new JarOutputStream((OutputStream)bout, mf);
        RemoteOSGiServiceImpl.scan(bundle, prefix, "", out, buffer, crc);
        out.flush();
        out.finish();
        out.close();
        return bout.toByteArray();
    }

    /*
     * Unable to fully structure code
     */
    private static void scan(Bundle bundle, String prefix, String path, JarOutputStream out, byte[] buffer, CRC32 crc) throws Exception {
        e = (Enumeration)RemoteOSGiServiceImpl.getEntryPaths.invoke((Object)bundle, new Object[]{String.valueOf(prefix) + "/" + path});
        if (e != null) ** GOTO lbl24
        return;
lbl-1000:
        // 1 sources

        {
            entry = ((String)e.nextElement()).substring(prefix.length());
            if (entry.equals("META-INF/MANIFEST.MF")) continue;
            if (entry.endsWith("/")) {
                RemoteOSGiServiceImpl.scan(bundle, prefix, entry, out, buffer, crc);
                continue;
            }
            url = bundle.getResource(String.valueOf(prefix) + "/" + entry);
            in = url.openStream();
            totallyRead = 0;
            jarEntry = new JarEntry(entry);
            out.putNextEntry(jarEntry);
            crc.reset();
            while ((read = in.read(buffer, 0, 2048)) > -1) {
                totallyRead += read;
                out.write(buffer, 0, read);
                crc.update(buffer, 0, read);
            }
            jarEntry.setSize(totallyRead);
            jarEntry.setCrc(crc.getValue());
            out.flush();
            out.closeEntry();
lbl24:
            // 4 sources

            ** while (e.hasMoreElements())
        }
lbl25:
        // 1 sources

    }

    public void createEndpoint(NetworkChannel channel) {
        new ChannelEndpointImpl(channel);
    }

    public void ungetRemoteService(RemoteServiceReference remoteServiceReference) {
        ((RemoteServiceReferenceImpl)remoteServiceReference).getChannel().ungetRemoteService(remoteServiceReference.getURI());
    }

    public void asyncRemoteCall(URI service, String methodSignature, Object[] args, AsyncRemoteCallCallback callback) {
        ChannelEndpointImpl endpoint = RemoteOSGiServiceImpl.getChannel(service);
        endpoint.asyncRemoteCall(service.getFragment(), methodSignature, args, callback);
    }
}

