/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.ui.editors;

import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTArraySubscriptExpression;
import org.eclipse.cdt.core.dom.ast.IASTBinaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTImageLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorElseStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorEndifStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfdefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorIfndefStatement;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeleteExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNewExpression;
import org.eclipse.cdt.core.dom.ast.gnu.IGNUASTCompoundStatementExpression;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.internal.ui.CDebugUIMessages;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.ui.CDebugUIPlugin;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.cdt.ui.text.SharedASTJob;
import org.eclipse.cdt.ui.text.c.hover.ICEditorTextHover;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public abstract class AbstractDebugTextHover
implements ICEditorTextHover,
ITextHoverExtension {
    private static final int MAX_HOVER_INFO_SIZE = 100;
    private IEditorPart fEditor;

    protected abstract boolean canEvaluate();

    protected abstract String evaluateExpression(String var1);

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String expression;
        if (this.canEvaluate() && (expression = this.getExpressionText(textViewer, hoverRegion)) != null) {
            String result = this.evaluateExpression(expression);
            if (result == null) {
                return null;
            }
            try {
                StringBuilder buffer = new StringBuilder();
                AbstractDebugTextHover.appendVariable(buffer, AbstractDebugTextHover.makeHTMLSafe(expression), AbstractDebugTextHover.makeHTMLSafe(result.trim()));
                if (buffer.length() > 0) {
                    return buffer.toString();
                }
            }
            catch (DebugException x) {
                CDebugUIPlugin.log(x);
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer viewer, int offset) {
        if (viewer != null) {
            return CDebugUIUtils.findWord(viewer.getDocument(), offset);
        }
        return null;
    }

    public final void setEditor(IEditorPart editor) {
        if (editor != null) {
            this.fEditor = editor;
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        return null;
    }

    protected String getExpressionText(ITextViewer textViewer, IRegion hoverRegion) {
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        String expression = this.getExpressionTextFromAST(document, hoverRegion);
        if (expression == null) {
            try {
                return document.get(hoverRegion.getOffset(), hoverRegion.getLength());
            }
            catch (BadLocationException badLocationException) {
            }
        } else if (expression.length() == 0) {
            return null;
        }
        return expression;
    }

    private String getExpressionTextFromAST(IDocument document, final IRegion hoverRegion) {
        ICElement cElement = CDTUITools.getEditorInputCElement((IEditorInput)this.getEditor().getEditorInput());
        if (!(cElement instanceof ITranslationUnit)) {
            return null;
        }
        final Position expressionPosition = new Position(0);
        SharedASTJob job = new SharedASTJob(CDebugUIMessages.getString("AbstractDebugTextHover.jobName"), (ITranslationUnit)cElement){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) throws CoreException {
                if (ast == null) {
                    return Status.CANCEL_STATUS;
                }
                int offset = hoverRegion.getOffset();
                int length = hoverRegion.getLength();
                IASTName name = ast.getNodeSelector(null).findEnclosingName(offset, length);
                if (name != null) {
                    IASTImageLocation imageLoc = name.getImageLocation();
                    int kind = imageLoc.getLocationKind();
                    switch (kind) {
                        case 3: {
                            this.computeMacroArgumentExtent(name, expressionPosition);
                            return Status.OK_STATUS;
                        }
                        default: {
                            if (name.getParent() instanceof IASTPreprocessorMacroExpansion) {
                                IASTFileLocation exprLoc;
                                IASTNode node = ast.getNodeSelector(null).findEnclosingNodeInExpansion(imageLoc.getNodeOffset(), imageLoc.getNodeLength());
                                if (!(node instanceof IASTExpression) || (exprLoc = node.getFileLocation()).getNodeOffset() != imageLoc.getNodeOffset()) return Status.OK_STATUS;
                                this.computeExpressionExtent(node, expressionPosition);
                                return Status.OK_STATUS;
                            }
                            this.computeExpressionExtent((IASTNode)name, expressionPosition);
                            return Status.OK_STATUS;
                        }
                    }
                } else {
                    IASTNode node = ast.getNodeSelector(null).findEnclosingNode(offset, length);
                    if (!(node instanceof IASTExpression)) {
                        node = ast.getNodeSelector(null).findFirstContainedNode(offset, length);
                    }
                    if (node instanceof IASTExpression) {
                        this.computeExpressionExtent(node, expressionPosition);
                        return Status.OK_STATUS;
                    } else {
                        if (node != null || !this.insideInactiveCode(ast, offset) || this.insideComment(ast, offset)) return Status.OK_STATUS;
                        return Status.CANCEL_STATUS;
                    }
                }
            }

            private void computeMacroArgumentExtent(IASTName name, Position pos) {
                ExpressionChecker checker;
                IASTImageLocation imageLoc = name.getImageLocation();
                int startOffset = imageLoc.getNodeOffset();
                int endOffset = startOffset + imageLoc.getNodeLength();
                IASTNode expr = name.getParent();
                int macroOffset = name.getFileLocation().getNodeOffset();
                if (expr instanceof IASTFieldReference) {
                    IASTName ownerName;
                    IASTImageLocation ownerImageLoc;
                    int nameOffset;
                    IASTExpression ownerExpr = ((IASTFieldReference)expr).getFieldOwner();
                    while (ownerExpr instanceof IASTFieldReference || ownerExpr instanceof IASTArraySubscriptExpression) {
                        ownerExpr = ownerExpr instanceof IASTArraySubscriptExpression ? ((IASTArraySubscriptExpression)ownerExpr).getArrayExpression() : ((IASTFieldReference)ownerExpr).getFieldOwner();
                    }
                    if (ownerExpr instanceof IASTIdExpression && (nameOffset = (ownerImageLoc = (ownerName = ((IASTIdExpression)ownerExpr).getName()).getImageLocation()).getNodeOffset()) < startOffset && nameOffset > macroOffset) {
                        startOffset = nameOffset;
                    }
                }
                if ((checker = new ExpressionChecker()).check(expr)) {
                    pos.offset = startOffset;
                    pos.length = endOffset - startOffset;
                }
            }

            private void computeExpressionExtent(IASTNode node0, Position pos) {
                IASTNodeLocation[] locations;
                IASTNode node = node0;
                while (node != null && !(node instanceof IASTExpression) && !(node instanceof IASTDeclaration)) {
                    node = node.getParent();
                }
                IASTImageLocation loc = null;
                if (node instanceof IASTExpression && !(node instanceof IASTIdExpression)) {
                    ExpressionChecker checker = new ExpressionChecker();
                    if (checker.check(node)) {
                        loc = node.getFileLocation();
                    }
                } else if (node0 instanceof IASTName && (loc = ((IASTName)node0).getImageLocation()) == null && (locations = node0.getNodeLocations()).length == 1 && !(locations[0] instanceof IASTMacroExpansionLocation)) {
                    loc = locations[0];
                }
                if (loc != null) {
                    pos.offset = loc.getNodeOffset();
                    pos.length = loc.getNodeLength();
                }
            }

            private boolean insideInactiveCode(IASTTranslationUnit ast, int offset) {
                IASTPreprocessorStatement[] preprocStmts;
                int inactiveCodeStart = -1;
                boolean inInactiveCode = false;
                Stack<Boolean> inactiveCodeStack = new Stack<Boolean>();
                IASTPreprocessorStatement[] iASTPreprocessorStatementArray = preprocStmts = ast.getAllPreprocessorStatements();
                int n = preprocStmts.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTFileLocation nodeLocation;
                    IASTPreprocessorStatement preprocStmt = iASTPreprocessorStatementArray[n2];
                    IASTPreprocessorStatement statement = preprocStmt;
                    if (statement.isPartOfTranslationUnitFile() && (nodeLocation = statement.getFileLocation()) != null) {
                        int inactiveCodeEnd;
                        int nodeOffset = nodeLocation.getNodeOffset();
                        int nodeEnd = nodeOffset + nodeLocation.getNodeLength();
                        if (nodeOffset <= offset && offset < nodeEnd) {
                            return false;
                        }
                        if (statement instanceof IASTPreprocessorIfStatement) {
                            IASTPreprocessorIfStatement ifStmt = (IASTPreprocessorIfStatement)statement;
                            inactiveCodeStack.push(inInactiveCode);
                            if (!ifStmt.taken() && !inInactiveCode) {
                                inactiveCodeStart = nodeEnd;
                                inInactiveCode = true;
                            }
                        } else if (statement instanceof IASTPreprocessorIfdefStatement) {
                            IASTPreprocessorIfdefStatement ifdefStmt = (IASTPreprocessorIfdefStatement)statement;
                            inactiveCodeStack.push(inInactiveCode);
                            if (!ifdefStmt.taken() && !inInactiveCode) {
                                inactiveCodeStart = nodeEnd;
                                inInactiveCode = true;
                            }
                        } else if (statement instanceof IASTPreprocessorIfndefStatement) {
                            IASTPreprocessorIfndefStatement ifndefStmt = (IASTPreprocessorIfndefStatement)statement;
                            inactiveCodeStack.push(inInactiveCode);
                            if (!ifndefStmt.taken() && !inInactiveCode) {
                                inactiveCodeStart = nodeEnd;
                                inInactiveCode = true;
                            }
                        } else if (statement instanceof IASTPreprocessorElseStatement) {
                            IASTPreprocessorElseStatement elseStmt = (IASTPreprocessorElseStatement)statement;
                            if (!elseStmt.taken() && !inInactiveCode) {
                                inactiveCodeStart = nodeEnd;
                                inInactiveCode = true;
                            } else if (elseStmt.taken() && inInactiveCode) {
                                inactiveCodeEnd = nodeOffset;
                                if (inactiveCodeStart <= offset && offset < inactiveCodeEnd) {
                                    return true;
                                }
                                inInactiveCode = false;
                            }
                        } else if (statement instanceof IASTPreprocessorElifStatement) {
                            IASTPreprocessorElifStatement elifStmt = (IASTPreprocessorElifStatement)statement;
                            if (!elifStmt.taken() && !inInactiveCode) {
                                inactiveCodeStart = nodeEnd;
                                inInactiveCode = true;
                            } else if (elifStmt.taken() && inInactiveCode) {
                                inactiveCodeEnd = nodeOffset;
                                if (inactiveCodeStart <= offset && offset < inactiveCodeEnd) {
                                    return true;
                                }
                                inInactiveCode = false;
                            }
                        } else if (statement instanceof IASTPreprocessorEndifStatement) {
                            boolean wasInInactiveCode;
                            block28: {
                                wasInInactiveCode = (Boolean)inactiveCodeStack.pop();
                                if (!inInactiveCode || wasInInactiveCode) break block28;
                                inactiveCodeEnd = nodeOffset;
                                if (inactiveCodeStart > offset || offset >= inactiveCodeEnd) break block28;
                                return true;
                            }
                            try {
                                inInactiveCode = wasInInactiveCode;
                            }
                            catch (EmptyStackException emptyStackException) {
                                // empty catch block
                            }
                        }
                    }
                    ++n2;
                }
                return false;
            }

            private boolean insideComment(IASTTranslationUnit ast, int offset) {
                IASTComment[] comments;
                IASTComment[] iASTCommentArray = comments = ast.getComments();
                int n = comments.length;
                int n2 = 0;
                while (n2 < n) {
                    IASTFileLocation location;
                    IASTComment comment = iASTCommentArray[n2];
                    if (comment.isPartOfTranslationUnitFile() && (location = comment.getFileLocation()) != null && location.getNodeOffset() <= offset && offset < location.getNodeOffset() + location.getNodeLength()) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        job.setPriority(20);
        job.setSystem(true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException exc) {
            job.cancel();
            return "";
        }
        if (!job.getResult().isOK()) {
            return null;
        }
        if (expressionPosition.getLength() > 0) {
            try {
                ITypedRegion[] partitions;
                StringBuilder result = new StringBuilder();
                ITypedRegion[] iTypedRegionArray = partitions = TextUtilities.computePartitioning((IDocument)document, (String)"___c_partitioning", (int)expressionPosition.offset, (int)expressionPosition.length, (boolean)false);
                int n = partitions.length;
                int n2 = 0;
                while (n2 < n) {
                    ITypedRegion partition = iTypedRegionArray[n2];
                    if ("__dftl_partition_content_type".equals(partition.getType()) || "__c_character".equals(partition.getType()) || "__c_string".equals(partition.getType())) {
                        result.append(document.get(partition.getOffset(), partition.getLength()));
                    } else {
                        result.append(' ');
                    }
                    ++n2;
                }
                String text = result.toString().replaceAll("(\\r\\n|\\n|\t| )+", " ").trim();
                return text;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return "";
    }

    protected IAdaptable getSelectionAdaptable() {
        return DebugUITools.getDebugContext();
    }

    protected final IEditorPart getEditor() {
        return this.fEditor;
    }

    private static void appendVariable(StringBuilder buffer, String expression, String value) throws DebugException {
        if (value.length() > 100) {
            value = String.valueOf(value.substring(0, 100)) + " ...";
        }
        buffer.append("<p>");
        buffer.append("<pre>").append(expression).append("</pre>");
        buffer.append(" = ");
        buffer.append("<b><pre>").append(value).append("</pre></b>");
        buffer.append("</p>");
    }

    private static String makeHTMLSafe(String string) {
        StringBuilder buffer = new StringBuilder(string.length());
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            switch (ch) {
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    private static class ExpressionChecker
    extends ASTVisitor {
        private boolean fValid;

        private ExpressionChecker() {
            this.shouldVisitExpressions = true;
        }

        private boolean check(IASTNode node) {
            this.fValid = true;
            node.accept((ASTVisitor)this);
            return this.fValid;
        }

        public int visit(IASTExpression expression) {
            if (expression instanceof IASTFunctionCallExpression) {
                this.fValid = false;
            } else if (expression instanceof IASTUnaryExpression) {
                IASTUnaryExpression unaryExpression = (IASTUnaryExpression)expression;
                switch (unaryExpression.getOperator()) {
                    case 0: 
                    case 1: 
                    case 9: 
                    case 10: {
                        this.fValid = false;
                    }
                }
            } else if (expression instanceof IASTBinaryExpression) {
                IASTBinaryExpression binaryExpression = (IASTBinaryExpression)expression;
                switch (binaryExpression.getOperator()) {
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: {
                        this.fValid = false;
                    }
                }
            } else if (expression instanceof ICPPASTNewExpression) {
                this.fValid = false;
            } else if (expression instanceof ICPPASTDeleteExpression) {
                this.fValid = false;
            } else if (expression instanceof IGNUASTCompoundStatementExpression) {
                this.fValid = false;
            }
            if (!this.fValid) {
                return 2;
            }
            return 3;
        }
    }
}

