/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.lookup;

import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.ImportBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemPackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.TThisBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;

public class OTClassScope
extends ClassScope {
    private CompilationUnitScope roleUnitImportScope;
    private CompilationUnitScope baseImportScope;

    public static OTClassScope createTopLevelOTClassScope(CompilationUnitScope unitScope, TypeDeclaration otType) {
        if (otType.isRole()) {
            return new OTClassScope(otType.enclosingType.scope, unitScope, otType);
        }
        return new OTClassScope(unitScope, null, otType);
    }

    public static OTClassScope createMemberOTClassScope(ClassScope parent, TypeDeclaration otType) {
        return new OTClassScope(parent, null, otType);
    }

    private OTClassScope(Scope parent, CompilationUnitScope roleUnitScope, TypeDeclaration otType) {
        super(parent, otType);
        this.roleUnitImportScope = roleUnitScope;
        if (this.roleUnitImportScope != null) {
            this.roleUnitImportScope.recordTypeReference(parent.enclosingReceiverType());
        }
    }

    @Override
    protected SourceTypeBinding buildType(SourceTypeBinding enclosingType, PackageBinding packageBinding, AccessRestriction accessRestriction) {
        ReferenceBinding[] newMembers;
        if (!this.referenceContext.isRole()) {
            return super.buildType(enclosingType, packageBinding, accessRestriction);
        }
        if (this.roleUnitImportScope != null) {
            assert (enclosingType == null);
            enclosingType = this.parent.referenceType().binding;
        }
        SourceTypeBinding type = super.buildType(enclosingType, packageBinding, accessRestriction);
        int size = 0;
        if (enclosingType.memberTypes == null) {
            newMembers = new ReferenceBinding[1];
        } else {
            size = enclosingType.memberTypes.length;
            newMembers = new ReferenceBinding[size + 1];
            System.arraycopy(enclosingType.memberTypes, 0, newMembers, 0, size);
        }
        newMembers[size] = type;
        enclosingType.setMemberTypes(newMembers);
        return type;
    }

    @Override
    protected void checkRoleFileImports() {
        super.checkRoleFileImports();
        CompilationUnitScope importScope = this.roleUnitImportScope;
        if (importScope != null && importScope.imports == null) {
            importScope.checkAndSetImports();
        }
    }

    protected Binding getTypeOrPackageInParent(char[] compoundName, int flags, boolean needResolve) {
        Binding foundInImports;
        Binding foundInParent = this.parent.getTypeOrPackage(compoundName, flags, needResolve);
        if (this.roleUnitImportScope != null && (foundInImports = this.roleUnitImportScope.getTypeOrPackage(compoundName, flags, needResolve)) != null && foundInImports.isValidBinding()) {
            if (foundInParent != null && foundInParent.isValidBinding() && foundInImports != foundInParent) {
                switch (foundInParent.kind()) {
                    case 16: {
                        return new ProblemPackageBinding(compoundName, 3);
                    }
                    case 4: {
                        return this.problemTypeBinding(compoundName, (TypeBinding)foundInParent, 3);
                    }
                }
            } else {
                return foundInImports;
            }
        }
        return foundInParent;
    }

    @Override
    public TypeBinding getType(char[][] compoundName, int typeNameLength) {
        TypeBinding foundInImports;
        TypeBinding foundHere = super.getType(compoundName, typeNameLength);
        if (this.roleUnitImportScope != null && (foundInImports = this.roleUnitImportScope.getType(compoundName, typeNameLength)).isValidBinding()) {
            if (foundHere.isValidBinding() && TypeBinding.notEquals(foundInImports, foundHere)) {
                return this.problemTypeBinding(compoundName, foundHere, 3);
            }
            return foundInImports;
        }
        return this.maybeWrap(foundHere);
    }

    @Override
    public TypeBinding getType(char[] token) {
        return this.getType(token, null);
    }

    @Override
    public TypeBinding getType(char[] token, PackageBinding packageBinding) {
        TypeBinding foundHere = packageBinding != null ? super.getType(token, packageBinding) : super.getType(token);
        TypeBinding foundInImports = this.findImportedType(token, packageBinding, foundHere);
        if (foundInImports != null) {
            return foundInImports;
        }
        return this.maybeWrap(foundHere);
    }

    private TypeBinding problemTypeBinding(char[][] compoundName, TypeBinding problem, int reason) {
        if (problem instanceof ReferenceBinding) {
            return new ProblemReferenceBinding(compoundName, (ReferenceBinding)problem, 3);
        }
        return null;
    }

    private TypeBinding problemTypeBinding(char[] compoundName, TypeBinding problem, int reason) {
        if (problem instanceof ReferenceBinding) {
            return new ProblemReferenceBinding(compoundName, (ReferenceBinding)problem, 3, true);
        }
        return null;
    }

    public TypeBinding findImportedType(char[] token, PackageBinding packageBinding, TypeBinding foundHere) {
        TypeBinding foundInImports;
        if (this.roleUnitImportScope != null && (foundInImports = this.roleUnitImportScope.getType(token, packageBinding)).isValidBinding()) {
            if (foundHere != null && foundHere.isValidBinding() && TypeBinding.notEquals(foundInImports, foundHere)) {
                return this.problemTypeBinding(token, foundHere, 3);
            }
            return foundInImports;
        }
        return null;
    }

    private TypeBinding maybeWrap(TypeBinding foundHere) {
        if (foundHere.isValidBinding() && foundHere instanceof MemberTypeBinding && !TSuperHelper.isMarkerInterface(foundHere)) {
            ReferenceBinding foundHereRef = (ReferenceBinding)foundHere;
            ReferenceBinding site = this.enclosingSourceType();
            ReferenceBinding foundEnclosing = foundHereRef.enclosingType();
            while (site != null && site.isTeam()) {
                ReferenceBinding currentClass = site;
                while (currentClass != null) {
                    if (TypeBinding.equalsEquals(site, foundEnclosing)) {
                        TThisBinding tthis = site.getTeamModel().getTThis();
                        return tthis.getRoleTypeBinding(foundHereRef, 0);
                    }
                    currentClass = currentClass.enclosingType();
                }
                site = site.superclass();
            }
        }
        return foundHere;
    }

    @Override
    public CompilationUnitDeclaration referenceCompilationUnit() {
        CompilationUnitDeclaration result;
        if (this.referenceContext.isRole() && !this.referenceContext.isPurelyCopied && (result = this.referenceContext.compilationUnit) != null) {
            return result;
        }
        if (this.parent != null) {
            return this.parent.referenceCompilationUnit();
        }
        return super.referenceCompilationUnit();
    }

    public void checkAndSetBaseImports(LookupEnvironment env, ImportReference[] references, ImportBinding[] resolvedBaseImports) {
        ImportReference currentPackage = this.referenceCompilationUnit().currentPackage;
        if (currentPackage != null && currentPackage.isTeam()) {
            ImportReference[] importReferenceArray = references;
            int n = references.length;
            int n2 = 0;
            while (n2 < n) {
                ImportReference reference = importReferenceArray[n2];
                if (reference != null) {
                    this.problemReporter().baseImportInRoleFile(reference);
                }
                ++n2;
            }
            return;
        }
        CompilationUnitDeclaration cud = new CompilationUnitDeclaration(this.problemReporter(), this.referenceContext.compilationResult, 0);
        cud.currentPackage = currentPackage;
        this.baseImportScope = new CompilationUnitScope(cud, env);
        this.baseImportScope.imports = resolvedBaseImports;
        this.baseImportScope.fPackage = this.compilationUnitScope().fPackage;
        this.baseImportScope.topLevelTypes = new SourceTypeBinding[0];
    }

    public CompilationUnitScope getBaseImportScope(Scope originalScope) {
        if (this.baseImportScope != null) {
            this.baseImportScope.originalScope = originalScope;
        }
        return this.baseImportScope;
    }

    public void faultInRoleFileImports() {
        if (this.roleUnitImportScope != null) {
            this.roleUnitImportScope.faultInImports();
        }
    }

    public ImportBinding[] getRoleUnitImports() {
        if (this.roleUnitImportScope == null) {
            return null;
        }
        return this.roleUnitImportScope.imports;
    }

    public void checkUnusedImports() {
        CompilationUnitScope scope = this.baseImportScope;
        if (scope != null && scope.imports != null) {
            int i = 0;
            int max = scope.imports.length;
            while (i < max) {
                ImportBinding importBinding = scope.imports[i];
                ImportReference importReference = importBinding.reference;
                if (importReference != null && (importReference.bits & 2) == 0) {
                    scope.problemReporter().unusedImport(importReference);
                }
                ++i;
            }
        }
    }

    @Override
    public boolean cuIgnoreFurtherInvestigation() {
        CompilationUnitDeclaration result;
        if (this.referenceContext.isRole() && (result = this.referenceContext.compilationUnit) != null && result.ignoreFurtherInvestigation) {
            return true;
        }
        if (this.parent != null) {
            if (this.parent.kind == 3) {
                return ((ClassScope)this.parent).cuIgnoreFurtherInvestigation();
            }
            return ((CompilationUnitScope)this.parent).referenceContext.ignoreFurtherInvestigation;
        }
        return false;
    }

    public void recordBaseClassUse(ReferenceBinding baseclass) {
        if (this.baseImportScope != null && this.baseImportScope.imports != null) {
            ImportBinding[] importBindingArray = this.baseImportScope.imports;
            int n = this.baseImportScope.imports.length;
            int n2 = 0;
            while (n2 < n) {
                ImportBinding importBinding = importBindingArray[n2];
                if (importBinding.isBase && importBinding.resolvedImport == baseclass) {
                    importBinding.reference.bits |= 2;
                }
                ++n2;
            }
        }
    }
}

