/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.widgets.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jwt.transformations.api.io.ContentChangeListener;
import org.eclipse.jwt.transformations.widgets.file.FilePickerPathView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFilePickerController<FileType> {
    private final ContentChangeListener pageListener;
    private final FileType defaultFile;
    private final FileFilter fileFilter;
    private FileType selectedFile;
    protected FilePickerPathView view;

    public AbstractFilePickerController(ContentChangeListener pageListener, FileFilter filter, FileType defaultFile) {
        this.pageListener = pageListener;
        this.fileFilter = filter;
        this.defaultFile = this.isValid(defaultFile, this.fileFilter) ? defaultFile : null;
    }

    protected abstract String fileToPath(FileType var1);

    protected abstract FileType pathToFile(String var1);

    protected abstract boolean isValid(FileType var1, FileFilter var2);

    protected abstract FileType doSelectFileInDialog(FileFilter var1);

    public abstract void openFile() throws CoreException;

    public void setView(FilePickerPathView abstractFilePicker) {
        this.view = abstractFilePicker;
        this.view.setPath(this.fileToPath(this.selectedFile));
    }

    public FileType getSelection() {
        return this.selectedFile;
    }

    public void resetSelection() {
        this.setSelection(this.defaultFile);
    }

    public void selectFileInDialog() {
        FileType newFile = this.doSelectFileInDialog(this.fileFilter);
        this.setSelection(newFile);
    }

    public void changePath(String newPath) {
        this.setSelection(newPath);
    }

    private void setSelection(String newPath) {
        FileType newFile = this.pathToFile(newPath);
        this.selectedFile = this.isValid(newFile, this.fileFilter) ? newFile : null;
        this.view.setPath(newPath);
        this.pageListener.contentChanged();
    }

    private void setSelection(FileType newFile) {
        if (this.isValid(newFile, this.fileFilter)) {
            this.selectedFile = newFile;
            this.view.setPath(this.fileToPath(this.selectedFile));
            this.pageListener.contentChanged();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FileFilter {
        private Collection<String> validExtensions = new ArrayList<String>();
        private boolean mustExist;

        public FileFilter(Collection<String> validExtensions, boolean mustExist) {
            this.validExtensions.addAll(validExtensions);
            this.mustExist = mustExist;
        }

        public FileFilter(String[] validExtensions, boolean mustExist) {
            this(Arrays.asList(validExtensions), mustExist);
        }

        public FileFilter() {
            this(new String[0], false);
        }

        public Collection<String> getValidExtensions() {
            return this.validExtensions;
        }

        public boolean mustExist() {
            return this.mustExist;
        }
    }
}

