/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.m2m.internal.qvt.oml.common.CommonPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.Messages;
import org.eclipse.m2m.internal.qvt.oml.common.launch.BaseProcess;
import org.eclipse.osgi.util.NLS;

public class ShallowProcess
extends BaseProcess {
    private final ILaunch myLaunch;
    private BaseProcess.IRunnable myRunnable;

    public ShallowProcess(ILaunch launch, BaseProcess.IRunnable r) {
        this.myLaunch = launch;
        this.myRunnable = r;
    }

    public void run() throws Exception {
        this.run(null);
    }

    public void run(IDebugTarget debugTarget) throws Exception {
        this.myLaunch.addProcess((IProcess)this);
        try {
            if (debugTarget != null) {
                this.myLaunch.addDebugTarget(debugTarget);
            }
            this.myRunnable.run();
        }
        catch (Throwable throwable) {
            this.myRunnable = null;
            if (DebugPlugin.getDefault() != null) {
                DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
            }
            throw throwable;
        }
        this.myRunnable = null;
        if (DebugPlugin.getDefault() != null) {
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)this, 8)});
        }
    }

    public String getLabel() {
        String transformationURI = null;
        ILaunchConfiguration configuration = this.myLaunch.getLaunchConfiguration();
        if (configuration != null) {
            try {
                transformationURI = configuration.getAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", null);
            }
            catch (CoreException e) {
                CommonPlugin.log(e.getStatus());
            }
        }
        return transformationURI != null ? NLS.bind((String)Messages.ShallowProcess_LabelTransform, transformationURI) : Messages.ShallowProcess_Label;
    }

    public ILaunch getLaunch() {
        return this.myLaunch;
    }

    public void setAttribute(String key, String value) {
    }

    public String getAttribute(String key) {
        return null;
    }

    public int getExitValue() throws DebugException {
        if (!this.isTerminated()) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.m2m.qvt.oml.common", 1, Messages.ShallowProcess_InvalidState, null));
        }
        return 0;
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.myRunnable == null;
    }

    public void terminate() throws DebugException {
    }
}

