/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.parser.internal.oql.compiler.ArrayIndexExpression;
import org.eclipse.mat.parser.internal.oql.compiler.Attribute;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.FieldDescriptor;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.MessageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PathExpression
extends Expression {
    private List<Object> attributes;

    public PathExpression(List<Object> attributes) {
        this.attributes = attributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object compute(EvaluationContext ctx) throws SnapshotException {
        try {
            Object current = null;
            int index = 0;
            Object firstItem = this.attributes.get(0);
            if (firstItem instanceof Attribute) {
                Attribute firstAttribute = (Attribute)firstItem;
                Object object = current = !firstAttribute.isNative() ? ctx.getAlias(firstAttribute.getName()) : null;
                if (current != null || !firstAttribute.isNative() && ctx.isAlias(firstAttribute.getName())) {
                    ++index;
                }
            }
            if (index == 0) {
                current = ctx.getSubject();
            }
            while (index < this.attributes.size()) {
                if (current == null) return current;
                List<?> element = this.attributes.get(index);
                if (element != null && element.getClass().isArray()) {
                    element = PathExpression.asList(element);
                }
                if (element instanceof Attribute) {
                    Attribute attribute = (Attribute)((Object)element);
                    if (attribute.isNative() || !(current instanceof IObject)) {
                        if (current.getClass().isArray()) {
                            if (!"length".equals(attribute.getName())) throw new SnapshotException(MessageUtil.format((String)Messages.PathExpression_Error_ArrayHasNoProperty, (Object[])new Object[]{current.getClass().getComponentType().getName(), attribute.name}));
                            current = Array.getLength(current);
                        } else {
                            PropertyDescriptor[] descriptors;
                            boolean didFindProperty = false;
                            BeanInfo info = Introspector.getBeanInfo(current.getClass());
                            PropertyDescriptor[] propertyDescriptorArray = descriptors = info.getPropertyDescriptors();
                            int n = descriptors.length;
                            int n2 = 0;
                            while (n2 < n) {
                                PropertyDescriptor descriptor = propertyDescriptorArray[n2];
                                if (attribute.getName().equals(descriptor.getName())) {
                                    current = descriptor.getReadMethod().invoke(current, null);
                                    didFindProperty = true;
                                    break;
                                }
                                ++n2;
                            }
                            if (!didFindProperty) {
                                throw new SnapshotException(MessageUtil.format((String)Messages.PathExpression_Error_TypeHasNoProperty, (Object[])new Object[]{current.getClass().getName(), attribute.name}));
                            }
                        }
                    } else {
                        IObject c = (IObject)current;
                        boolean found = false;
                        IClass cls = c.getClazz();
                        block4: while (cls != null) {
                            for (FieldDescriptor fd : cls.getFieldDescriptors()) {
                                if (!fd.getName().equals(attribute.getName())) continue;
                                found = true;
                                break block4;
                            }
                            cls = cls.getSuperClass();
                        }
                        if (found) {
                            current = c.resolveValue(attribute.getName());
                        } else {
                            if (current instanceof IClass) {
                                cls = (IClass)current;
                                block6: while (cls != null) {
                                    for (Field f : cls.getStaticFields()) {
                                        if (!f.getName().equals(attribute.getName())) continue;
                                        current = f.getValue();
                                        found = true;
                                        break block6;
                                    }
                                    cls = cls.getSuperClass();
                                }
                            }
                            if (!found) {
                                return null;
                            }
                        }
                    }
                } else {
                    if (!(element instanceof Expression)) throw new SnapshotException(MessageUtil.format((String)Messages.PathExpression_Error_UnknownElementInPath, (Object[])new Object[]{element}));
                    EvaluationContext methodCtx = new EvaluationContext(ctx);
                    methodCtx.setSubject(current);
                    current = ((Expression)((Object)element)).compute(methodCtx);
                }
                if (current == null) return current;
                ++index;
            }
            return current;
        }
        catch (Exception e) {
            throw SnapshotException.rethrow((Throwable)e);
        }
    }

    protected static List<?> asList(Object element) {
        int size = Array.getLength(element);
        ArrayWrapper answer = new ArrayWrapper(element);
        return answer;
    }

    @Override
    public boolean isContextDependent(EvaluationContext ctx) {
        Attribute firstAttribute;
        Object firstItem = this.attributes.get(0);
        if (firstItem instanceof Attribute ? !(firstAttribute = (Attribute)firstItem).isNative() && ctx.isAlias(firstAttribute.getName()) : firstItem instanceof Expression && ((Expression)firstItem).isContextDependent(ctx)) {
            return true;
        }
        int i = 1;
        while (i < this.attributes.size()) {
            Object nextItem = this.attributes.get(i);
            if (nextItem instanceof Expression && ((Expression)nextItem).isContextDependent(ctx)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        boolean first = true;
        for (Object element : this.attributes) {
            if (!first && !(element instanceof ArrayIndexExpression)) {
                buf.append(".");
            }
            first = false;
            buf.append(element);
        }
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayWrapper
    extends AbstractList<Object> {
        private final Object element;

        public ArrayWrapper(Object element) {
            this.element = element;
        }

        @Override
        public Object get(int i) {
            return Array.get(this.element, i);
        }

        @Override
        public int size() {
            return Array.getLength(this.element);
        }
    }
}

