/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FilterNatCombo
extends NatCombo {
    protected CheckboxTableViewer selectAllItemViewer;
    private String filterText;
    private List<ICheckStateListener> checkStateListener = new ArrayList<ICheckStateListener>();

    public FilterNatCombo(Composite parent, IStyle cellStyle, int style) {
        this(parent, cellStyle, 5, style, GUIHelper.getImage("down_2"));
    }

    public FilterNatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style) {
        this(parent, cellStyle, maxVisibleItems, style, GUIHelper.getImage("down_2"));
    }

    public FilterNatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, boolean showDropdownFilter) {
        this(parent, cellStyle, maxVisibleItems, style, GUIHelper.getImage("down_2"), showDropdownFilter);
    }

    public FilterNatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, Image iconImage) {
        this(parent, cellStyle, maxVisibleItems, style, iconImage, false);
    }

    public FilterNatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, Image iconImage, boolean showDropdownFilter) {
        super(parent, cellStyle, maxVisibleItems, style, iconImage, showDropdownFilter);
    }

    @Override
    protected void calculateBounds() {
        if (this.dropdownShell != null && !this.dropdownShell.isDisposed()) {
            Point size = this.getSize();
            int gridLineAdjustment = this.dropdownTable.getGridLineWidth() * 2;
            int listHeight = this.getVisibleItemCount() * this.dropdownTable.getItemHeight() + gridLineAdjustment;
            this.dropdownTable.getColumn(0).pack();
            this.selectAllItemViewer.getTable().getColumn(0).pack();
            int listWidth = Math.max(this.dropdownTable.computeSize((int)-1, (int)listHeight, (boolean)true).x, size.x);
            int viewerHeight = this.selectAllItemViewer.getTable().getItemHeight();
            listWidth = Math.max(this.selectAllItemViewer.getTable().computeSize((int)-1, (int)viewerHeight, (boolean)true).x, listWidth);
            Point textPosition = this.text.toDisplay(this.text.getLocation());
            int filterTextBoxHeight = this.showDropdownFilter ? this.filterBox.computeSize((int)-1, (int)-1).y : 0;
            this.dropdownShell.setBounds(textPosition.x, textPosition.y + this.text.getBounds().height, listWidth + this.dropdownTable.getGridLineWidth() * 2, listHeight + viewerHeight + filterTextBoxHeight);
            this.calculateColumnWidth();
        }
    }

    @Override
    protected void calculateColumnWidth() {
        super.calculateColumnWidth();
        this.selectAllItemViewer.getTable().getColumn(0).setWidth(this.dropdownTable.getColumn(0).getWidth());
    }

    @Override
    protected void createDropdownControl(int style) {
        super.createDropdownControl(style);
        int dropdownListStyle = style | 0x10 | HorizontalAlignmentEnum.getSWTStyle(this.cellStyle) | 0x10000;
        this.selectAllItemViewer = CheckboxTableViewer.newCheckList((Composite)this.dropdownShell, (int)dropdownListStyle);
        new TableColumn(this.selectAllItemViewer.getTable(), 0);
        this.selectAllItemViewer.getTable().addListener(11, new Listener(){

            public void handleEvent(Event event) {
                FilterNatCombo.this.calculateColumnWidth();
            }
        });
        FormData data = new FormData();
        data.top = this.showDropdownFilter ? new FormAttachment((Control)this.filterBox, 0, 1024) : new FormAttachment((Control)this.dropdownShell, 0, 128);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.selectAllItemViewer.getTable().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.selectAllItemViewer.getControl(), 0, 1024);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.dropdownTable.setLayoutData((Object)data);
        this.selectAllItemViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }
        });
        this.selectAllItemViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                return element.toString();
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        final String selectAllLabel = Messages.getString("FilterNatCombo.selectAll");
        ArrayList<String> input = new ArrayList<String>();
        input.add(selectAllLabel);
        this.selectAllItemViewer.setInput(input);
        this.selectAllItemViewer.getTable().setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        this.selectAllItemViewer.getTable().setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        this.selectAllItemViewer.getTable().setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        this.selectAllItemViewer.getTable().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FilterNatCombo.this.showDropdownControl();
            }
        });
        this.selectAllItemViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                FilterNatCombo.this.selectAllItemViewer.setGrayed((Object)selectAllLabel, false);
                if (event.getChecked()) {
                    FilterNatCombo.this.dropdownTable.selectAll();
                } else {
                    FilterNatCombo.this.dropdownTable.deselectAll();
                }
                TableItem[] tableItemArray = FilterNatCombo.this.dropdownTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    tableItem.setChecked(FilterNatCombo.this.dropdownTable.isSelected(FilterNatCombo.this.itemList.indexOf(tableItem.getText())));
                    ++n2;
                }
                for (String item : FilterNatCombo.this.itemList) {
                    FilterNatCombo.this.selectionStateMap.put(item, event.getChecked());
                }
                FilterNatCombo.this.updateTextControl(!FilterNatCombo.this.multiselect);
            }
        });
        for (ICheckStateListener l : this.checkStateListener) {
            this.selectAllItemViewer.addCheckStateListener(l);
        }
        this.selectAllItemViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return FilterNatCombo.this.dropdownTable.getSelectionCount() != FilterNatCombo.this.dropdownTable.getItemCount();
            }

            public boolean isChecked(Object element) {
                return FilterNatCombo.this.dropdownTable.getSelectionCount() != 0;
            }
        });
        this.dropdownTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterNatCombo.this.selectAllItemViewer.refresh();
            }
        });
    }

    @Override
    protected void setDropdownSelection(String[] selection) {
        super.setDropdownSelection(selection);
        if (this.selectAllItemViewer != null) {
            this.selectAllItemViewer.refresh();
        }
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        if (listener != null) {
            if (this.selectAllItemViewer != null) {
                this.selectAllItemViewer.addCheckStateListener(listener);
            }
            this.checkStateListener.add(listener);
        }
    }

    @Override
    protected void updateTextControl(boolean hideDropdown) {
        this.filterText = this.getTransformedTextForSelection();
        if (hideDropdown) {
            this.hideDropdownControl();
        }
    }

    @Override
    public int getSelectionIndex() {
        if (!this.getDropdownTable().isDisposed()) {
            return this.getDropdownTable().getSelectionIndex();
        }
        if (this.filterText != null && this.filterText.length() > 0) {
            return this.itemList.indexOf(this.filterText);
        }
        return -1;
    }

    @Override
    public String[] getSelection() {
        String[] result = this.getTransformedSelection();
        if (result == null || result.length == 0 && this.filterText != null) {
            result = this.getTextAsArray();
        }
        return result;
    }

    @Override
    public void setSelection(String[] items) {
        String textValue = "";
        if (items != null) {
            if (!this.getDropdownTable().isDisposed()) {
                this.setDropdownSelection(items);
                textValue = this.freeEdit && this.getDropdownTable().getSelectionCount() == 0 ? this.getTransformedText(items) : this.getTransformedTextForSelection();
            } else {
                textValue = this.getTransformedText(items);
            }
        }
        this.filterText = textValue;
    }

    @Override
    public void select(int index) {
        if (!this.getDropdownTable().isDisposed()) {
            this.getDropdownTable().select(index);
            this.filterText = this.getTransformedTextForSelection();
        } else if (index >= 0) {
            this.filterText = (String)this.itemList.get(index);
        }
    }

    @Override
    public void select(int[] indeces) {
        if (!this.getDropdownTable().isDisposed()) {
            this.getDropdownTable().select(indeces);
            this.filterText = this.getTransformedTextForSelection();
        } else {
            String[] selectedItems = new String[indeces.length];
            int i = 0;
            while (i < indeces.length) {
                if (indeces[i] >= 0) {
                    selectedItems[i] = (String)this.itemList.get(indeces[i]);
                }
                ++i;
            }
            this.filterText = this.getTransformedText(selectedItems);
        }
    }

    @Override
    protected String getTransformedText(String[] values) {
        String result = "";
        if (this.multiselect) {
            int i = 0;
            while (i < values.length) {
                String selection = values[i];
                result = String.valueOf(result) + selection;
                if (i + 1 < values.length) {
                    result = String.valueOf(result) + this.multiselectValueSeparator;
                }
                ++i;
            }
            if (values.length > 0) {
                result = String.valueOf(this.multiselectTextPrefix) + result + this.multiselectTextSuffix;
            }
        } else if (values.length > 0) {
            result = values[0];
        }
        return result;
    }

    @Override
    protected String[] getTextAsArray() {
        if (this.filterText != null && this.filterText.length() > 0) {
            String transform = this.filterText;
            int prefixLength = this.multiselectTextPrefix.length();
            int suffixLength = this.multiselectTextSuffix.length();
            transform = transform.substring(prefixLength, transform.length() - suffixLength);
            return transform.split(this.multiselectValueSeparator);
        }
        return new String[0];
    }
}

