/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.viewersearcher;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.services.viewersearch.impl.AbstractViewerSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramViewerSearcher
extends AbstractViewerSearcher {
    public Map<Object, Map<Object, Object>> getViewers(Collection<Object> modelElements, Collection<ModelSet> modelSets) {
        HashMap<Object, Map<Object, Object>> results = new HashMap<Object, Map<Object, Object>>();
        for (ModelSet modelSet : modelSets) {
            Map<EObject, Collection<EStructuralFeature.Setting>> references = this.crossReference(modelElements, modelSet);
            for (EObject semanticElement : references.keySet()) {
                for (EStructuralFeature.Setting setting : references.get(semanticElement)) {
                    if (!(setting.getEObject() instanceof View)) continue;
                    Map viewMappings = results.containsKey(modelSet) ? (Map)results.get(modelSet) : new HashMap();
                    viewMappings.put(setting.getEObject(), semanticElement);
                    results.put(modelSet, viewMappings);
                }
            }
        }
        return results;
    }

    private Map<EObject, Collection<EStructuralFeature.Setting>> crossReference(Collection<?> modelElements, ModelSet modelSet) {
        HashMap<EObject, Collection<EStructuralFeature.Setting>> result;
        ECrossReferenceAdapter xrefs = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)modelSet);
        if (xrefs == null) {
            result = EcoreUtil.UsageCrossReferencer.findAll(modelElements, (ResourceSet)modelSet);
        } else {
            result = new HashMap<EObject, Collection<EStructuralFeature.Setting>>();
            for (Object next : modelElements) {
                if (!(next instanceof EObject)) continue;
                EObject eObject = (EObject)next;
                result.put(eObject, xrefs.getInverseReferences(eObject));
            }
        }
        return result;
    }

    public List<Object> getViewersInCurrentModel(EObject element, EObject container, boolean pagesOnly, boolean openPagesOnly) {
        IPageManager pageManager;
        LinkedList<Object> objectsToSelect = new LinkedList<Object>();
        if (element == null && container == null) {
            return objectsToSelect;
        }
        try {
            pageManager = element == null ? (IPageManager)ServiceUtilsForEObject.getInstance().getServiceRegistry(container).getService(IPageManager.class) : (IPageManager)ServiceUtilsForEObject.getInstance().getServiceRegistry(element).getService(IPageManager.class);
        }
        catch (Exception ex) {
            return objectsToSelect;
        }
        try {
            block6: for (Object page : pageManager.allPages()) {
                EObject owner;
                if (openPagesOnly && !pageManager.isOpen(page) || !(page instanceof Diagram) || container != null && !(owner = DiagramUtils.getOwner((Diagram)((Diagram)page))).equals(container)) continue;
                if (element == null) {
                    objectsToSelect.add(page);
                    continue;
                }
                try {
                    TreeIterator allViews = ((Diagram)page).eAllContents();
                    while (allViews.hasNext()) {
                        EObject next = (EObject)allViews.next();
                        if (!(next instanceof View)) {
                            allViews.prune();
                            continue;
                        }
                        View nextView = (View)next;
                        if (!element.equals(nextView.getElement())) continue;
                        if (pagesOnly) {
                            objectsToSelect.add(page);
                            continue block6;
                        }
                        objectsToSelect.add(nextView);
                        continue block6;
                    }
                }
                catch (Exception e) {
                    return objectsToSelect;
                }
            }
        }
        catch (Exception e) {
            return objectsToSelect;
        }
        return objectsToSelect;
    }
}

