/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.profile.ui.wizards;

import java.io.File;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.php.profile.ui.PHPProfileUIMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ImportSessionWizardFirstPage
extends WizardPage {
    private Listener fieldModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean valid = ImportSessionWizardFirstPage.this.validatePage();
            ImportSessionWizardFirstPage.this.setPageComplete(valid);
        }
    };
    private Text fSourceField;
    private Button fSourceBtn;
    private String fSourceFile;

    public ImportSessionWizardFirstPage() {
        super(PHPProfileUIMessages.getString("ImportSessionWizardPage1.0"));
        this.setTitle(PHPProfileUIMessages.getString("ImportSessionWizardPage1.1"));
        this.setDescription(PHPProfileUIMessages.getString("ImportSessionWizardPage1.7"));
        this.setPageComplete(false);
    }

    public String getSourceFile() {
        return this.fSourceFile;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(PHPProfileUIMessages.getString("ImportSessionWizardPage1.2"));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.fSourceField = new Text(composite, 2048);
        this.fSourceField.addListener(24, this.fieldModifyListener);
        this.fSourceField.setLayoutData((Object)new GridData(768));
        this.fSourceBtn = new Button(composite, 0);
        this.fSourceBtn.setText(PHPProfileUIMessages.getString("ImportSessionWizardPage1.3"));
        this.fSourceBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String file;
                FileDialog dialog = new FileDialog(ImportSessionWizardFirstPage.this.fSourceBtn.getShell(), 4096);
                dialog.setFilterExtensions(new String[]{"*.xml", "*.*"});
                dialog.setText(PHPProfileUIMessages.getString("ImportSessionWizardPage1.4"));
                String dirName = new File(ImportSessionWizardFirstPage.this.fSourceField.getText().trim()).getParent();
                if (dirName != null && dirName.length() > 0 && new File(dirName).exists()) {
                    dialog.setFilterPath(new Path(dirName).toOSString());
                }
                if ((file = dialog.open()) != null) {
                    ImportSessionWizardFirstPage.this.fSourceField.setText(file);
                }
            }
        });
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.php.help.importing_profile_sessions");
    }

    protected boolean validatePage() {
        String sourceFile = this.fSourceField.getText().trim();
        if (sourceFile.length() == 0) {
            this.setMessage(null);
            this.setErrorMessage(PHPProfileUIMessages.getString("ImportSessionWizardPage1.5"));
            return false;
        }
        if (!new File(sourceFile).exists()) {
            this.setMessage(null);
            this.setErrorMessage(NLS.bind((String)PHPProfileUIMessages.getString("ImportSessionWizardPage1.6"), (Object)sourceFile));
            return false;
        }
        this.fSourceFile = sourceFile;
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

