/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.List;
import org.eclipse.sapphire.FileName;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.services.FileExtensionsService;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;
import org.eclipse.sapphire.services.ValueNormalizationService;

public final class FileNameNormalizationService
extends ValueNormalizationService {
    @Override
    public String normalize(String str) {
        String normalized = str;
        if (normalized != null) {
            int ch;
            normalized = normalized.trim();
            boolean hasDotChars = false;
            boolean hasSignificantChars = false;
            int i = 0;
            int n = normalized.length();
            while (!(i >= n || hasDotChars && hasSignificantChars)) {
                ch = normalized.charAt(i);
                if (ch == 46) {
                    hasDotChars = true;
                } else if (!Character.isWhitespace((char)ch)) {
                    hasSignificantChars = true;
                }
                ++i;
            }
            if (hasDotChars && hasSignificantChars) {
                while (normalized.endsWith(".") || normalized.endsWith(" ")) {
                    normalized = normalized.substring(0, normalized.length() - 1);
                }
            }
            if (hasSignificantChars) {
                List<String> extensions;
                FileExtensionsService fileExtensionsService;
                int segments = 0;
                String[] stringArray = normalized.split("\\.");
                int n2 = stringArray.length;
                ch = 0;
                while (ch < n2) {
                    String segment = stringArray[ch];
                    if (segment.trim().length() > 0 && ++segments > 1) break;
                    ++ch;
                }
                if (segments == 1 && (fileExtensionsService = this.context(Property.class).service(FileExtensionsService.class)) != null && !(extensions = fileExtensionsService.extensions()).isEmpty()) {
                    String extension = extensions.get(0);
                    normalized = String.valueOf(normalized) + "." + extension.toLowerCase();
                }
            }
        }
        return normalized;
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            ValueProperty property = context.find(ValueProperty.class);
            return property != null && property.isOfType(FileName.class);
        }
    }
}

