/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.query;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.EndOfLife;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.util.Range;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.internal.refresh.GMFHelper;
import org.eclipse.sirius.diagram.ui.tools.api.graphical.edit.styles.IBorderItemOffsets;

public class SequenceNodeQuery {
    private final Node node;

    public SequenceNodeQuery(Node node) {
        this.node = node;
    }

    public Range getVerticalRange() {
        EObject element = this.node.getElement();
        if (!(element instanceof DDiagramElement)) {
            return null;
        }
        Rectangle absoluteBounds = GMFHelper.getAbsoluteBounds((Node)this.node);
        int y = absoluteBounds.y;
        int height = absoluteBounds.height;
        if (this.node.getLayoutConstraint() instanceof Size) {
            Size size = (Size)this.node.getLayoutConstraint();
            height = size.getHeight();
        }
        if (element instanceof DNodeContainer && height == -1) {
            height = 0;
        }
        if (height == -1 && element instanceof DNode && ((DNode)element).getOwnedStyle() instanceof WorkspaceImage) {
            height = new DNodeQuery((DNode)((DNode)element)).getDefaultDimension().height;
        }
        Range result = new Range(y, y + height);
        if (this.isShifted()) {
            result = result.shifted(IBorderItemOffsets.DEFAULT_OFFSET.height);
        }
        return result;
    }

    private boolean isShifted() {
        return Lifeline.notationPredicate().apply((Object)this.node) || AbstractNodeEvent.notationPredicate().apply((Object)this.node) || EndOfLife.notationPredicate().apply((Object)this.node);
    }
}

