/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.actions.WorkspaceTraversalAction;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;
import org.eclipse.team.internal.ccvs.ui.wizards.AddWizard;

public class AddAction
extends WorkspaceTraversalAction {
    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        if (!this.promptForAddOfIgnored()) {
            return;
        }
        if (!this.promptForAdd()) {
            return;
        }
        AddOperation op = new AddOperation(this.getTargetPart(), this.getCVSResourceMappings());
        AddWizard.run(this.getShell(), op);
    }

    private boolean promptForAdd() {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)CVSUIMessages.AddAction_confirmAddingResourcesTitle, (String)CVSUIMessages.AddAction_confirmAddingResourcesMessage);
    }

    private boolean promptForAddOfIgnored() {
        IResource[] resources = this.getSelectedResourcesWithOverlap();
        boolean prompt = false;
        int i = 0;
        while (i < resources.length) {
            ICVSResource resource = this.getCVSResourceFor(resources[i]);
            try {
                if (resource.isIgnored()) {
                    prompt = true;
                    break;
                }
            }
            catch (CVSException e) {
                this.handle((Exception)((Object)e));
            }
            ++i;
        }
        if (prompt) {
            return MessageDialog.openQuestion((Shell)this.getShell(), (String)CVSUIMessages.AddAction_addIgnoredTitle, (String)CVSUIMessages.AddAction_addIgnoredQuestion);
        }
        return true;
    }

    @Override
    protected boolean isEnabledForManagedResources() {
        return false;
    }

    @Override
    protected boolean isEnabledForUnmanagedResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForIgnoredResources() {
        return true;
    }

    @Override
    protected boolean isEnabledForCVSResource(ICVSResource cvsResource) throws CVSException {
        IResource resource = cvsResource.getIResource();
        if (resource.isLinked()) {
            return false;
        }
        return super.isEnabledForCVSResource(cvsResource);
    }

    @Override
    public String getId() {
        return "org.eclipse.team.cvs.ui.add";
    }
}

