/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.pcap.ui.stream;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tracecompass.internal.tmf.pcap.core.analysis.StreamListAnalysis;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.TmfPacketStream;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.TmfPacketStreamBuilder;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.aspect.PcapDestinationAspect;
import org.eclipse.tracecompass.internal.tmf.pcap.core.event.aspect.PcapSourceAspect;
import org.eclipse.tracecompass.internal.tmf.pcap.core.protocol.TmfPcapProtocol;
import org.eclipse.tracecompass.internal.tmf.pcap.core.signal.TmfPacketStreamSelectedSignal;
import org.eclipse.tracecompass.internal.tmf.pcap.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.pcap.ui.stream.Messages;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterAndNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterContainsNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterNode;
import org.eclipse.tracecompass.tmf.core.filter.model.TmfFilterOrNode;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.tracecompass.tmf.ui.views.TmfView;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterManager;
import org.eclipse.tracecompass.tmf.ui.views.filter.FilterView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class StreamListView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.pcap.ui.view.stream.list";
    private static final String[] COLUMN_NAMES = new String[]{Messages.StreamListView_ID, Messages.StreamListView_EndpointA, Messages.StreamListView_EndpointB, Messages.StreamListView_TotalPackets, Messages.StreamListView_TotalBytes, Messages.StreamListView_PacketsAtoB, Messages.StreamListView_BytesAtoB, Messages.StreamListView_PacketsBtoA, Messages.StreamListView_BytesBtoA, Messages.StreamListView_StartTime, Messages.StreamListView_StopTime, Messages.StreamListView_Duration, Messages.StreamListView_BPSAtoB, Messages.StreamListView_BPSBtoA};
    private static final int[] COLUMN_SIZES = new int[]{75, 350, 350, 110, 110, 110, 110, 110, 110, 180, 180, 110, 110, 110};
    private static final String KEY_PROTOCOL = "$protocol$";
    private static final String KEY_STREAM = "$stream$";
    private static final String EMPTY_STRING = "";
    private static final long WAIT_TIME = 1000L;
    private @Nullable CTabFolder fTabFolder;
    private @Nullable Map<TmfPcapProtocol, Table> fTableMap;
    private @Nullable TmfPacketStream fCurrentStream;
    private @Nullable ITmfTrace fCurrentTrace;
    private volatile boolean fStopThread;

    public StreamListView() {
        super(ID);
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        this.fCurrentTrace = signal.getTrace();
        this.resetView();
        this.queryAnalysis();
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (this.fCurrentTrace == signal.getTrace()) {
            this.fCurrentTrace = null;
            this.resetView();
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (this.fCurrentTrace != signal.getTrace()) {
            this.fCurrentTrace = signal.getTrace();
            this.resetView();
            this.queryAnalysis();
        }
    }

    private void queryAnalysis() {
        Thread thread = new Thread(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                trace = StreamListView.access$0(StreamListView.this);
                if (trace == null) {
                    return;
                }
                analysis = (StreamListAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, StreamListAnalysis.class, (String)"org.eclipse.linuxtools.tmf.pcap.core.analysis.stream");
                if (analysis != null) ** GOTO lbl17
                return;
lbl-1000:
                // 1 sources

                {
                    StreamListView.access$2(StreamListView.this);
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        message = e.getMessage();
                        if (message == null) {
                            message = "";
                        }
                        Activator.logError(message, e);
                        return;
                    }
lbl17:
                    // 2 sources

                    ** while (!analysis.isFinished() && !StreamListView.access$1((StreamListView)StreamListView.this))
                }
lbl18:
                // 1 sources

                if (!StreamListView.access$1(StreamListView.this)) {
                    StreamListView.access$2(StreamListView.this);
                }
            }
        });
        this.fStopThread = false;
        thread.start();
    }

    private void resetView() {
        this.fStopThread = true;
        final Display display = Display.getDefault();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Map tableMap = StreamListView.this.fTableMap;
                if (tableMap == null) {
                    return;
                }
                for (Table table : tableMap.values()) {
                    if (table.isDisposed()) continue;
                    table.removeAll();
                }
            }
        });
    }

    private void updateUI() {
        final Display display = Display.getDefault();
        if (display == null || display.isDisposed()) {
            return;
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                ITmfTrace trace = StreamListView.this.fCurrentTrace;
                if (trace == null) {
                    return;
                }
                StreamListAnalysis analysis = (StreamListAnalysis)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, StreamListAnalysis.class, (String)"org.eclipse.linuxtools.tmf.pcap.core.analysis.stream");
                if (analysis == null) {
                    return;
                }
                Map tables = StreamListView.this.fTableMap;
                if (tables == null) {
                    return;
                }
                for (Map.Entry protocolEntry : tables.entrySet()) {
                    TmfPcapProtocol protocol = (TmfPcapProtocol)protocolEntry.getKey();
                    TmfPacketStreamBuilder builder = analysis.getBuilder(protocol);
                    Table table = (Table)protocolEntry.getValue();
                    if (builder == null || table.isDisposed()) continue;
                    for (TmfPacketStream stream : builder.getStreams()) {
                        TableItem item = stream.getID() < table.getItemCount() ? table.getItem(stream.getID()) : new TableItem(table, 0);
                        item.setText(0, String.valueOf(stream.getID()));
                        item.setText(1, stream.getFirstEndpoint().toString());
                        item.setText(2, stream.getSecondEndpoint().toString());
                        item.setText(3, String.valueOf(stream.getNbPackets()));
                        item.setText(4, String.valueOf(stream.getNbBytes()));
                        item.setText(5, String.valueOf(stream.getNbPacketsAtoB()));
                        item.setText(6, String.valueOf(stream.getNbBytesAtoB()));
                        item.setText(7, String.valueOf(stream.getNbPacketsBtoA()));
                        item.setText(8, String.valueOf(stream.getNbBytesBtoA()));
                        item.setText(9, stream.getStartTime().toString());
                        item.setText(10, stream.getStopTime().toString());
                        item.setText(11, String.format("%.3f", stream.getDuration()));
                        item.setText(12, String.format("%.3f", stream.getBPSAtoB()));
                        item.setText(13, String.format("%.3f", stream.getBPSBtoA()));
                        item.setData(StreamListView.KEY_STREAM, (Object)stream);
                    }
                }
            }
        });
    }

    public void createPartControl(@Nullable Composite parent) {
        final HashMap<TmfPcapProtocol, Table> tables = new HashMap<TmfPcapProtocol, Table>();
        this.fTableMap = tables;
        this.fCurrentTrace = TmfTraceManager.getInstance().getActiveTrace();
        this.fCurrentStream = null;
        this.fTabFolder = new CTabFolder(parent, 0);
        this.fTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(@Nullable SelectionEvent e) {
                if (e == null) {
                    return;
                }
                TmfPcapProtocol protocol = (TmfPcapProtocol)e.item.getData(StreamListView.KEY_PROTOCOL);
                Table table = (Table)tables.get(protocol);
                if (table != null) {
                    table.deselectAll();
                }
                StreamListView.this.fCurrentStream = null;
            }
        });
        TmfPcapProtocol[] tmfPcapProtocolArray = TmfPcapProtocol.values();
        int n = tmfPcapProtocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            TmfPcapProtocol protocol = tmfPcapProtocolArray[n2];
            if (protocol.supportsStream()) {
                CTabItem item = new CTabItem(this.fTabFolder, 0);
                item.setText(protocol.getName());
                item.setData(KEY_PROTOCOL, (Object)protocol);
                Table table = new Table((Composite)this.fTabFolder, 0);
                table.setHeaderVisible(true);
                table.setLinesVisible(true);
                int i = 0;
                while (i < COLUMN_NAMES.length || i < COLUMN_SIZES.length) {
                    TableColumn column = new TableColumn(table, 0);
                    column.setText(COLUMN_NAMES[i]);
                    column.setWidth(COLUMN_SIZES[i]);
                    ++i;
                }
                item.setControl((Control)table);
                table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(@Nullable SelectionEvent e) {
                        if (e == null) {
                            return;
                        }
                        StreamListView.this.fCurrentStream = (TmfPacketStream)e.item.getData(StreamListView.KEY_STREAM);
                    }
                });
                tables.put(protocol, table);
                Menu menu = new Menu((Control)table);
                MenuItem menuItem = new MenuItem(menu, 8);
                menuItem.setText(Messages.StreamListView_FollowStream);
                menuItem.addListener(13, new Listener(){

                    public void handleEvent(@Nullable Event event) {
                        TmfPacketStreamSelectedSignal signal = new TmfPacketStreamSelectedSignal((Object)this, 0, StreamListView.this.fCurrentStream);
                        TmfSignalManager.dispatchSignal((TmfSignal)signal);
                    }
                });
                menuItem = new MenuItem(menu, 8);
                menuItem.setText(Messages.StreamListView_Clear);
                menuItem.addListener(13, new Listener(){

                    public void handleEvent(@Nullable Event event) {
                        TmfPacketStreamSelectedSignal signal = new TmfPacketStreamSelectedSignal((Object)this, 0, null);
                        TmfSignalManager.dispatchSignal((TmfSignal)signal);
                    }
                });
                menuItem = new MenuItem(menu, 8);
                menuItem.setText(Messages.StreamListView_ExtractAsFilter);
                menuItem.addListener(13, new Listener(){

                    public void handleEvent(@Nullable Event event) {
                        ITmfFilterTreeNode filter = this.generateFilter();
                        this.updateFilters(filter);
                    }

                    private void updateFilters(@Nullable ITmfFilterTreeNode filter) {
                        if (filter == null) {
                            return;
                        }
                        ArrayList filters = Lists.newArrayList((Object[])FilterManager.getSavedFilters());
                        boolean newFilter = true;
                        for (ITmfFilterTreeNode savedFilter : filters) {
                            if (!savedFilter.toString(true).equals(filter.toString(true))) continue;
                            newFilter = false;
                            break;
                        }
                        if (newFilter) {
                            filters.add(filter);
                            FilterManager.setSavedFilters((ITmfFilterTreeNode[])filters.toArray(new ITmfFilterTreeNode[filters.size()]));
                        }
                        try {
                            IWorkbench wb = PlatformUI.getWorkbench();
                            IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                            IViewPart view = activePage.showView("org.eclipse.linuxtools.tmf.ui.views.filter");
                            FilterView filterView = (FilterView)view;
                            filterView.addFilter(filter);
                        }
                        catch (PartInitException e) {
                            TraceUtils.displayErrorMsg((String)Messages.StreamListView_ExtractAsFilter, (String)("Error opening view org.eclipse.linuxtools.tmf.ui.views.filter" + e.getMessage()));
                            Activator.logError("Error opening view org.eclipse.linuxtools.tmf.ui.views.filter", e);
                            return;
                        }
                    }

                    private @Nullable ITmfFilterTreeNode generateFilter() {
                        TmfPacketStream stream = StreamListView.this.fCurrentStream;
                        if (stream == null) {
                            return null;
                        }
                        String name = String.valueOf(Messages.StreamListView_FilterName_Stream) + ' ' + stream.getProtocol().getShortName() + ' ' + stream.getFirstEndpoint() + " <--> " + stream.getSecondEndpoint();
                        TmfFilterNode root = new TmfFilterNode(name);
                        TmfFilterAndNode and = new TmfFilterAndNode((ITmfFilterTreeNode)root);
                        TmfFilterContainsNode protocolFilter = new TmfFilterContainsNode((ITmfFilterTreeNode)and);
                        protocolFilter.setEventAspect((ITmfEventAspect)TmfBaseAspects.getContentsAspect().forField(stream.getProtocol().getName()));
                        protocolFilter.setTraceTypeId("BASE.ASPECT.ID");
                        protocolFilter.setValue(StreamListView.EMPTY_STRING);
                        TmfFilterOrNode or = new TmfFilterOrNode((ITmfFilterTreeNode)and);
                        TmfFilterAndNode andA = new TmfFilterAndNode((ITmfFilterTreeNode)or);
                        TmfFilterAndNode andB = new TmfFilterAndNode((ITmfFilterTreeNode)or);
                        TmfFilterContainsNode endpointAAndA = new TmfFilterContainsNode((ITmfFilterTreeNode)andA);
                        endpointAAndA.setEventAspect((ITmfEventAspect)PcapSourceAspect.INSTANCE);
                        endpointAAndA.setTraceTypeId("org.eclipse.linuxtools.tmf.pcap.core.pcaptrace");
                        endpointAAndA.setValue(stream.getFirstEndpoint());
                        TmfFilterContainsNode endpointBAndA = new TmfFilterContainsNode((ITmfFilterTreeNode)andA);
                        endpointBAndA.setEventAspect((ITmfEventAspect)PcapDestinationAspect.INSTANCE);
                        endpointBAndA.setTraceTypeId("org.eclipse.linuxtools.tmf.pcap.core.pcaptrace");
                        endpointBAndA.setValue(stream.getSecondEndpoint());
                        TmfFilterContainsNode endpointAAndB = new TmfFilterContainsNode((ITmfFilterTreeNode)andB);
                        endpointAAndB.setEventAspect((ITmfEventAspect)PcapSourceAspect.INSTANCE);
                        endpointAAndB.setTraceTypeId("org.eclipse.linuxtools.tmf.pcap.core.pcaptrace");
                        endpointAAndB.setValue(stream.getSecondEndpoint());
                        TmfFilterContainsNode endpointBAndB = new TmfFilterContainsNode((ITmfFilterTreeNode)andB);
                        endpointBAndB.setEventAspect((ITmfEventAspect)PcapDestinationAspect.INSTANCE);
                        endpointBAndB.setTraceTypeId("org.eclipse.linuxtools.tmf.pcap.core.pcaptrace");
                        endpointBAndB.setValue(stream.getFirstEndpoint());
                        return root;
                    }
                });
                table.setMenu(menu);
            }
            ++n2;
        }
        this.queryAnalysis();
    }

    public void setFocus() {
        CTabFolder tabFolder = this.fTabFolder;
        if (tabFolder != null && !tabFolder.isDisposed()) {
            tabFolder.setFocus();
        }
    }

    static /* synthetic */ boolean access$1(StreamListView streamListView) {
        return streamListView.fStopThread;
    }

    static /* synthetic */ void access$2(StreamListView streamListView) {
        streamListView.updateUI();
    }
}

