/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Abel Hegedus - initial API and implementation
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.common.base.Objects;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFilter;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.handlers.ShowPatternLocationHandler;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Abel Hegedus
 * @since 1.4
 */
@SuppressWarnings("all")
public class ShowMatcherLocationHandler extends ShowPatternLocationHandler {
  @Override
  public Object execute(final ExecutionEvent event) throws ExecutionException {
    ISelection _currentSelection = HandlerUtil.getCurrentSelection(event);
    final IStructuredSelection selection = ((IStructuredSelection) _currentSelection);
    Object _firstElement = selection.getFirstElement();
    final QueryResultTreeMatcher matcher = ((QueryResultTreeMatcher) _firstElement);
    IQuerySpecificationRegistryEntry _entry = matcher.getEntry();
    boolean _notEquals = (!Objects.equal(_entry, null));
    if (_notEquals) {
      IQuerySpecificationRegistryEntry _entry_1 = matcher.getEntry();
      this.showPatternLocation(event, _entry_1);
    } else {
      ViatraQueryMatcher _matcher = matcher.getMatcher();
      IQuerySpecification _specification = _matcher.getSpecification();
      final String fqn = _specification.getFullyQualifiedName();
      IQuerySpecificationRegistry _instance = QuerySpecificationRegistry.getInstance();
      final IRegistryViewFilter _function = new IRegistryViewFilter() {
        @Override
        public boolean isEntryRelevant(final IQuerySpecificationRegistryEntry entry) {
          String _fullyQualifiedName = entry.getFullyQualifiedName();
          final boolean fqnRelevant = Objects.equal(fqn, _fullyQualifiedName);
          return fqnRelevant;
        }
      };
      final IRegistryView view = _instance.createView(_function);
      Iterable<IQuerySpecificationRegistryEntry> _entries = view.getEntries();
      final Procedure1<IQuerySpecificationRegistryEntry> _function_1 = new Procedure1<IQuerySpecificationRegistryEntry>() {
        @Override
        public void apply(final IQuerySpecificationRegistryEntry it) {
          try {
            ShowMatcherLocationHandler.this.showPatternLocation(event, it);
          } catch (Throwable _e) {
            throw Exceptions.sneakyThrow(_e);
          }
        }
      };
      IterableExtensions.<IQuerySpecificationRegistryEntry>forEach(_entries, _function_1);
    }
    return null;
  }
}
