/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.jaxp.launching.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorInstall;
import org.eclipse.wst.xsl.jaxp.launching.IProcessorJar;
import org.eclipse.wst.xsl.jaxp.launching.ProcessorInstall;
import org.eclipse.wst.xsl.jaxp.launching.internal.ProcessorJar;
import org.eclipse.wst.xsl.launching.config.PreferenceUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessorPreferences {
    private String defaultProcessorId;
    private List<IProcessorInstall> processors = new ArrayList<IProcessorInstall>();

    public void setProcessors(List<IProcessorInstall> processors) {
        this.processors = processors;
    }

    public List<IProcessorInstall> getProcessors() {
        return this.processors;
    }

    public String getDefaultProcessorId() {
        return this.defaultProcessorId;
    }

    public void setDefaultProcessorId(String defaultProcessorId) {
        this.defaultProcessorId = defaultProcessorId;
    }

    public String getAsXML() throws ParserConfigurationException, IOException, TransformerException {
        Document doc = PreferenceUtil.getDocument();
        Element config = doc.createElement("processorSettings");
        doc.appendChild(config);
        if (this.defaultProcessorId != null) {
            config.setAttribute("defaultProcessor", this.defaultProcessorId);
        }
        for (IProcessorInstall install : this.processors) {
            if (install.isContributed()) continue;
            Element vmTypeElement = ProcessorPreferences.installAsElement(doc, install);
            config.appendChild(vmTypeElement);
        }
        return PreferenceUtil.serializeDocument((Document)doc);
    }

    public static ProcessorPreferences fromXML(InputStream inputStream) throws CoreException {
        ProcessorPreferences prefs = new ProcessorPreferences();
        Document doc = PreferenceUtil.getDocument((InputStream)inputStream);
        Element config = doc.getDocumentElement();
        prefs.setDefaultProcessorId(config.getAttribute("defaultProcessor"));
        ArrayList<IProcessorInstall> processors = new ArrayList<IProcessorInstall>();
        Element[] processorEls = PreferenceUtil.getChildElements((Element)config, (String)"processor");
        int i = 0;
        while (i < processorEls.length) {
            IProcessorInstall processor = ProcessorPreferences.elementAsInstall(processorEls[i]);
            processors.add(processor);
            ++i;
        }
        prefs.setProcessors(processors);
        return prefs;
    }

    private static IProcessorInstall elementAsInstall(Element parent) {
        String id = parent.getAttribute("id");
        String label = parent.getAttribute("label");
        String typeId = parent.getAttribute("type");
        String supports = parent.getAttribute("supports");
        String debuggerId = parent.getAttribute("debuggerId");
        IProcessorJar[] jars = null;
        Element[] jarsEls = PreferenceUtil.getChildElements((Element)parent, (String)"jars");
        if (jarsEls.length == 1) {
            jars = ProcessorPreferences.elementAsJars(jarsEls[0]);
        }
        ProcessorInstall install = new ProcessorInstall(id, label, typeId, jars, debuggerId, supports, false);
        return install;
    }

    private static Element installAsElement(Document doc, IProcessorInstall install) {
        Element element = doc.createElement("processor");
        element.setAttribute("id", install.getId());
        element.setAttribute("label", install.getName());
        element.setAttribute("type", install.getProcessorType().getId());
        element.setAttribute("supports", install.getSupports());
        element.setAttribute("debuggerId", install.getDebugger() != null ? install.getDebugger().getId() : null);
        element.appendChild(ProcessorPreferences.jarsAsElement(doc, install.getProcessorJars()));
        return element;
    }

    private static IProcessorJar[] elementAsJars(Element element) {
        Element[] jarEls = PreferenceUtil.getChildElements((Element)element, (String)"jar");
        ArrayList<ProcessorJar> jars = new ArrayList<ProcessorJar>(jarEls.length);
        Element[] elementArray = jarEls;
        int n = jarEls.length;
        int n2 = 0;
        while (n2 < n) {
            Element jarEl = elementArray[n2];
            Node node = jarEl.getFirstChild();
            if (node != null && node.getNodeType() == 3) {
                String path = ((Text)node).getNodeValue();
                jars.add(new ProcessorJar(Path.fromPortableString((String)path)));
            }
            ++n2;
        }
        return jars.toArray(new IProcessorJar[0]);
    }

    private static Element jarsAsElement(Document doc, IProcessorJar[] jars) {
        Element jarsEl = doc.createElement("jars");
        IProcessorJar[] iProcessorJarArray = jars;
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            IProcessorJar jar = iProcessorJarArray[n2];
            if (jar != null && jar.getPath() != null) {
                Element jarEl = doc.createElement("jar");
                Text text = doc.createTextNode(jar.getPath().toPortableString());
                jarEl.appendChild(text);
                jarsEl.appendChild(jarEl);
            }
            ++n2;
        }
        return jarsEl;
    }
}

