/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute;

import org.eclipse.acute.AcutePreferenceInitializer;
import org.eclipse.acute.AcutePreferencePage;
import org.eclipse.acute.DotnetVersionUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class AcutePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.acute";
    private static AcutePlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static AcutePlugin getDefault() {
        return plugin;
    }

    public static void logError(Throwable t) {
        AcutePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void logError(String message) {
        AcutePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, message));
    }

    public static String getDotnetCommand() {
        return AcutePlugin.getDotnetCommand(true);
    }

    public static String getDotnetCommand(boolean showErrors) {
        String path = plugin.getPreferenceStore().getString(AcutePreferenceInitializer.explicitDotnetPathPreference);
        if (path.isEmpty()) {
            if (showErrors) {
                AcutePlugin.openCommandErrorDialog("No `dotnet` Path Set", "There is no path to the `dotnet` command, please specify the correct path in the preferences.");
            }
        } else {
            String version = DotnetVersionUtil.getVersion(path);
            if (!DotnetVersionUtil.isValidVersionFormat(version)) {
                if (showErrors) {
                    AcutePlugin.openCommandErrorDialog("Invalid `dotnet` Path Set", "`dotnet --version` failed to return a version, please specify the correct command path in the preferences.");
                }
            } else if (!DotnetVersionUtil.isValidVersionNumber(version)) {
                if (showErrors) {
                    AcutePlugin.openCommandErrorDialog("Invalid `dotnet` Version", "`dotnet` version 2.0 or greater is required, please specify a command path to a new version of `dotnet` in the preferences.");
                }
            } else {
                return path;
            }
        }
        throw new IllegalStateException();
    }

    private static void openCommandErrorDialog(String title, String content) {
        Display.getDefault().asyncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            int dialogResponse = MessageDialog.open((int)5, (Shell)shell, (String)title, (String)content, (int)0, (String[])new String[]{"Open Preferences", "Cancel"});
            if (dialogResponse == 0) {
                PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)AcutePreferencePage.PAGE_ID, (String[])new String[]{AcutePreferencePage.PAGE_ID}, null);
                preferenceDialog.setBlockOnOpen(false);
                preferenceDialog.open();
            }
        });
    }
}

