/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnetexport;

import java.io.File;
import java.net.URL;
import org.eclipse.acute.ProjectFileAccessor;
import org.eclipse.acute.dotnetexport.DotnetExportAccessor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DotnetExportWizardPage
extends WizardPage {
    private Path projectPath;
    private boolean isSCD = false;
    private String runtime;
    private boolean isExportLocDefault = true;
    private File exportLocation;
    private String configuration = "Debug";
    private String version = "";
    private String[] targetFrameworks;
    private String defaultRuntime;
    private Button projectBrowseButton;
    private Label projectLocationLabel;
    private Text projectLocationText;
    private ControlDecoration projectLocationControlDecoration;
    private ListViewer frameworkViewer;
    private ControlDecoration frameworkControlDecoration;
    private Text runtimeText;
    private Label runtimeLabel;
    private ControlDecoration runtimeControlDecoration;
    private Button exportBrowseButton;
    private Label exportLocationLabel;
    private Text exportLocationText;
    private ControlDecoration exportLocationControlDecoration;
    private ControlDecoration configControlDecoration;

    public boolean isSCD() {
        return this.isSCD;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public File getExportLocation() {
        return this.exportLocation;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getTargetFramework() {
        IStructuredSelection selection = (IStructuredSelection)this.frameworkViewer.getSelection();
        if (selection.isEmpty()) {
            return "";
        }
        return (String)selection.getFirstElement();
    }

    public String getVersion() {
        return this.version;
    }

    public Path getProjectFilePath() {
        return this.projectPath;
    }

    protected DotnetExportWizardPage(IFile projectFile) {
        super(DotnetExportWizardPage.class.getName());
        this.setTitle("Export a .NET Core Project");
        this.setDescription("Export a .NET Core project, using the `dotnet publish` command");
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        URL url = bundle.getEntry("images/dotnet.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        this.setImageDescriptor(imageDescriptor);
        if (projectFile != null) {
            this.projectPath = new Path(projectFile.getRawLocation().toString());
        }
        this.targetFrameworks = ProjectFileAccessor.getTargetFrameworks((IPath)this.projectPath);
        this.defaultRuntime = DotnetExportAccessor.getDefaultRuntime();
    }

    public void createControl(Composite parent) {
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(3, false));
        Label projectLabel = new Label(container, 0);
        projectLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        projectLabel.setText("Project File:");
        this.projectLocationLabel = new Label(container, 0);
        this.projectLocationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.projectLocationLabel.setText("Location:");
        this.projectLocationText = new Text(container, 2048);
        this.projectLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.projectLocationText.addModifyListener(e -> this.updateProjectPath(this.projectLocationText.getText()));
        this.projectLocationControlDecoration = new ControlDecoration((Control)this.projectLocationText, 16512);
        this.projectLocationControlDecoration.setImage(errorImage);
        this.projectBrowseButton = new Button(container, 0);
        this.projectBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.projectBrowseButton.setText("Browse...");
        this.projectBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell());
            String path = dialog.open();
            if (path != null) {
                this.projectLocationText.setText(path);
            }
        }));
        Label frameworkLabel = new Label(container, 0);
        frameworkLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        frameworkLabel.setText("Framework:");
        List list = new List(container, 2560);
        GridData listBoxData = new GridData(4, 0x1000000, true, false, 1, 1);
        listBoxData.heightHint = 50;
        list.setLayoutData((Object)listBoxData);
        list.setEnabled(false);
        this.frameworkViewer = new ListViewer(list);
        this.frameworkViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.frameworkViewer.add((Object)"No frameworks available");
        this.frameworkControlDecoration = new ControlDecoration(this.frameworkViewer.getControl(), 16512);
        this.frameworkControlDecoration.setImage(errorImage);
        this.frameworkViewer.addSelectionChangedListener(e -> {
            this.setLocationIfDefault();
            this.setPageComplete(this.isPageComplete());
        });
        Button scdCheck = new Button(container, 32);
        scdCheck.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        scdCheck.setText("Self-Contained Deployment");
        scdCheck.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.updateDeployment(((Button)e.widget).getSelection());
            this.setPageComplete(this.isPageComplete());
        }));
        this.runtimeLabel = new Label(container, 0);
        this.runtimeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.runtimeLabel.setText("Runtime:");
        this.runtimeText = new Text(container, 0);
        this.runtimeText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.runtimeText.setEnabled(false);
        this.runtimeText.addModifyListener(e -> {
            this.runtime = this.runtimeText.getText();
            this.setLocationIfDefault();
            this.setPageComplete(this.isPageComplete());
        });
        this.runtimeControlDecoration = new ControlDecoration((Control)this.runtimeText, 16512);
        this.runtimeControlDecoration.setImage(errorImage);
        new Label(container, 0).setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        Button defaultLocationCheckbox = new Button(container, 32);
        defaultLocationCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        defaultLocationCheckbox.setText("Use Default Export Location");
        defaultLocationCheckbox.setSelection(true);
        defaultLocationCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateDefaultLocationState(((Button)e.widget).getSelection())));
        this.exportLocationLabel = new Label(container, 0);
        this.exportLocationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.exportLocationLabel.setText("Location:");
        this.exportLocationText = new Text(container, 2048);
        this.exportLocationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.exportLocationText.addModifyListener(e -> {
            this.exportLocation = new File(this.exportLocationText.getText());
            this.setPageComplete(this.isPageComplete());
        });
        this.exportLocationControlDecoration = new ControlDecoration((Control)this.exportLocationText, 16512);
        this.exportLocationControlDecoration.setImage(errorImage);
        this.exportBrowseButton = new Button(container, 0);
        this.exportBrowseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.exportBrowseButton.setText("Browse...");
        this.exportBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog dialog = new DirectoryDialog(this.exportBrowseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.exportLocation = new File(path);
                this.exportLocationText.setText(this.exportLocation.toString());
                this.setPageComplete(this.isPageComplete());
            }
        }));
        Label configLabel = new Label(container, 0);
        configLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        configLabel.setText("Configuration:");
        Label versionLabel = new Label(container, 0);
        versionLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        versionLabel.setText("Version Suffix:");
        Composite configComp = new Composite(container, 0);
        configComp.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        configComp.setLayout((Layout)new RowLayout());
        Listener configRadioListener = new Listener(){

            public void handleEvent(Event e) {
                DotnetExportWizardPage.this.configuration = ((Button)e.widget).getText();
                DotnetExportWizardPage.this.setLocationIfDefault();
            }
        };
        Button debugRadio = new Button(configComp, 16);
        debugRadio.setText("Debug");
        debugRadio.setSelection(true);
        debugRadio.addListener(13, configRadioListener);
        Button releaseRadio = new Button(configComp, 16);
        releaseRadio.setText("Release");
        releaseRadio.addListener(13, configRadioListener);
        Text versionText = new Text(container, 2048);
        versionText.setText(this.version);
        versionText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        versionText.addModifyListener(e -> {
            this.version = versionText.getText();
            this.setPageComplete(this.isPageComplete());
        });
        this.configControlDecoration = new ControlDecoration((Control)versionText, 16512);
        this.configControlDecoration.setImage(errorImage);
        this.configControlDecoration.setShowOnlyOnFocus(true);
        if (this.projectPath != null) {
            this.projectLocationText.setText(this.projectPath.toString());
        }
        this.updateDeployment(false);
        this.updateDefaultLocationState(true);
    }

    private void updateProjectPath(String location) {
        this.projectPath = new Path(location);
        this.frameworkViewer.getList().removeAll();
        if (this.isProjectFile(this.projectPath)) {
            this.frameworkViewer.getList().deselectAll();
            this.frameworkViewer.add((Object)"Loading frameworks");
            this.frameworkViewer.getList().setEnabled(false);
            this.targetFrameworks = ProjectFileAccessor.getTargetFrameworks((IPath)this.projectPath);
            this.frameworkViewer.getList().removeAll();
            if (this.targetFrameworks.length > 0) {
                this.frameworkViewer.add((Object[])this.targetFrameworks);
                this.frameworkViewer.getList().select(0);
                this.frameworkViewer.getList().setEnabled(true);
            } else {
                this.frameworkViewer.add((Object)"No frameworks available");
                this.frameworkViewer.getList().setEnabled(false);
            }
        } else {
            this.frameworkViewer.add((Object)"No frameworks available");
            this.frameworkViewer.getList().setEnabled(false);
        }
        this.setPageComplete(this.isPageComplete());
        this.setLocationIfDefault();
    }

    private void updateDeployment(boolean isSCD) {
        this.isSCD = isSCD;
        if (isSCD) {
            this.runtimeLabel.setEnabled(true);
            this.runtimeText.setEnabled(true);
        } else {
            this.runtimeLabel.setEnabled(false);
            this.runtimeText.setEnabled(false);
            this.runtime = this.defaultRuntime;
            this.runtimeText.setText(this.runtime);
        }
        this.setLocationIfDefault();
    }

    private void updateDefaultLocationState(Boolean isDefault) {
        this.isExportLocDefault = isDefault;
        if (this.isExportLocDefault) {
            this.exportLocationLabel.setEnabled(false);
            this.exportLocationText.setEnabled(false);
            this.exportBrowseButton.setEnabled(false);
        } else {
            this.exportLocationLabel.setEnabled(true);
            this.exportLocationText.setEnabled(true);
            this.exportBrowseButton.setEnabled(true);
        }
        this.setLocationIfDefault();
    }

    private void setLocationIfDefault() {
        if (!this.isExportLocDefault) {
            return;
        }
        String locationString = "";
        if (this.isProjectFile(this.projectPath)) {
            locationString = String.valueOf(this.projectPath.toFile().getParent().toString()) + "/bin/" + this.configuration + "/" + this.getTargetFramework() + "/";
            if (this.isSCD) {
                locationString = String.valueOf(locationString) + this.runtime + "/";
            }
        }
        this.exportLocation = new File(locationString);
        this.exportLocationText.setText(locationString);
    }

    private boolean isProjectFile(Path path) {
        if (path == null || path.isEmpty()) {
            return false;
        }
        if (!path.lastSegment().matches("(.*\\.csproj|project.json)")) {
            return false;
        }
        return path.toFile().isFile();
    }

    public boolean isPageComplete() {
        String runtimeError = "";
        String exportLocationError = "";
        String projectLocationError = "";
        String configError = "";
        String frameworkError = "";
        if (this.projectPath == null || this.projectPath.isEmpty()) {
            projectLocationError = "Please specify the project location";
        } else if (this.projectPath.toFile().isDirectory()) {
            projectLocationError = "Invalid project file: Is a directory";
        } else if (!this.projectPath.lastSegment().matches("(.*\\.csproj|project.json)")) {
            projectLocationError = "Invalid project file: Not a project file";
        } else if (!this.projectPath.toFile().isFile()) {
            projectLocationError = "Invalid project file: File does not exist";
        } else if (this.getTargetFramework().isEmpty()) {
            frameworkError = "Please specify a Framework";
        } else if (this.isSCD && (this.runtime == null || this.runtime.isEmpty())) {
            runtimeError = "Please specify a runtime";
        } else if (!this.version.matches("\\w*")) {
            configError = "Invalid version suffex";
        } else if (this.exportLocation == null || this.exportLocation.getPath().isEmpty()) {
            exportLocationError = "Please specify an export location";
        } else if (this.exportLocation.isFile()) {
            exportLocationError = "Invalid export location: it is an existing file";
        } else {
            File existingParent = this.exportLocation.getParentFile();
            while (existingParent != null && !existingParent.exists() && !existingParent.getPath().isEmpty()) {
                existingParent = existingParent.getParentFile();
            }
            if (existingParent == null || !this.exportLocation.exists() && !existingParent.canWrite()) {
                exportLocationError = "Unable to create such directory";
            } else if (this.exportLocation.exists() && !this.exportLocation.canWrite()) {
                exportLocationError = "Cannot write in this directory";
            }
        }
        String error = String.valueOf(runtimeError) + exportLocationError + configError + projectLocationError + frameworkError;
        this.projectLocationControlDecoration.hide();
        this.exportLocationControlDecoration.hide();
        this.runtimeControlDecoration.hide();
        this.configControlDecoration.hide();
        this.frameworkControlDecoration.hide();
        if (error.isEmpty()) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(error);
            if (!runtimeError.isEmpty()) {
                this.runtimeControlDecoration.show();
            } else if (!exportLocationError.isEmpty()) {
                this.exportLocationControlDecoration.show();
            } else if (!projectLocationError.isEmpty()) {
                this.projectLocationControlDecoration.show();
            } else if (!frameworkError.isEmpty()) {
                this.frameworkControlDecoration.show();
            } else {
                this.configControlDecoration.show();
            }
        }
        return error.isEmpty();
    }
}

