/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnetnew;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Set;
import org.eclipse.acute.AcutePlugin;
import org.eclipse.acute.AcutePreferenceInitializer;
import org.eclipse.acute.AcutePreferencePage;
import org.eclipse.acute.dotnetnew.DotnetNewAccessor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WorkingSetGroup;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DotnetNewWizardPage
extends WizardPage {
    private Set<IWorkingSet> workingSets;
    private File directory;
    private String projectName;
    private Boolean isDirectoryAndProjectLinked = true;
    private Text locationText;
    private Text projectNameText;
    private ListViewer templateViewer;
    private WorkingSetGroup workingSetsGroup;
    private Image linkImage;
    private Button linkButton;
    private ControlDecoration locationControlDecoration;
    private ControlDecoration projectNameControlDecoration;
    private ControlDecoration templateControlDecoration;
    private IPropertyChangeListener updateTemplatesListener;

    protected DotnetNewWizardPage() {
        super(DotnetNewWizardPage.class.getName());
        this.setTitle("Create a .NET Core Project");
        this.setDescription("Create a new .NET Core project, using the `dotnet new` command");
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        URL url = bundle.getEntry("images/dotnet.png");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        this.setImageDescriptor(imageDescriptor);
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public File getDirectory() {
        if (this.isDirectoryAndProjectLinked.booleanValue()) {
            return this.directory;
        }
        return new File(String.valueOf(this.directory.toString()) + "/" + this.projectName);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public @Nullable DotnetNewAccessor.Template getTemplate() {
        IStructuredSelection selection = (IStructuredSelection)this.templateViewer.getSelection();
        if (this.templateViewer.getList().isEnabled() && selection.isEmpty()) {
            return null;
        }
        return (DotnetNewAccessor.Template)selection.getFirstElement();
    }

    public IWorkingSet[] getWorkingSets() {
        return this.workingSetsGroup.getSelectedWorkingSets();
    }

    public void setWorkingSets(Set<IWorkingSet> workingSets) {
        this.workingSets = workingSets;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(4, false));
        Label locationLabel = new Label(container, 0);
        locationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        locationLabel.setText("Location");
        Image errorImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        this.locationText = new Text(container, 2048);
        this.locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.locationControlDecoration = new ControlDecoration((Control)this.locationText, 16512);
        this.locationControlDecoration.setImage(errorImage);
        this.locationControlDecoration.setShowOnlyOnFocus(true);
        this.locationText.addModifyListener(e -> {
            this.updateDirectory(this.locationText.getText());
            this.setPageComplete(this.isPageComplete());
        });
        Button browseButton = new Button(container, 0);
        browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        browseButton.setText("Browse...");
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            DirectoryDialog dialog = new DirectoryDialog(browseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.updateDirectory(path);
            }
            this.setPageComplete(this.isPageComplete());
        }));
        Composite linesAboveLink = new Composite(container, 0);
        GridData linesAboveLinkLayoutData = new GridData(4, 4);
        linesAboveLinkLayoutData.widthHint = 30;
        linesAboveLinkLayoutData.heightHint = 30;
        linesAboveLink.setLayoutData((Object)linesAboveLinkLayoutData);
        linesAboveLink.addPaintListener(e -> {
            e.gc.setForeground(((Control)e.widget).getDisplay().getSystemColor(16));
            e.gc.drawLine(0, e.height / 2, e.width / 2, e.height / 2);
            e.gc.drawLine(e.width / 2, e.height / 2, e.width / 2, e.height);
        });
        new Label(container, 0);
        new Label(container, 0);
        new Label(container, 0);
        this.linkButton = new Button(container, 2);
        this.linkButton.setToolTipText("Link project name and folder name");
        this.linkButton.setSelection(true);
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (InputStream iconStream = ((Object)((Object)this)).getClass().getResourceAsStream("/icons/link_obj.png");){
                this.linkImage = new Image((Device)this.linkButton.getDisplay(), iconStream);
                this.linkButton.setImage(this.linkImage);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            AcutePlugin.logError(e1);
        }
        this.linkButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(s -> {
            this.isDirectoryAndProjectLinked = this.linkButton.getSelection();
            this.projectNameText.setEnabled(!this.linkButton.getSelection());
            this.updateProjectName();
        }));
        Label projectNameLabel = new Label(container, 0);
        projectNameLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        projectNameLabel.setText("Project name");
        this.projectNameText = new Text(container, 2048);
        this.projectNameText.setEnabled(false);
        this.projectNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.projectNameControlDecoration = new ControlDecoration((Control)this.projectNameText, 16512);
        this.projectNameControlDecoration.setImage(errorImage);
        this.projectNameControlDecoration.setShowOnlyOnFocus(true);
        this.projectNameText.addModifyListener(e -> {
            this.updateProjectName();
            this.setPageComplete(this.isPageComplete());
        });
        Composite linesBelowLink = new Composite(container, 0);
        GridData linesBelowLinkLayoutData = new GridData(4, 4);
        linesBelowLinkLayoutData.widthHint = 30;
        linesBelowLinkLayoutData.heightHint = 30;
        linesBelowLink.setLayoutData((Object)linesAboveLinkLayoutData);
        linesBelowLink.addPaintListener(e -> {
            e.gc.setForeground(((Control)e.widget).getDisplay().getSystemColor(16));
            e.gc.drawLine(0, e.height / 2, e.width / 2, e.height / 2);
            e.gc.drawLine(e.width / 2, e.height / 2, e.width / 2, 0);
        });
        new Label(container, 0).setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        Label projectTemplateLabel = new Label(container, 0);
        projectTemplateLabel.setText("Project Template");
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(container, 2560);
        GridData listBoxData = new GridData(4, 0x1000000, true, false, 2, 1);
        list.setLayoutData((Object)listBoxData);
        this.templateViewer = new ListViewer(list);
        this.templateViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.templateViewer.setComparator(new ViewerComparator());
        this.templateViewer.addSelectionChangedListener(e -> this.setPageComplete(this.isPageComplete()));
        this.templateControlDecoration = new ControlDecoration(this.templateViewer.getControl(), 16512);
        this.templateControlDecoration.setImage(errorImage);
        this.updateTemplateList();
        IPreferenceStore store = AcutePlugin.getDefault().getPreferenceStore();
        this.updateTemplatesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals(AcutePreferenceInitializer.explicitDotnetPathPreference)) {
                    DotnetNewWizardPage.this.updateTemplateList();
                }
            }
        };
        store.addPropertyChangeListener(this.updateTemplatesListener);
        new Label(container, 0);
        new Label(container, 0);
        Link preferencesLink = new Link(container, 0);
        preferencesLink.setText("<a>.NET Preferences</a>");
        preferencesLink.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        preferencesLink.addSelectionListener(SelectionListener.widgetSelectedAdapter(s -> Display.getDefault().asyncExec(() -> {
            PreferenceDialog preferenceDialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)AcutePreferencePage.PAGE_ID, (String[])new String[]{AcutePreferencePage.PAGE_ID}, null);
            preferenceDialog.setBlockOnOpen(false);
            preferenceDialog.open();
        })));
        new Label(container, 0).setLayoutData((Object)new GridData(4, -1, true, false, 4, 1));
        Composite workingSetComposite = new Composite(container, 0);
        GridData layoutData = new GridData(4, 4, true, false, 4, 1);
        workingSetComposite.setLayoutData((Object)layoutData);
        workingSetComposite.setLayout((Layout)new GridLayout(1, false));
        String[] workingSetIds = new String[]{"org.eclipse.ui.resourceWorkingSetPage"};
        StructuredSelection wsSel = null;
        if (this.workingSets != null) {
            wsSel = new StructuredSelection(this.workingSets.toArray());
        }
        this.workingSetsGroup = new WorkingSetGroup(workingSetComposite, (IStructuredSelection)wsSel, workingSetIds);
        if (this.directory != null) {
            this.updateDirectory(this.directory.getAbsolutePath());
        }
    }

    private void updateTemplateList() {
        if (this.templateViewer.getList().isDisposed()) {
            return;
        }
        this.setTemplateViewToText("Loading templates...");
        try {
            AcutePlugin.getDotnetCommand();
        }
        catch (IllegalStateException e) {
            this.setTemplateViewToText("Error with `dotnet` command, see preferences");
            return;
        }
        Job.create((String)"Retrieve Templates", monitor -> {
            List<DotnetNewAccessor.Template> templates = DotnetNewAccessor.getTemplates();
            Display.getDefault().asyncExec(() -> {
                this.templateViewer.getList().removeAll();
                if (!templates.isEmpty()) {
                    ((GridData)this.templateViewer.getList().getLayoutData()).heightHint = 100;
                    Shell shell = this.templateViewer.getControl().getShell();
                    shell.setSize(shell.getSize().x, shell.getSize().y + 100);
                    this.templateViewer.setInput((Object)templates);
                    if (this.templateViewer.getSelection().isEmpty()) {
                        this.templateViewer.getList().setSelection(0);
                    }
                    this.templateViewer.getList().setEnabled(true);
                    this.setPageComplete(this.isPageComplete());
                } else {
                    this.templateViewer.add((Object)"No available templates, see preferences");
                }
                this.templateViewer.getControl().getParent().layout();
            });
        }).schedule();
    }

    private void setTemplateViewToText(String text) {
        Display.getDefault().asyncExec(() -> {
            if (this.templateViewer.getList().getItemCount() > 1) {
                ((GridData)this.templateViewer.getList().getLayoutData()).heightHint = -1;
                Shell shell = this.templateViewer.getControl().getShell();
                shell.setSize(shell.getSize().x, shell.getSize().y - 100);
            }
            this.templateViewer.getList().removeAll();
            this.templateViewer.add((Object)text);
            this.templateViewer.getControl().getParent().layout();
            this.templateViewer.getList().setEnabled(false);
        });
    }

    private void updateProjectName() {
        if (!this.isDirectoryAndProjectLinked.booleanValue()) {
            this.projectName = this.projectNameText.getText();
        } else if (this.projectName == null || this.directory != null && !this.projectName.equals(this.directory.getName())) {
            this.projectName = this.directory.getName();
            this.projectNameText.setText(this.projectName);
        }
    }

    private void updateDirectory(String directoryPath) {
        this.directory = new File(directoryPath);
        if (!this.locationText.getText().equals(directoryPath)) {
            this.locationText.setText(directoryPath);
        } else if (this.isDirectoryAndProjectLinked.booleanValue()) {
            this.updateProjectName();
        }
    }

    public boolean isPageComplete() {
        String locationError = "";
        String projectNameError = "";
        String templateError = "";
        if (this.directory == null || this.directory.getPath().isEmpty()) {
            locationError = "Please specify a directory";
        } else if (this.projectName == null || this.projectName.isEmpty()) {
            projectNameError = "Please specify project name";
        } else if (this.directory.isFile()) {
            locationError = "Invalid location: it is an existing file.";
        } else if (this.directory.getParentFile() == null || !this.directory.exists() && !this.directory.getParentFile().canWrite()) {
            locationError = "Unable to create such directory";
        } else if (this.directory.exists() && !this.directory.canWrite()) {
            locationError = "Cannot write in this directory";
        } else if (this.getTemplate() == null) {
            templateError = "No template selected";
        } else {
            File dotProject = new File(this.directory, ".project");
            if (dotProject.exists()) {
                IProjectDescription desc = null;
                try {
                    desc = ResourcesPlugin.getWorkspace().loadProjectDescription(Path.fromOSString((String)dotProject.getAbsolutePath()));
                }
                catch (CoreException e) {
                    projectNameError = "Invalid .project file in directory";
                }
                if (!desc.getName().equals(this.projectName)) {
                    projectNameError = "Project name must match one in .project file: " + desc.getName();
                }
            } else {
                IProject project = null;
                try {
                    project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
                    if (project.exists() && (project.getLocation() == null || !this.directory.getAbsoluteFile().equals(project.getLocation().toFile().getAbsoluteFile()))) {
                        projectNameError = "Another project with same name already exists in workspace.";
                    }
                }
                catch (IllegalArgumentException ex) {
                    projectNameError = "Invalid project name";
                }
            }
        }
        String error = String.valueOf(locationError) + projectNameError + templateError;
        if (error.isEmpty()) {
            this.setErrorMessage(null);
            this.projectNameControlDecoration.hide();
            this.locationControlDecoration.hide();
            this.templateControlDecoration.hide();
        } else {
            if (!locationError.isEmpty()) {
                this.locationControlDecoration.showHoverText(locationError);
                this.locationControlDecoration.show();
                this.projectNameControlDecoration.hide();
                this.templateControlDecoration.hide();
            } else if (!projectNameError.isEmpty()) {
                this.projectNameControlDecoration.showHoverText(projectNameError);
                this.projectNameControlDecoration.show();
                this.locationControlDecoration.hide();
                this.templateControlDecoration.hide();
            } else {
                this.templateControlDecoration.showHoverText(projectNameError);
                this.templateControlDecoration.show();
                this.locationControlDecoration.hide();
                this.projectNameControlDecoration.hide();
            }
            this.setErrorMessage(error);
        }
        return error.isEmpty();
    }

    public void dispose() {
        super.dispose();
        this.linkImage.dispose();
        if (this.updateTemplatesListener != null) {
            IPreferenceStore store = AcutePlugin.getDefault().getPreferenceStore();
            store.removePropertyChangeListener(this.updateTemplatesListener);
        }
    }
}

