/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnetrun;

import org.eclipse.acute.ProjectFileAccessor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class DotnetRunTab
extends AbstractLaunchConfigurationTab {
    private Text pathText;
    private ListViewer frameworkViewer;
    private Text argumentsText;
    private Button debugRadio;
    private Button releaseRadio;
    private Button buildCheckBoxButton;
    private String[] targetFrameworks;
    private IContainer projectContainer;
    private String configuration = "Debug";

    public void createControl(Composite parent) {
        Group container = new Group(parent, 2048);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().numColumns(4).applyTo((Composite)container);
        Label locationLabel = new Label((Composite)container, 0);
        locationLabel.setText("Location:");
        locationLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.pathText = new Text((Composite)container, 2048);
        this.pathText.addModifyListener(e -> {
            this.setDirty(true);
            this.projectContainer = ResourcesPlugin.getWorkspace().getRoot().getContainerForLocation((IPath)new Path(this.pathText.getText()));
            this.updateLaunchConfigurationDialog();
            this.updateProjectPath();
        });
        Button browseButton = new Button((Composite)container, 0);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ContainerSelectionDialog dialog = new ContainerSelectionDialog(browseButton.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, "Project Folder:");
            int path = dialog.open();
            Object[] results = dialog.getResult();
            if (path == 0 && results.length > 0) {
                this.pathText.setText(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsolutePath().toString()) + ((Path)results[0]).toOSString());
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pathText);
        Label frameworkLabel = new Label((Composite)container, 0);
        frameworkLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
        frameworkLabel.setText("Framework:");
        List list = new List((Composite)container, 2560);
        GridData listBoxData = new GridData(4, 0x1000000, true, false, 2, 1);
        listBoxData.heightHint = 50;
        list.setLayoutData((Object)listBoxData);
        list.setEnabled(false);
        this.frameworkViewer = new ListViewer(list);
        this.frameworkViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.frameworkViewer.add((Object)"No frameworks available");
        this.frameworkViewer.addSelectionChangedListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Label argumentLabel = new Label((Composite)container, 0);
        argumentLabel.setText("Arguments:");
        argumentLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.argumentsText = new Text((Composite)container, 2048);
        this.argumentsText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.argumentsText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Listener configRadioListener = new Listener(){

            public void handleEvent(Event e) {
                DotnetRunTab.this.configuration = ((Button)e.widget).getText();
                DotnetRunTab.this.setDirty(true);
                DotnetRunTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.debugRadio = new Button((Composite)container, 16);
        this.debugRadio.setText("Debug");
        this.debugRadio.setSelection(true);
        this.debugRadio.addListener(13, configRadioListener);
        this.releaseRadio = new Button((Composite)container, 16);
        this.releaseRadio.setText("Release");
        this.releaseRadio.addListener(13, configRadioListener);
        new Label((Composite)container, 0).setLayoutData((Object)new GridData(4, 0x1000000, false, false, 4, 1));
        this.buildCheckBoxButton = new Button((Composite)container, 32);
        this.buildCheckBoxButton.setSelection(true);
        this.buildCheckBoxButton.setText("Build project");
        this.buildCheckBoxButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 4, 1));
        this.buildCheckBoxButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
    }

    private void updateProjectPath() {
        this.frameworkViewer.getList().removeAll();
        IPath projectFilePath = ProjectFileAccessor.getProjectFile(this.projectContainer);
        if (projectFilePath == null) {
            this.frameworkViewer.add((Object)"No frameworks available");
            this.frameworkViewer.getList().setEnabled(false);
            return;
        }
        this.frameworkViewer.getList().deselectAll();
        this.frameworkViewer.add((Object)"Loading frameworks");
        this.frameworkViewer.getList().setEnabled(false);
        this.targetFrameworks = ProjectFileAccessor.getTargetFrameworks((IPath)new Path(String.valueOf(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsolutePath().toString()) + projectFilePath.toString()));
        this.frameworkViewer.getList().removeAll();
        if (this.targetFrameworks.length > 0) {
            this.frameworkViewer.add((Object[])this.targetFrameworks);
            this.frameworkViewer.getList().select(0);
            this.frameworkViewer.getList().setEnabled(true);
        } else {
            this.frameworkViewer.add((Object)"No frameworks available");
            this.frameworkViewer.getList().setEnabled(false);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("PROJECT_FOLDER", ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        configuration.setAttribute("PROJECT_ARGUMENTS", "");
        configuration.setAttribute("PROJECT_BUILD", true);
        configuration.setAttribute("PROJECT_FRAMEWORK", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.pathText.setText(configuration.getAttribute("PROJECT_FOLDER", ""));
        }
        catch (CoreException ce) {
            this.pathText.setText(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString());
        }
        try {
            List frameworkList = this.frameworkViewer.getList();
            int index = frameworkList.indexOf(configuration.getAttribute("PROJECT_FRAMEWORK", ""));
            if (index >= 0) {
                this.frameworkViewer.getList().select(0);
            } else {
                this.frameworkViewer.getList().deselectAll();
            }
        }
        catch (CoreException frameworkList) {
            // empty catch block
        }
        try {
            this.argumentsText.setText(configuration.getAttribute("PROJECT_ARGUMENTS", ""));
        }
        catch (CoreException ce) {
            this.argumentsText.setText("");
        }
        try {
            this.configuration = configuration.getAttribute("PROJECT_CONFIGURATION", "Debug");
            this.debugRadio.setSelection(this.configuration.equals("Debug"));
            this.releaseRadio.setSelection(!this.debugRadio.getSelection());
        }
        catch (CoreException ce) {
            // empty catch block
        }
        try {
            this.buildCheckBoxButton.setSelection(configuration.getAttribute("PROJECT_BUILD", true));
        }
        catch (CoreException ce) {
            this.buildCheckBoxButton.setSelection(true);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("PROJECT_FOLDER", this.pathText.getText());
        String[] selections = this.frameworkViewer.getList().getSelection();
        if (selections.length > 0) {
            configuration.setAttribute("PROJECT_FRAMEWORK", this.frameworkViewer.getList().getSelection()[0]);
        } else {
            configuration.setAttribute("PROJECT_FRAMEWORK", "");
        }
        configuration.setAttribute("PROJECT_ARGUMENTS", this.argumentsText.getText());
        configuration.setAttribute("PROJECT_BUILD", this.buildCheckBoxButton.getSelection());
        configuration.setAttribute("PROJECT_CONFIGURATION", this.configuration);
        this.setDirty(false);
    }

    public String getName() {
        return "Main";
    }
}

