/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acute.dotnettest;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.acute.AcutePlugin;

public class DotnetTestAccessor {
    public static Map<String, List<String>> getTestMethods(File projectFile) {
        HashMap<String, List<String>> tests = new HashMap<String, List<String>>();
        if (projectFile == null || !projectFile.exists() || !projectFile.isFile() && !projectFile.isDirectory()) {
            return tests;
        }
        if (projectFile.isFile()) {
            projectFile = projectFile.getParentFile();
        }
        if (projectFile == null) {
            return tests;
        }
        try {
            ProcessBuilder restorePB = new ProcessBuilder(AcutePlugin.getDotnetCommand(), "restore");
            restorePB.directory(projectFile);
            Process restoreProcess = restorePB.start();
            restoreProcess.waitFor();
            if (restoreProcess.exitValue() != 0) {
                return tests;
            }
        }
        catch (IOException | IllegalStateException | InterruptedException e) {
            return tests;
        }
        ProcessBuilder processBuilder = new ProcessBuilder(AcutePlugin.getDotnetCommand(), "test", "--list-tests");
        processBuilder.directory(projectFile);
        try {
            Process process = processBuilder.start();
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String inputLine;
                Boolean testsListExists = false;
                while ((inputLine = in.readLine()) != null) {
                    if (!inputLine.equals("The following Tests are available:")) continue;
                    testsListExists = true;
                    break;
                }
                if (testsListExists.booleanValue()) {
                    while ((inputLine = in.readLine()) != null) {
                        if (!inputLine.matches("\\s+.*")) continue;
                        String FullyQualifiedName = inputLine.replaceFirst("\\s+", "").replaceAll("\\(.*\\)", "");
                        int index = FullyQualifiedName.lastIndexOf(46);
                        String className = FullyQualifiedName.substring(0, index);
                        String methodName = FullyQualifiedName.substring(index + 1, FullyQualifiedName.length());
                        ArrayList<String> methods = (ArrayList<String>)tests.get(className);
                        if (methods == null) {
                            methods = new ArrayList<String>();
                        } else if (methods.contains(methodName)) continue;
                        methods.add(methodName);
                        tests.put(className, methods);
                    }
                }
                return tests;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return tests;
        }
    }
}

