/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.bpel.common.ui.editmodel.AbstractEditModelCommand;
import org.eclipse.bpel.model.resource.BPELResource;
import org.eclipse.bpel.ui.commands.util.AutoUndoCommand;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;

public class CompoundCommand
extends AutoUndoCommand {
    private List<Command> commandList = new ArrayList<Command>();

    public CompoundCommand() {
        super(new ArrayList<Object>());
    }

    public CompoundCommand(String label) {
        super(label, new ArrayList<Object>());
    }

    public void add(Command command) {
        if (command != null) {
            this.commandList.add(command);
        }
    }

    public boolean canExecute() {
        if (this.commandList.size() == 0) {
            return false;
        }
        for (Command cmd : this.commandList) {
            if (cmd == null) {
                return false;
            }
            if (cmd.canExecute()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canDoExecute() {
        if (this.commandList.size() == 0) {
            return false;
        }
        for (Command cmd : this.commandList) {
            if (cmd == null) {
                return false;
            }
            if (!(cmd instanceof AutoUndoCommand) || ((AutoUndoCommand)cmd).canDoExecute()) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        for (Command cmd : this.commandList) {
            cmd.dispose();
        }
    }

    @Override
    public void doExecute() {
        for (Command cmd : this.commandList) {
            if (cmd instanceof AutoUndoCommand) {
                ((AutoUndoCommand)cmd).doExecute();
                continue;
            }
            cmd.execute();
        }
    }

    public String getLabel() {
        String label = super.getLabel();
        if (label == null && this.commandList.isEmpty()) {
            return null;
        }
        if (label != null) {
            return label;
        }
        return this.commandList.get(0).getLabel();
    }

    public boolean isEmpty() {
        return this.commandList.isEmpty();
    }

    public List<Command> getCommands() {
        return this.commandList;
    }

    @Override
    public Set<Object> getModelRoots() {
        HashSet<Object> result = new HashSet<Object>();
        for (Command command : this.commandList) {
            if (command instanceof AutoUndoCommand) {
                result.addAll(((AutoUndoCommand)command).getModelRoots());
                continue;
            }
            if (!(command instanceof AbstractEditModelCommand)) continue;
            Resource[] resourceArray = ((AbstractEditModelCommand)command).getResources();
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource res = resourceArray[n2];
                if (res instanceof BPELResource) {
                    result.add(((BPELResource)res).getProcess());
                }
                ++n2;
            }
        }
        return result;
    }
}

