/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.corrosion.CommandJob;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.CorrosionPreferenceInitializer;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.RustManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.osgi.framework.Bundle;

public class CorrosionPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.corrosion.preferencePage";
    public static final List<String> RUST_SOURCE_OPTIONS = Arrays.asList("rustup", "other", "disabled");
    public static final List<String> RUSTUP_TOOLCHAIN_OPTIONS = Arrays.asList("Stable", "Beta", "Nightly", "Other");
    private IPreferenceStore store;
    private Button rustupRadioButton;
    private Button otherRadioButton;
    private Button disableRadioButton;
    private Button installButton;
    private Button useDefaultPathsCheckbox;
    private Label rustupLabel;
    private Text rustupPathText;
    private Button rustupBrowseButton;
    private Label cargoLabel;
    private Text cargoPathText;
    private Button cargoBrowseButton;
    private Label rustupToolchainLabel;
    private Combo rustupToolchainCombo;
    private Composite otherIdComposite;
    private Label otherIdLabel;
    private Text otherIdText;
    private Label rlsLabel;
    private Text rlsPathText;
    private Button rlsBrowseButton;
    private Label sysrootLabel;
    private Text sysrootPathText;
    private Button sysrootBrowseButton;

    public void init(IWorkbench workbench) {
        this.store = this.doGetPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.createCommandPathsPart(container);
        Label rlsLocationLabel = new Label(container, 0);
        rlsLocationLabel.setText(Messages.CorrosionPreferencePage_rlsLocation);
        rlsLocationLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.disableRadioButton = new Button(container, 16);
        this.disableRadioButton.setText(Messages.CorrosionPreferencePage_disableRustEdition);
        this.disableRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.disableRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setRadioSelection(2)));
        this.otherRadioButton = new Button(container, 16);
        this.otherRadioButton.setText(Messages.CorrosionPreferencePage_otherInstallation);
        this.otherRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.otherRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setRadioSelection(1)));
        this.createOtherPart(container);
        this.rustupRadioButton = new Button(container, 16);
        this.rustupRadioButton.setText(Messages.CorrosionPreferencePage_useRustup);
        this.rustupRadioButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.rustupRadioButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setRadioSelection(0)));
        this.createRustupPart(container);
        this.initializeContent();
        return container;
    }

    private void initializeContent() {
        int sourceIndex = RUST_SOURCE_OPTIONS.indexOf(this.store.getString(CorrosionPreferenceInitializer.rustSourcePreference));
        this.setRadioSelection(sourceIndex);
        int toolchainIndex = RUSTUP_TOOLCHAIN_OPTIONS.indexOf(this.store.getString(CorrosionPreferenceInitializer.toolchainTypePreference));
        String toolchainId = this.store.getString(CorrosionPreferenceInitializer.toolchainIdPreference);
        this.otherIdText.setText(toolchainId);
        int i = 0;
        while (i < RUSTUP_TOOLCHAIN_OPTIONS.size()) {
            if (RUSTUP_TOOLCHAIN_OPTIONS.get(i).toLowerCase().equals(toolchainId.toLowerCase())) {
                toolchainIndex = i;
                break;
            }
            ++i;
        }
        this.setToolchainSelection(toolchainIndex);
        this.rustupPathText.setText(this.store.getString(CorrosionPreferenceInitializer.rustupPathPreference));
        this.cargoPathText.setText(this.store.getString(CorrosionPreferenceInitializer.cargoPathPreference));
        this.setDefaultPathsSelection(this.store.getBoolean(CorrosionPreferenceInitializer.defaultPathsPreference));
        this.rlsPathText.setText(this.store.getString(CorrosionPreferenceInitializer.rlsPathPreference));
        this.sysrootPathText.setText(this.store.getString(CorrosionPreferenceInitializer.sysrootPathPreference));
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CorrosionPlugin.getDefault().getPreferenceStore();
    }

    private boolean isPageValid() {
        int radioIndex = this.getRadioSelection();
        if (!this.isCommandPathsValid()) {
            return false;
        }
        if (radioIndex == 0 && this.isRustupSectionValid()) {
            return true;
        }
        if (radioIndex == 1 && this.isOtherInstallSectionValid()) {
            return true;
        }
        return radioIndex == 2;
    }

    private boolean isCommandPathsValid() {
        String error = "";
        if (this.rustupPathText.getText().isEmpty() || this.cargoPathText.getText().isEmpty()) {
            error = Messages.CorrosionPreferencePage_emptyRustupCargoPath;
        } else {
            File rustup = new File(this.rustupPathText.getText());
            File cargo = new File(this.cargoPathText.getText());
            if (!rustup.exists() || !rustup.isFile()) {
                error = Messages.CorrosionPreferencePage_invalidRustup;
            } else if (!rustup.canExecute()) {
                error = Messages.CorrosionPreferencePage_rustupNonExecutable;
            } else if (!cargo.exists() || !cargo.isFile()) {
                error = Messages.CorrosionPreferencePage_invalidCargo;
            } else if (!cargo.canExecute()) {
                error = Messages.CorrosionPreferencePage_cargoNonExecutable;
            }
        }
        if (error.isEmpty()) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(error);
        }
        this.setInstallRequired(!error.isEmpty());
        return error.isEmpty();
    }

    private boolean isRustupSectionValid() {
        if (this.rustupToolchainCombo.getSelectionIndex() == 3 && this.otherIdText.getText().isEmpty()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_emptyToolchain);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private boolean isOtherInstallSectionValid() {
        if (this.rlsPathText.getText().isEmpty() || this.sysrootPathText.getText().isEmpty()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_emptyPath);
            return false;
        }
        File rls = new File(this.rlsPathText.getText());
        if (!rls.exists() || !rls.isFile()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_invalidRlsPath);
            return false;
        }
        if (!rls.canExecute()) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_rlsNonExecutable);
            return false;
        }
        File sysrootPath = new File(this.sysrootPathText.getText());
        boolean a = sysrootPath.exists();
        boolean b = sysrootPath.isDirectory();
        if (!a || !b) {
            this.setErrorMessage(Messages.CorrosionPreferencePage_invalidSysroot);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void performDefaults() {
        int sourceIndex = RUST_SOURCE_OPTIONS.indexOf(this.store.getDefaultString(CorrosionPreferenceInitializer.rustSourcePreference));
        this.setRadioSelection(sourceIndex);
        int toolchainIndex = RUSTUP_TOOLCHAIN_OPTIONS.indexOf(this.store.getDefaultString(CorrosionPreferenceInitializer.toolchainTypePreference));
        String toolchainId = this.store.getDefaultString(CorrosionPreferenceInitializer.toolchainIdPreference);
        this.otherIdText.setText(toolchainId);
        int i = 0;
        while (i < RUSTUP_TOOLCHAIN_OPTIONS.size()) {
            if (RUSTUP_TOOLCHAIN_OPTIONS.get(i).toLowerCase().equals(toolchainId.toLowerCase())) {
                toolchainIndex = i;
                break;
            }
            ++i;
        }
        this.setToolchainSelection(toolchainIndex);
        this.setDefaultPathsSelection(this.store.getDefaultBoolean(CorrosionPreferenceInitializer.defaultPathsPreference));
        this.rustupPathText.setText(this.store.getDefaultString(CorrosionPreferenceInitializer.rustupPathPreference));
        this.cargoPathText.setText(this.store.getDefaultString(CorrosionPreferenceInitializer.cargoPathPreference));
        this.rlsPathText.setText(this.store.getDefaultString(CorrosionPreferenceInitializer.rlsPathPreference));
        this.sysrootPathText.setText(this.store.getDefaultString(CorrosionPreferenceInitializer.sysrootPathPreference));
        super.performDefaults();
    }

    private void setDefaultPathsSelection(boolean selection) {
        this.useDefaultPathsCheckbox.setSelection(selection);
        if (selection) {
            this.rustupPathText.setText(this.store.getDefaultString(CorrosionPreferenceInitializer.rustupPathPreference));
            this.cargoPathText.setText(this.store.getDefaultString(CorrosionPreferenceInitializer.cargoPathPreference));
        }
        this.setDefaultPathsEnabled(!selection);
    }

    private void setToolchainSelection(int selection) {
        this.rustupToolchainCombo.select(selection);
        GridData otherIdData = (GridData)this.otherIdComposite.getLayoutData();
        otherIdData.exclude = selection != 3;
        this.otherIdComposite.getParent().layout();
        this.otherIdComposite.setVisible(!otherIdData.exclude);
        this.otherIdComposite.getParent().getParent().layout(true);
    }

    private int getRadioSelection() {
        if (this.rustupRadioButton.getSelection()) {
            return 0;
        }
        if (this.otherRadioButton.getSelection()) {
            return 1;
        }
        return 2;
    }

    private void setRadioSelection(int selection) {
        this.setOtherEnabled(false);
        this.setRustupEnabled(false);
        this.rustupRadioButton.setSelection(false);
        this.otherRadioButton.setSelection(false);
        this.disableRadioButton.setSelection(false);
        if (selection == 0) {
            this.rustupRadioButton.setSelection(true);
            this.setRustupEnabled(true);
        } else if (selection == 1) {
            this.otherRadioButton.setSelection(true);
            this.setOtherEnabled(true);
        } else {
            this.disableRadioButton.setSelection(true);
        }
        this.isPageValid();
    }

    public boolean performOk() {
        int source = this.getRadioSelection();
        this.store.setValue(CorrosionPreferenceInitializer.rustSourcePreference, RUST_SOURCE_OPTIONS.get(source));
        if (source == 0) {
            String id = this.getToolchainId();
            this.store.setValue(CorrosionPreferenceInitializer.toolchainTypePreference, this.rustupToolchainCombo.getText());
            this.store.setValue(CorrosionPreferenceInitializer.toolchainIdPreference, id);
            this.store.setValue(CorrosionPreferenceInitializer.defaultPathsPreference, this.useDefaultPathsCheckbox.getSelection());
            this.store.setValue(CorrosionPreferenceInitializer.rustupPathPreference, this.rustupPathText.getText());
            this.store.setValue(CorrosionPreferenceInitializer.cargoPathPreference, this.cargoPathText.getText());
            RustManager.setDefaultToolchain(id);
        } else if (source == 1) {
            this.store.setValue(CorrosionPreferenceInitializer.rlsPathPreference, this.rlsPathText.getText());
            this.store.setValue(CorrosionPreferenceInitializer.sysrootPathPreference, this.sysrootPathText.getText());
        }
        return true;
    }

    private String getToolchainId() {
        int index = this.rustupToolchainCombo.getSelectionIndex();
        if (index == -1) {
            return "";
        }
        if (index < 3) {
            return RUSTUP_TOOLCHAIN_OPTIONS.get(index).toLowerCase();
        }
        return this.otherIdText.getText();
    }

    private void createCommandPathsPart(Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new GridLayout(3, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridData textGridData = new GridData(4, 0x1000000, true, false);
        GridData buttonGridData = new GridData(16384, 0x1000000, false, false);
        this.useDefaultPathsCheckbox = new Button(parent, 32);
        this.useDefaultPathsCheckbox.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        this.useDefaultPathsCheckbox.setText(Messages.CorrosionPreferencePage_useDefaultPathsRustupCargo);
        this.useDefaultPathsCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setDefaultPathsEnabled(!this.useDefaultPathsCheckbox.getSelection());
            if (this.useDefaultPathsCheckbox.getSelection()) {
                this.rustupPathText.setText(this.store.getDefaultString(CorrosionPreferenceInitializer.rustupPathPreference));
                this.cargoPathText.setText(this.store.getDefaultString(CorrosionPreferenceInitializer.cargoPathPreference));
            }
            this.setValid(this.isPageValid());
        }));
        this.installButton = new Button(parent, 0);
        this.installButton.setLayoutData((Object)buttonGridData);
        this.installButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (Platform.getOS().equals("win32")) {
                Program.launch((String)"https://rustup.rs/");
            } else {
                this.installCommands();
            }
        }));
        this.rustupLabel = new Label(parent, 0);
        this.rustupLabel.setText(Messages.CorrosionPreferencePage_Rustup);
        this.rustupLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.rustupPathText = new Text(parent, 2048);
        this.rustupPathText.setLayoutData((Object)textGridData);
        this.rustupPathText.addModifyListener(e -> this.setValid(this.isPageValid()));
        this.rustupBrowseButton = new Button(parent, 0);
        this.rustupBrowseButton.setLayoutData((Object)buttonGridData);
        this.rustupBrowseButton.setText(Messages.CorrosionPreferencePage_browse);
        this.rustupBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.rustupBrowseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.rustupPathText.setText(path);
            }
        }));
        this.cargoLabel = new Label(parent, 0);
        this.cargoLabel.setText(Messages.CorrosionPreferencePage_caro);
        this.cargoLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.cargoPathText = new Text(parent, 2048);
        this.cargoPathText.setLayoutData((Object)textGridData);
        this.cargoPathText.addModifyListener(e -> this.setValid(this.isPageValid()));
        this.cargoBrowseButton = new Button(parent, 0);
        this.cargoBrowseButton.setLayoutData((Object)buttonGridData);
        this.cargoBrowseButton.setText(Messages.CorrosionPreferencePage_browser);
        this.cargoBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.cargoBrowseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.cargoPathText.setText(path);
            }
        }));
    }

    private void installCommands() {
        String[] command;
        this.installButton.setText(Messages.CorrosionPreferencePage_installing);
        this.installButton.setEnabled(false);
        try {
            Bundle bundle = CorrosionPlugin.getDefault().getBundle();
            URL fileURL = FileLocator.toFileURL((URL)bundle.getEntry("scripts/rustup-init.sh"));
            File file = new File(new URI(fileURL.getProtocol(), fileURL.getPath(), null));
            file.setExecutable(true);
            command = new String[]{"/bin/bash", "-c", String.valueOf(file.getAbsolutePath()) + " -y"};
        }
        catch (IOException | URISyntaxException e) {
            CorrosionPlugin.showError(Messages.CorrosionPreferencePage_cannotInstallRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo_details, e);
            return;
        }
        CommandJob installCommandJob = new CommandJob(command, Messages.CorrosionPreferencePage_installingRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo, Messages.CorrosionPreferencePage_cannotInstallRustupCargo_details, 15);
        installCommandJob.setUser(true);
        installCommandJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (event.getResult() == Status.OK_STATUS) {
                    CorrosionPreferenceInitializer initializer = new CorrosionPreferenceInitializer();
                    initializer.initializeDefaultPreferences();
                    Display.getDefault().asyncExec(() -> {
                        if (CorrosionPreferencePage.this.installButton.isDisposed()) {
                            return;
                        }
                        CorrosionPreferencePage.this.setInstallRequired(false);
                        CorrosionPreferencePage.this.performDefaults();
                        CorrosionPreferencePage.this.setValid(CorrosionPreferencePage.this.isPageValid());
                    });
                    RustManager.setDefaultToolchain("beta");
                }
            }
        });
        installCommandJob.schedule();
    }

    private void setInstallRequired(Boolean required) {
        if (required.booleanValue()) {
            this.installButton.setText(Messages.CorrosionPreferencePage_install);
        } else {
            this.installButton.setText(Messages.CorrosionPreferencePage_installed);
        }
        this.installButton.setEnabled(required.booleanValue());
    }

    private void createRustupPart(Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new GridLayout(3, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.rustupToolchainLabel = new Label(parent, 0);
        this.rustupToolchainLabel.setText(Messages.CorrosionPreferencePage_toolchain);
        GridData rustupToolchainGridData = new GridData(131072, 0x1000000, false, false);
        rustupToolchainGridData.horizontalIndent = 25;
        this.rustupToolchainLabel.setLayoutData((Object)rustupToolchainGridData);
        this.rustupToolchainCombo = new Combo(parent, 12);
        this.rustupToolchainCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        for (String toolchain : RUSTUP_TOOLCHAIN_OPTIONS) {
            this.rustupToolchainCombo.add(toolchain);
        }
        this.rustupToolchainCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setToolchainSelection(this.rustupToolchainCombo.getSelectionIndex());
            this.getShell().pack();
            this.getShell().layout();
            this.setValid(this.isPageValid());
        }));
        new Label(parent, 0);
        new Label(parent, 0);
        this.otherIdComposite = new Composite(parent, 0);
        this.otherIdComposite.setLayout((Layout)new GridLayout(3, false));
        GridData otherIdData = new GridData(4, 0x1000000, true, false);
        otherIdData.exclude = false;
        this.otherIdComposite.setLayoutData((Object)otherIdData);
        this.otherIdLabel = new Label(this.otherIdComposite, 0);
        this.otherIdLabel.setText(Messages.CorrosionPreferencePage_id);
        this.otherIdLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.otherIdText = new Text(this.otherIdComposite, 2048);
        this.otherIdText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.otherIdText.addModifyListener(e -> this.setValid(this.isPageValid()));
        new Label(parent, 0);
    }

    private void setDefaultPathsEnabled(boolean enabled) {
        this.rustupLabel.setEnabled(enabled);
        this.rustupPathText.setEnabled(enabled);
        this.rustupBrowseButton.setEnabled(enabled);
        this.cargoLabel.setEnabled(enabled);
        this.cargoPathText.setEnabled(enabled);
        this.cargoBrowseButton.setEnabled(enabled);
    }

    private void setRustupEnabled(boolean enabled) {
        this.rustupToolchainLabel.setEnabled(enabled);
        this.rustupToolchainCombo.setEnabled(enabled);
        this.otherIdLabel.setEnabled(enabled);
        this.otherIdText.setEnabled(enabled);
    }

    private void createOtherPart(Composite container) {
        Composite parent = new Composite(container, 0);
        parent.setLayout((Layout)new GridLayout(3, false));
        parent.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        GridData labelIndent = new GridData(4, 0x1000000, true, false, 3, 1);
        labelIndent.horizontalIndent = 25;
        GridData textIndent = new GridData(4, 0x1000000, true, false);
        textIndent.horizontalIndent = 50;
        textIndent.widthHint = this.convertWidthInCharsToPixels(50);
        this.rlsLabel = new Label(parent, 0);
        this.rlsLabel.setText(Messages.CorrosionPreferencePage_rlsPath);
        this.rlsLabel.setLayoutData((Object)labelIndent);
        this.rlsPathText = new Text(parent, 2048);
        this.rlsPathText.setLayoutData((Object)textIndent);
        this.rlsPathText.addModifyListener(e -> this.setValid(this.isPageValid()));
        this.rlsBrowseButton = new Button(parent, 0);
        this.rlsBrowseButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.rlsBrowseButton.setText(Messages.CorrosionPreferencePage_browse);
        this.rlsBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.rlsBrowseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.rlsPathText.setText(path);
            }
        }));
        this.sysrootLabel = new Label(parent, 0);
        this.sysrootLabel.setText(Messages.CorrosionPreferencePage_sysrootPath);
        this.sysrootLabel.setLayoutData((Object)labelIndent);
        this.sysrootPathText = new Text(parent, 2048);
        this.sysrootPathText.setLayoutData((Object)textIndent);
        this.sysrootPathText.addModifyListener(e -> this.setValid(this.isPageValid()));
        this.sysrootBrowseButton = new Button(parent, 0);
        this.sysrootBrowseButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.sysrootBrowseButton.setText(Messages.CorrosionPreferencePage_browse);
        this.sysrootBrowseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.sysrootBrowseButton.getShell());
            String path = dialog.open();
            if (path != null) {
                this.sysrootPathText.setText(path);
            }
        }));
    }

    private void setOtherEnabled(boolean enabled) {
        this.rlsLabel.setEnabled(enabled);
        this.rlsPathText.setEnabled(enabled);
        this.rlsBrowseButton.setEnabled(enabled);
        this.sysrootLabel.setEnabled(enabled);
        this.sysrootPathText.setEnabled(enabled);
        this.sysrootBrowseButton.setEnabled(enabled);
    }
}

