/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.cargo.ui;

import java.util.List;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CLIOption;
import org.eclipse.corrosion.cargo.ui.OptionLabelProvider;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class OptionSelector
extends ElementListSelectionDialog {
    private Text fArgumentText;
    private Text fDescriptionText;
    private CLIOption selection;
    private String argumentString;

    public OptionSelector(Shell parent, List<CLIOption> options) {
        super(parent, (ILabelProvider)new OptionLabelProvider());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(Messages.OptionSelector_title);
        this.setMessage(Messages.OptionSelector_message);
        this.setMultipleSelection(false);
        this.setElements(options.toArray(new CLIOption[options.size()]));
    }

    public String returnOptionSelection() {
        if (this.selection == null) {
            return null;
        }
        String returnString = this.selection.getFlag();
        if (this.argumentString != null && !this.argumentString.isEmpty()) {
            returnString = String.valueOf(returnString) + ' ' + this.argumentString;
        }
        return returnString;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        this.createArgumentArea((Composite)control);
        return control;
    }

    private void createArgumentArea(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)768);
        new Label(container, 0).setText(Messages.OptionSelector_arguments);
        this.fArgumentText = new Text(container, 2048);
        this.fArgumentText.setLayoutData((Object)new GridData(768));
        this.fArgumentText.setEnabled(false);
        this.fArgumentText.addModifyListener(e -> {
            this.argumentString = this.fArgumentText.getText();
        });
        new Label(container, 0).setText(Messages.OptionSelector_optionDescription);
        this.fDescriptionText = new Text(container, 2624);
        this.fDescriptionText.setFont(container.getFont());
        this.fDescriptionText.setEditable(false);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.heightHint = 50;
        this.fDescriptionText.setLayoutData((Object)gd);
    }

    protected void handleSelectionChanged() {
        String description;
        this.fArgumentText.setText("");
        this.fArgumentText.setEnabled(false);
        this.fDescriptionText.setText("");
        if (this.getSelectionIndex() == -1) {
            this.selection = null;
            return;
        }
        this.selection = (CLIOption)this.getSelectedElements()[0];
        CharSequence[] arguments = this.selection.getArguments();
        if (arguments != null) {
            this.fArgumentText.setText(String.join((CharSequence)" ", arguments));
            this.fArgumentText.setEnabled(true);
        }
        if ((description = this.selection.getDescription()) != null) {
            this.fDescriptionText.setText(description);
        }
        super.handleSelectionChanged();
    }
}

