/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.debug;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.corrosion.Messages;
import org.eclipse.corrosion.cargo.core.CargoProjectTester;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RustDebugTab
extends AbstractLaunchConfigurationTab {
    private Text projectText;
    private Text buildCommandText;
    private Button defaultExecutablePathButton;
    private Text executablePathText;
    private Label executableLabel;
    private Button browseExecutableButton;
    private IProject project;
    private File executable;
    private static CargoProjectTester tester = new CargoProjectTester();

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.corrosionBUILD_COMMAND", this.buildCommandText.getText());
        configuration.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.projectText.getText());
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.executablePathText.getText());
        if (this.project != null) {
            configuration.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", this.project.getLocation().toString());
        }
        this.setDirty(false);
    }

    public void createControl(Composite parent) {
        Group container = new Group(parent, 2048);
        this.setControl((Control)container);
        GridLayoutFactory.swtDefaults().numColumns(3).applyTo((Composite)container);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        Label projectLabel = new Label((Composite)container, 0);
        projectLabel.setText(Messages.RustDebugTab_project);
        projectLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.projectText = new Text((Composite)container, 2048);
        this.projectText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.projectText.addModifyListener(e -> {
            this.setDirty(true);
            this.project = !this.projectText.getText().isEmpty() ? ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectText.getText()) : null;
            if (this.defaultExecutablePathButton.getSelection()) {
                this.executablePathText.setText(this.getDefaultExecutablePath());
            }
            this.updateLaunchConfigurationDialog();
        });
        Button browseButton = new Button((Composite)container, 0);
        browseButton.setText(Messages.RustDebugTab_browse);
        browseButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        browseButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ListSelectionDialog dialog = new ListSelectionDialog(browseButton.getShell(), (Object)ResourcesPlugin.getWorkspace().getRoot(), (IStructuredContentProvider)new BaseWorkbenchContentProvider(), (ILabelProvider)new WorkbenchLabelProvider(), Messages.RustDebugTab_selectProject);
            dialog.setTitle(Messages.RustDebugTab_projectSelection);
            int returnCode = dialog.open();
            Object[] results = dialog.getResult();
            if (returnCode == 0 && results.length > 0) {
                this.setDirty(true);
                this.projectText.setText(((IProject)results[0]).getName());
                if (this.defaultExecutablePathButton.getSelection()) {
                    this.executablePathText.setText(this.getDefaultExecutablePath());
                }
                this.updateLaunchConfigurationDialog();
            }
        }));
        Group buildCommandGroup = new Group((Composite)container, 0);
        buildCommandGroup.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        buildCommandGroup.setLayout((Layout)new GridLayout(2, false));
        buildCommandGroup.setText(Messages.RustDebugTab_buildCommand);
        this.buildCommandText = new Text((Composite)buildCommandGroup, 2626);
        GridData buildCommandGridData = new GridData(4, 0x1000000, true, false);
        buildCommandGridData.heightHint = 100;
        this.buildCommandText.setLayoutData((Object)buildCommandGridData);
        this.buildCommandText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        Button variableButton = new Button((Composite)buildCommandGroup, 0);
        variableButton.setText(Messages.RustDebugTab_variables);
        variableButton.setLayoutData((Object)new GridData(131072, 128, false, false));
        variableButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            StringVariableSelectionDialog variableSelector = new StringVariableSelectionDialog(variableButton.getShell());
            int returnCode = variableSelector.open();
            String result = variableSelector.getVariableExpression();
            if (returnCode == 0 && result != null) {
                this.buildCommandText.append(result);
            }
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        }));
        this.defaultExecutablePathButton = new Button((Composite)container, 32);
        this.defaultExecutablePathButton.setText(Messages.RustDebugTab_useDefaultPathToExecutable);
        this.defaultExecutablePathButton.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 3, 1));
        this.defaultExecutablePathButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setDefaultExecutionPath(this.defaultExecutablePathButton.getSelection())));
        this.defaultExecutablePathButton.setSelection(true);
        this.executableLabel = new Label((Composite)container, 0);
        this.executableLabel.setText(Messages.RustDebugTab_Executable);
        this.executableLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.executablePathText = new Text((Composite)container, 2048);
        this.executablePathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.executablePathText.addModifyListener(e -> {
            this.setDirty(true);
            this.executable = new File(this.executablePathText.getText());
            this.updateLaunchConfigurationDialog();
        });
        this.browseExecutableButton = new Button((Composite)container, 0);
        this.browseExecutableButton.setText(Messages.RustDebugTab_BrowseExecutable);
        this.browseExecutableButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.browseExecutableButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            FileDialog dialog = new FileDialog(this.browseExecutableButton.getShell());
            String result = dialog.open();
            if (result != null) {
                this.projectText.setText(result);
                this.setDirty(true);
                this.updateLaunchConfigurationDialog();
            }
        }));
        this.setDefaultExecutionPath(true);
    }

    private void setDefaultExecutionPath(boolean state) {
        this.defaultExecutablePathButton.setEnabled(state);
        this.executablePathText.setEnabled(!state);
        this.browseExecutableButton.setEnabled(!state);
        if (state) {
            this.executablePathText.setText(this.getDefaultExecutablePath());
        }
    }

    private String getDefaultExecutablePath() {
        if (this.project == null) {
            return "";
        }
        return String.valueOf(this.project.getLocation().toString()) + "/target/debug/" + this.project.getName();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.corrosionBUILD_COMMAND", "build");
        configuration.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        configuration.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        configuration.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", "");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projectText.setText(configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", ""));
        }
        catch (CoreException ce) {
            this.projectText.setText("");
        }
        try {
            this.buildCommandText.setText(configuration.getAttribute("org.eclipse.corrosionBUILD_COMMAND", "build"));
        }
        catch (CoreException ce) {
            this.buildCommandText.setText("");
        }
        try {
            this.executablePathText.setText(configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", ""));
        }
        catch (CoreException ce) {
            this.executablePathText.setText("");
        }
        this.setDefaultExecutionPath(this.executablePathText.getText().equals(this.getDefaultExecutablePath()));
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.canSave();
    }

    public boolean canSave() {
        if (this.buildCommandText.getText().isEmpty()) {
            this.setErrorMessage(Messages.RustDebugTab_cargoCommandConnotBeEmpty);
            return false;
        }
        if (this.project == null || !this.project.exists() || !tester.test(this.project, "isCargoProject", null, null)) {
            this.setErrorMessage(Messages.RustDebugTab_InvalidCargoProjectName);
            return false;
        }
        if (this.executable == null || !this.executable.exists() || !this.executable.canExecute()) {
            this.setErrorMessage(Messages.RustDebugTab_InvalidProjectExecutablePath);
            return false;
        }
        if (!this.executable.canExecute()) {
            this.setErrorMessage(Messages.RustDebugTab_ExecutableNotExecutable);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public String getName() {
        return "Main";
    }
}

