/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.corrosion.debug;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.corrosion.CorrosionPlugin;
import org.eclipse.corrosion.CorrosionPreferenceInitializer;
import org.eclipse.debug.core.ILaunch;

public class RustGDBLaunchWrapper
extends GdbLaunch {
    public RustGDBLaunchWrapper(ILaunch launch) {
        super(launch.getLaunchConfiguration(), launch.getLaunchMode(), launch.getSourceLocator());
    }

    public String[] getLaunchEnvironment() throws CoreException {
        String[] envVariables = super.getLaunchEnvironment();
        int length = envVariables.length;
        if (length > 0) {
            int i = 0;
            while (i < length) {
                if (envVariables[i].startsWith("PATH=")) {
                    int n = i;
                    envVariables[n] = String.valueOf(envVariables[n]) + ':' + this.getCargoBinLocation() + ':' + this.getGDBLocation();
                    return envVariables;
                }
                ++i;
            }
        }
        envVariables = Arrays.copyOf(envVariables, length + 1);
        envVariables[length] = "PATH=:" + this.getCargoBinLocation() + ':' + this.getGDBLocation();
        return envVariables;
    }

    private String getCargoBinLocation() {
        IPath location = Path.fromOSString((String)CorrosionPlugin.getDefault().getPreferenceStore().getString(CorrosionPreferenceInitializer.cargoPathPreference));
        String parentDirectory = location.toFile().getParent();
        return parentDirectory != null ? parentDirectory : "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getGDBLocation() {
        String[] command = new String[]{"/bin/bash", "-c", "which gdb"};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where gdb"};
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                IPath location = Path.fromOSString((String)in.readLine());
                String parentDirectory = location.toFile().getParent();
                return parentDirectory != null ? parentDirectory : "";
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            return "";
        }
    }
}

