/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.clone;

import java.io.File;
import java.net.URISyntaxException;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.AbstractGitCloneWizard;
import org.eclipse.egit.ui.internal.clone.CloneDestinationPage;
import org.eclipse.egit.ui.internal.clone.GitCloneSourceProviderExtension;
import org.eclipse.egit.ui.internal.clone.GitSelectRepositoryPage;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportRootWizardPage;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportWizard;

public class SmartImportGitWizard
extends AbstractGitCloneWizard
implements IImportWizard,
IPageChangedListener {
    private SmartImportWizard easymportWizard;
    private GitSelectRepositoryPage selectRepoPage = new GitSelectRepositoryPage();

    public SmartImportGitWizard() {
        IDialogSettings dialogSettings = super.getDialogSettings();
        if (dialogSettings == null) {
            dialogSettings = Activator.getDefault().getDialogSettings();
            this.setDialogSettings(dialogSettings);
        }
        this.setDefaultPageImageDescriptor(UIIcons.WIZBAN_IMPORT_REPO);
        this.easymportWizard = new SmartImportWizard();
        this.setWindowTitle(UIText.GitImportWizard_WizardTitle);
    }

    protected void addPreClonePages() {
        if (!this.hasSearchResult()) {
            this.addPage((IWizardPage)this.selectRepoPage);
        }
    }

    protected void addPostClonePages() {
        this.easymportWizard.addPages();
    }

    public boolean performFinish() {
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().getWizard() == this.easymportWizard && this.easymportWizard.canFinish();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected List<GitCloneSourceProviderExtension.CloneSourceProvider> getCloneSourceProviders() {
        List cloneSourceProvider = super.getCloneSourceProviders();
        cloneSourceProvider.add(0, GitCloneSourceProviderExtension.CloneSourceProvider.LOCAL);
        return cloneSourceProvider;
    }

    public CloneDestinationPage getCloneDestinationPage() {
        return this.cloneDestination;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectRepoPage || page == this.cloneDestination) {
            return this.easymportWizard.getPages()[0];
        }
        return super.getNextPage(page);
    }

    public boolean needsClone() {
        return this.cloneDestination.cloneSettingsChanged();
    }

    private boolean needToCloneRepository() {
        return this.cloneDestination.cloneSettingsChanged();
    }

    private File doClone(final SmartImportRootWizardPage importRootPage) {
        this.setCallerRunsCloneOperation(true);
        try {
            final GitRepositoryInfo repositoryInfo = this.currentSearchResult.getGitRepositoryInfo();
            this.performClone(repositoryInfo);
            this.getContainer().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SmartImportGitWizard.this.runCloneOperation(SmartImportGitWizard.this.getContainer(), repositoryInfo);
                    SmartImportGitWizard.this.cloneDestination.saveSettingsForClonedRepo();
                    importRootPage.setInitialImportRoot(SmartImportGitWizard.this.getCloneDestinationPage().getDestinationFile());
                }
            });
        }
        catch (URISyntaxException e) {
            Activator.error((String)UIText.GitImportWizard_errorParsingURI, (Throwable)e);
        }
        catch (NoRepositoryInfoException e) {
            Activator.error((String)UIText.GitImportWizard_noRepositoryInfo, (Throwable)e);
        }
        catch (Exception e) {
            Activator.error((String)e.getMessage(), (Throwable)e);
        }
        return this.getCloneDestinationPage().getDestinationFile();
    }

    public void pageChanged(PageChangedEvent event) {
        SmartImportRootWizardPage selectRootPage = (SmartImportRootWizardPage)this.easymportWizard.getPages()[0];
        if (event.getSelectedPage() == selectRootPage) {
            Repository existingRepo = this.selectRepoPage.getRepository();
            if (existingRepo != null) {
                selectRootPage.setInitialImportRoot(existingRepo.getWorkTree());
            } else if (this.needToCloneRepository()) {
                this.doClone(selectRootPage);
            }
        }
    }

    public void setContainer(IWizardContainer container) {
        if (container instanceof IPageChangeProvider) {
            ((IPageChangeProvider)container).addPageChangedListener((IPageChangedListener)this);
        }
        super.setContainer(container);
    }

    public void dispose() {
        if (this.getContainer() instanceof IPageChangeProvider) {
            ((IPageChangeProvider)this.getContainer()).removePageChangedListener((IPageChangedListener)this);
        }
        super.dispose();
    }
}

