/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.dawn.graphiti.editors;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.dawn.appearance.DawnElementStylizer;
import org.eclipse.emf.cdo.dawn.editors.IDawnEditor;
import org.eclipse.emf.cdo.dawn.editors.impl.DawnAbstractEditorSupport;
import org.eclipse.emf.cdo.dawn.gmf.appearance.DawnAppearancer;
import org.eclipse.emf.cdo.dawn.gmf.synchronize.DawnChangeHelper;
import org.eclipse.emf.cdo.dawn.gmf.util.DawnDiagramUpdater;
import org.eclipse.emf.cdo.dawn.graphiti.notifications.DawnGraphitiHandler;
import org.eclipse.emf.cdo.dawn.graphiti.notifications.DawnGraphitiLockingHandler;
import org.eclipse.emf.cdo.dawn.graphiti.util.DawnGraphitiUtil;
import org.eclipse.emf.cdo.dawn.helper.DawnEditorHelper;
import org.eclipse.emf.cdo.dawn.notifications.BasicDawnListener;
import org.eclipse.emf.cdo.dawn.spi.DawnState;
import org.eclipse.emf.cdo.dawn.ui.stylizer.DawnElementStylizerRegistry;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandlerBase;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.ui.editor.DiagramEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DawnGraphitiEditorSupport
extends DawnAbstractEditorSupport {
    private DawnGraphitiHandler dawnGraphitiHandler = new DawnGraphitiHandler(this.getEditor());

    public DawnGraphitiEditorSupport(IDawnEditor editor) {
        super(editor);
    }

    public void close() {
        CDOView view = this.getView();
        if (view != null && !view.isClosed()) {
            view.close();
        }
    }

    protected BasicDawnListener getBasicHandler() {
        return this.dawnGraphitiHandler;
    }

    protected BasicDawnListener getLockingHandler() {
        return new DawnGraphitiLockingHandler(this.getEditor());
    }

    protected CDOTransactionHandlerBase getTransactionHandler() {
        return this.dawnGraphitiHandler;
    }

    public void rollback() {
        super.rollback();
        final DiagramEditor diagramDocumentEditor = (DiagramEditor)this.getEditor();
        TransactionalEditingDomain editingDomain = diagramDocumentEditor.getEditingDomain();
        editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

            public void doExecute() {
                RootEditPart rootEditPart = diagramDocumentEditor.getGraphicalViewer().getRootEditPart();
                DawnAppearancer.setEditPartDefaultAllChildren((EditPart)rootEditPart);
                DawnDiagramUpdater.refreshEditPart((EditPart)rootEditPart);
            }
        });
    }

    public void refresh() {
        DawnEditorHelper.getDisplay().asyncExec(new Runnable(){

            public void run() {
                RootEditPart rootEditPart = ((DiagramEditor)DawnGraphitiEditorSupport.this.getEditor()).getGraphicalViewer().getRootEditPart();
                DawnDiagramUpdater.refreshEditPart((EditPart)rootEditPart);
            }
        });
    }

    public void lockObject(Object objectToBeLocked) {
        if (objectToBeLocked instanceof EditPart) {
            DawnElementStylizer stylizer;
            EditPart editPart = (EditPart)objectToBeLocked;
            Object model = editPart.getModel();
            if (model instanceof EObject) {
                CDOUtil.getCDOObject((EObject)((EObject)model)).cdoWriteLock().lock();
                if (model instanceof PictogramElement) {
                    EList businessObjects = ((PictogramElement)model).getLink().getBusinessObjects();
                    for (EObject element : businessObjects) {
                        CDOUtil.getCDOObject((EObject)element).cdoWriteLock().lock();
                    }
                }
            }
            if ((stylizer = DawnElementStylizerRegistry.instance.getStylizer((Object)editPart)) != null) {
                stylizer.setLocked((Object)editPart, 3);
            }
        }
        this.refresh();
    }

    public void unlockObject(Object objectToBeUnlocked) {
        if (objectToBeUnlocked instanceof EditPart) {
            DawnElementStylizer stylizer;
            EditPart editPart = (EditPart)objectToBeUnlocked;
            Object model = editPart.getModel();
            if (model instanceof EObject) {
                CDOUtil.getCDOObject((EObject)((EObject)model)).cdoWriteLock().unlock();
                if (model instanceof PictogramElement && model instanceof PictogramElement) {
                    EList businessObjects = ((PictogramElement)model).getLink().getBusinessObjects();
                    for (EObject element : businessObjects) {
                        CDOUtil.getCDOObject((EObject)element).cdoWriteLock().unlock();
                    }
                }
            }
            if ((stylizer = DawnElementStylizerRegistry.instance.getStylizer((Object)editPart)) != null) {
                stylizer.setDefault((Object)editPart);
            }
        }
        this.refresh();
    }

    public void handleRemoteLockChanges(final Map<Object, DawnState> changedObjects) {
        DawnEditorHelper.getDisplay().asyncExec(new Runnable(){

            public void run() {
                for (Object o : changedObjects.keySet()) {
                    DawnGraphitiEditorSupport.this.handleLock((CDOObject)o, DawnGraphitiEditorSupport.this.getView());
                }
            }
        });
        this.refresh();
    }

    private void handleLock(CDOObject object, CDOView cdoView) {
        EObject element = CDOUtil.getEObject((EObject)object);
        DiagramEditor editor = (DiagramEditor)this.getEditor();
        List<PictogramElement> pictogramElements = DawnGraphitiUtil.getPictgramElements(editor.getDiagramTypeProvider().getDiagram(), element);
        for (PictogramElement pictogramElement : pictogramElements) {
            EditPart editPart = DawnGraphitiUtil.getEditpart(pictogramElement, (EditPart)editor.getGraphicalViewer().getRootEditPart());
            if (editPart == null) continue;
            if (object.cdoWriteLock().isLocked()) {
                DawnAppearancer.setEditPartLocked((EditPart)editPart, (int)3);
                continue;
            }
            if (object.cdoWriteLock().isLockedByOthers()) {
                DawnAppearancer.setEditPartLocked((EditPart)editPart, (int)4);
                DawnChangeHelper.deactivateEditPart((EditPart)editPart);
                continue;
            }
            DawnAppearancer.setEditPartDefault((EditPart)editPart);
            DawnChangeHelper.activateEditPart((EditPart)editPart);
        }
    }
}

