/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.dbws.eclipselink.ui.internal.wizards.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jpt.common.ui.internal.swt.widgets.TableTools;
import org.eclipse.jpt.common.ui.internal.widgets.TableLayoutComposite;
import org.eclipse.jpt.common.utility.internal.collection.CollectionTools;
import org.eclipse.jpt.dbws.eclipselink.ui.JptDbwsEclipseLinkUiImages;
import org.eclipse.jpt.dbws.eclipselink.ui.JptDbwsEclipseLinkUiMessages;
import org.eclipse.jpt.dbws.eclipselink.ui.internal.wizards.gen.DbwsGeneratorWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class JdbcDriverWizardPage
extends WizardPage {
    private final String storedDriverClasspathId;
    private ArrayList<String> jarPaths;
    public static String BINDINGS_FILE_FILTER = "*.jar;*.zip";
    private static final String PAGE_ID = "DRIVER_CLASSPATH_ID";
    private static final String PATH_SEPARATOR = System.getProperty("path.separator");

    protected JdbcDriverWizardPage(String wizardName) {
        super("Jdbc Driver");
        this.initialize();
        this.jarPaths = new ArrayList();
        this.storedDriverClasspathId = String.valueOf(wizardName) + "." + PAGE_ID;
    }

    protected void initialize() {
        this.setTitle(JptDbwsEclipseLinkUiMessages.JDBC_DRIVER_WIZARD_PAGE__TITLE);
        this.setDescription(JptDbwsEclipseLinkUiMessages.JDBC_DRIVER_WIZARD_PAGE__DESC);
        this.setImageDescriptor(JptDbwsEclipseLinkUiImages.NEW_WEB_SERVICES_CLIENT_BANNER);
    }

    public void finish() {
        this.saveWidgetValues();
    }

    public String getDriverJarList() {
        return this.buildDriverJarListString();
    }

    private void initializeJarPaths() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            Object[] driverPaths = settings.getArray(this.storedDriverClasspathId);
            if (driverPaths == null) {
                return;
            }
            this.jarPaths = new ArrayList();
            CollectionTools.addAll(this.jarPaths, (Object[])driverPaths);
        }
    }

    private void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] driverPaths = this.jarPaths.toArray(new String[0]);
            settings.put(this.storedDriverClasspathId, driverPaths);
        }
    }

    private String buildDriverJarListString() {
        if (this.jarPaths.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (String jar : this.jarPaths) {
            result.append(jar).append(PATH_SEPARATOR);
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public void createControl(Composite parent) {
        this.initializeJarPaths();
        this.setPageComplete(true);
        this.setControl(this.buildTopLevelControl(parent));
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        new JarsGroup(composite);
        return composite;
    }

    private void removeJarFile(String filePath) {
        this.jarPaths.remove(filePath);
    }

    private void addJarFile(String filePath) {
        if (!this.jarPaths.contains(filePath)) {
            this.jarPaths.add(filePath);
        }
    }

    private class JarsGroup {
        private JarsGroup(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            this.buildLabel(composite, 2, JptDbwsEclipseLinkUiMessages.JDBC_DRIVER_WIZARD_PAGE__DRIVER_FILES);
            this.buildDriverFilesTable(composite);
        }

        public IJavaProject getJavaProject() {
            IWizard wizard = JdbcDriverWizardPage.this.getWizard();
            if (!(wizard instanceof DbwsGeneratorWizard)) {
                throw new NullPointerException();
            }
            return ((DbwsGeneratorWizard)wizard).getJavaProject();
        }

        private ArrayList<String> getJarPaths() {
            return JdbcDriverWizardPage.this.jarPaths;
        }

        private TableViewer buildDriverFilesTable(Composite parent) {
            TableViewer tableViewer = this.buildTableViewer(parent, this.getJarPaths());
            this.buildAddRemoveButtons(parent, tableViewer);
            return tableViewer;
        }

        private TableViewer buildTableViewer(Composite parent, ArrayList<String> tableDataModel) {
            TableLayoutComposite tableLayout = new TableLayoutComposite(parent, 0);
            this.addColumnsData(tableLayout);
            Table table = new Table((Composite)tableLayout, 68356);
            table.setLinesVisible(false);
            TableColumn column = new TableColumn(table, 0, 0);
            column.setResizable(true);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = 1;
            gridData.heightHint = TableTools.calculateHeightHint((Table)table, (int)7);
            tableLayout.setLayoutData((Object)gridData);
            TableViewer tableViewer = new TableViewer(table);
            tableViewer.setUseHashlookup(true);
            tableViewer.setLabelProvider(this.buildLabelProvider());
            tableViewer.setContentProvider(this.buildContentProvider());
            tableViewer.setInput(tableDataModel);
            tableViewer.refresh();
            return tableViewer;
        }

        private void buildAddRemoveButtons(Composite parent, final TableViewer tableViewer) {
            Composite buttonComposite = new Composite(parent, 0);
            GridLayout buttonLayout = new GridLayout(1, false);
            buttonComposite.setLayout((Layout)buttonLayout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 1;
            buttonComposite.setLayoutData((Object)gridData);
            Button addButton = new Button(buttonComposite, 8);
            addButton.setText(JptDbwsEclipseLinkUiMessages.JDBC_DRIVER_WIZARD_PAGE__ADD_BUTTON);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            addButton.setLayoutData((Object)gridData);
            addButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    ArrayList jarFiles = JarsGroup.this.promptJarFiles();
                    for (String jarFile : jarFiles) {
                        JdbcDriverWizardPage.this.addJarFile(jarFile);
                    }
                    tableViewer.refresh();
                }
            });
            Button removeButton = new Button(buttonComposite, 8);
            removeButton.setText(JptDbwsEclipseLinkUiMessages.JDBC_DRIVER_WIZARD_PAGE__REMOVE_BUTTON);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            removeButton.setLayoutData((Object)gridData);
            removeButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    StructuredSelection selection = (StructuredSelection)tableViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    String jarFile = (String)selection.getFirstElement();
                    JdbcDriverWizardPage.this.removeJarFile(jarFile);
                    tableViewer.refresh();
                }
            });
            addButton.setFocus();
        }

        private IBaseLabelProvider buildLabelProvider() {
            return new TableLabelProvider();
        }

        private IContentProvider buildContentProvider() {
            return new TableContentProvider();
        }

        private ArrayList<String> promptJarFiles() {
            String projectPath = this.getJavaProject().getProject().getLocation().toString();
            FileDialog dialog = new FileDialog(JdbcDriverWizardPage.this.getShell(), 2);
            dialog.setText(JptDbwsEclipseLinkUiMessages.JDBC_DRIVER_WIZARD_PAGE__CHOOSE_A_DRIVER_FILE);
            dialog.setFilterPath(projectPath);
            dialog.setFilterExtensions(new String[]{BINDINGS_FILE_FILTER});
            dialog.open();
            String path = dialog.getFilterPath();
            String[] fileNames = dialog.getFileNames();
            ArrayList<String> results = new ArrayList<String>(fileNames.length);
            String[] stringArray = fileNames;
            int n = fileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String fileName = stringArray[n2];
                results.add(String.valueOf(path) + File.separator + fileName);
                ++n2;
            }
            return results;
        }

        private void addColumnsData(TableLayoutComposite layout) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        }

        private Label buildLabel(Composite parent, int span, String text) {
            Label label = new Label(parent, 0);
            label.setText(text);
            GridData gd = new GridData();
            gd.horizontalSpan = span;
            label.setLayoutData((Object)gd);
            return label;
        }

        private class TableContentProvider
        implements IStructuredContentProvider {
            TableContentProvider() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }
        }

        private class TableLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            private TableLabelProvider() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                return (String)element;
            }
        }
    }
}

