/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.commands.processes;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.processes.ActivityEdge;
import org.eclipse.jwt.meta.model.processes.ActivityNode;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;

public class ReconnectActivityEdgeCommand
extends AbstractCommand {
    private EditingDomain editingDomain;
    private ActivityNode newSource;
    private ActivityNode newTarget;
    private Command removeExistingActivityEdgeCommand;
    private Command modifyActivityEdgeCommand;
    private boolean sourceChanged = false;
    private boolean targetChanged = false;
    private ActivityEdge oldEdge;
    private int maximumOutEdges = Integer.MAX_VALUE;
    private int maximumInEdges = Integer.MAX_VALUE;

    public ReconnectActivityEdgeCommand(EditingDomain editingDomain, ActivityEdge oldEdge) {
        this.editingDomain = editingDomain;
        this.oldEdge = oldEdge;
    }

    public void setMaximumInEdges(int maximumInEdges) {
        this.maximumInEdges = maximumInEdges;
    }

    public void setMaximumOutEdges(int maximumOutEdges) {
        this.maximumOutEdges = maximumOutEdges;
    }

    public void setNewSource(ActivityNode source) {
        this.newSource = source;
        if (source != null && source != this.getOldSource()) {
            this.sourceChanged = true;
        }
    }

    public void setNewTarget(ActivityNode target) {
        this.newTarget = target;
        if (target != null && target != this.getOldTarget()) {
            this.targetChanged = true;
        }
    }

    private ActivityNode getOldSource() {
        return this.oldEdge.getSource();
    }

    private ActivityNode getOldTarget() {
        return this.oldEdge.getTarget();
    }

    public boolean checkConnection() {
        if (!this.sourceChanged && !this.targetChanged) {
            return false;
        }
        if (this.sourceChanged && this.targetChanged) {
            return false;
        }
        if (this.sourceChanged && this.newSource == this.getOldTarget()) {
            return false;
        }
        return !this.targetChanged || this.newTarget != this.getOldSource();
    }

    public boolean canExecute() {
        if (this.editingDomain == null) {
            return false;
        }
        return this.checkConnection();
    }

    public void execute() {
        EReference feature;
        ActivityNode newSourceTarget;
        int maxEdges;
        this.removeExistingActivityEdgeCommand = null;
        this.modifyActivityEdgeCommand = null;
        EList<ActivityEdge> existingEdges = this.sourceChanged ? this.newSource.getOut() : this.newTarget.getIn();
        int n = maxEdges = this.sourceChanged ? this.maximumOutEdges : this.maximumInEdges;
        if (existingEdges != null && existingEdges.size() >= maxEdges) {
            this.removeExistingActivityEdgeCommand = DeleteCommand.create((EditingDomain)this.editingDomain, existingEdges);
        }
        if (this.sourceChanged) {
            newSourceTarget = this.newSource;
            feature = ProcessesPackage.Literals.ACTIVITY_EDGE__SOURCE;
        } else {
            newSourceTarget = this.newTarget;
            feature = ProcessesPackage.Literals.ACTIVITY_EDGE__TARGET;
        }
        this.modifyActivityEdgeCommand = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.oldEdge, (Object)feature, (Object)newSourceTarget);
        if (this.modifyActivityEdgeCommand.canExecute()) {
            if (this.removeExistingActivityEdgeCommand != null && this.removeExistingActivityEdgeCommand.canExecute()) {
                this.removeExistingActivityEdgeCommand.execute();
            }
            this.modifyActivityEdgeCommand.execute();
        }
    }

    public void undo() {
        this.modifyActivityEdgeCommand.undo();
        if (this.removeExistingActivityEdgeCommand != null) {
            this.removeExistingActivityEdgeCommand.undo();
        }
    }

    public void redo() {
        if (this.removeExistingActivityEdgeCommand != null) {
            this.removeExistingActivityEdgeCommand.redo();
        }
        this.modifyActivityEdgeCommand.redo();
    }

    public void dispose() {
        super.dispose();
        if (this.removeExistingActivityEdgeCommand != null) {
            this.removeExistingActivityEdgeCommand.dispose();
        }
        if (this.modifyActivityEdgeCommand != null) {
            this.modifyActivityEdgeCommand.dispose();
        }
    }
}

